/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import gnu.trove.TObjectIntHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Alphabet<T>
implements Serializable {
    private static final long serialVersionUID = 4484770200416066L;
    private TObjectIntHashMap<T> map = new TObjectIntHashMap();
    private List<T> entries = new ArrayList<T>();
    private boolean growing = true;

    public void stopGrowth() {
        this.growing = false;
    }

    public void startGrowth() {
        this.growing = true;
    }

    public int lookupIndex(T entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Can't lookup \"null\" in an Alphabet.");
        }
        int value = this.map.get(entry);
        if (value != 0) {
            return value;
        }
        if (this.growing) {
            this.entries.add(entry);
            value = this.entries.size();
            this.map.put(entry, value);
            return value;
        }
        return -1;
    }

    public T lookupObject(int index) {
        return this.entries.get(index);
    }

    public Object[] toArray() {
        return this.entries.toArray();
    }

    public boolean contains(Object entry) {
        return this.map.contains(entry);
    }

    public int size() {
        return this.entries.size();
    }

    public List<T> getEntries() {
        return new ArrayList<T>(this.entries);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (T entry : this.entries) {
            sb.append(this.lookupIndex(entry)).append(" <=> ").append(entry.toString()).append('\n');
        }
        return sb.toString();
    }
}

