/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.util;

import it.uniroma1.lcl.jlt.util.SuffixTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractSuffixTree {
    List<String> text = new ArrayList<String>();
    SuffixTreeNode root = null;
    int inputAlphabetSize = -1;

    public AbstractSuffixTree(List<String> text) {
        for (String t : text) {
            if (!t.endsWith("$")) {
                t = String.valueOf(t) + "\t$";
            }
            this.text.add(t);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String properties = "rankdir=LR; node[shape=box fillcolor=gray95 style=filled]\n";
        sb.append("digraph {\n" + properties + this.root + "}");
        return sb.toString();
    }

    public double search(String tabbed) {
        if (!tabbed.endsWith("$")) {
            tabbed = String.valueOf(tabbed) + "\t$";
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = tabbed.split("\t");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            list.add(t);
            ++n2;
        }
        return this.search(this.root, list);
    }

    private double search(SuffixTreeNode node, List<String> suffix) {
        Collection<SuffixTreeNode> children = node.children;
        for (SuffixTreeNode child : children) {
            int k = child.incomingEdge.matches(suffix);
            if (k <= 0) continue;
            while (k-- > 0) {
                suffix.remove(0);
            }
            if (suffix.isEmpty()) {
                return child.texts.size();
            }
            double v = this.search(child, suffix);
            if (!(v > 0.0)) continue;
            return v;
        }
        System.out.println(suffix);
        System.out.print("OPTIONS at " + node.id + ": ");
        for (SuffixTreeNode child : children) {
            System.out.print(String.valueOf(child.incomingEdge.label) + ",");
        }
        System.out.println();
        return 0.0;
    }
}

