/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.ukwac.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UKWacCompound
implements Iterable<String> {
    private int offset;
    private List<String> words;

    public UKWacCompound(int offset, String text) {
        this(offset);
        this.add(text);
    }

    public UKWacCompound(int offset) {
        this.offset = offset;
        this.words = new ArrayList<String>();
    }

    public void add(String word) {
        this.words.add(word);
    }

    public void addAll(List<String> words) {
        words.addAll(words);
    }

    public int size() {
        return this.words.size();
    }

    public int getOffset() {
        return this.offset;
    }

    public int getEndOffset() {
        return this.offset + this.words.size();
    }

    public List<String> getWords() {
        return this.words;
    }

    public boolean hasEmptyIntersection(UKWacCompound compound) {
        for (String s1 : this.words) {
            for (String s2 : compound.getWords()) {
                if (!s1.equals(s2)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (String string : this.words) {
            buffer.append(string);
            buffer.append(" ");
        }
        return buffer.toString().trim();
    }

    @Override
    public Iterator<String> iterator() {
        return this.words.iterator();
    }
}

