/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.ukwac;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.pipeline.stanford.StanfordSentence;
import it.uniroma1.lcl.jlt.ukwac.data.UKWacText;
import it.uniroma1.lcl.jlt.ukwac.iterator.UKWacDumpIterator;
import it.uniroma1.lcl.jlt.util.CounterReader;
import it.uniroma1.lcl.jlt.util.CounterWriter;
import it.uniroma1.lcl.jlt.util.IntegerCounter;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class UKWac {
    private static UKWac instance = null;
    private IntegerCounter<String> ukwacWordlist = null;

    private UKWac() {
        this.getUkWacWordlist();
    }

    public static UKWac getInstance() {
        if (instance == null) {
            instance = new UKWac();
        }
        return instance;
    }

    public IntegerCounter<String> getUkWacWordlist() {
        return this.getUkWacWordlist(0);
    }

    public IntegerCounter<String> getUkWacWordlist(int minFrequency) {
        if (this.ukwacWordlist != null) {
            return this.ukwacWordlist;
        }
        try {
            File f = new File(Configuration.getInstance().getUkwacWordlistFilepath());
            if (!f.exists()) {
                new CounterWriter<String>(this.getWordNetWordCounts(minFrequency)).writeTo(Configuration.getInstance().getUkwacWordlistFilepath());
            }
            this.ukwacWordlist = new IntegerCounter();
            CounterReader cr = new CounterReader();
            this.ukwacWordlist = cr.readFrom(Configuration.getInstance().getUkwacWordlistFilepath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.ukwacWordlist;
    }

    public int getUkwacFrequency(String word) {
        Integer freq = (Integer)this.ukwacWordlist.get(word.toLowerCase());
        if (freq == null) {
            return 0;
        }
        return freq;
    }

    private IntegerCounter<String> getWordNetWordCounts(int minFrequency) {
        IntegerCounter<String> wordList = new IntegerCounter<String>();
        UKWacDumpIterator ukwdi = new UKWacDumpIterator();
        int counter = 0;
        try {
            List<String> posTagList = Arrays.asList("N");
            ukwdi.open();
            while (ukwdi.hasNext()) {
                UKWacText ukwt = ukwdi.next();
                Iterator<StanfordSentence> iterator = ukwt.iterator();
                while (iterator.hasNext()) {
                    if (++counter % 10000 == 0) {
                        System.out.println(counter);
                    }
                    StanfordSentence ss = iterator.next();
                    try {
                        List<String> compounds = ss.getTerms(posTagList, true, false, false, StanfordSentence.MultiwordBelongingTo.WORDNET);
                        for (String compound : compounds) {
                            wordList.count(compound);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            ukwdi.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        if (minFrequency > 0) {
            for (String word : wordList.keySet()) {
                if ((Integer)wordList.get(word) >= minFrequency) continue;
                wordList.remove(word);
            }
        }
        return wordList;
    }

    public static void main(String[] args) {
        UKWac ukWac = UKWac.getInstance();
        IntegerCounter<String> ukWacWordList = ukWac.getUkWacWordlist(50);
        System.out.println("WordList size: " + ukWacWordList.size());
        System.out.println("Counts for computer: " + ukWac.getUkwacFrequency("computer"));
    }
}

