/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.stores;

import it.uniroma1.lcl.jlt.stores.StoreType;
import it.uniroma1.lcl.jlt.stores.StoredMapping;
import java.io.File;
import tokyocabinet.BDB;
import tokyocabinet.DBM;
import tokyocabinet.HDB;

public class TokyoCabinet
implements StoredMapping<String, String> {
    private final DBM db;

    public TokyoCabinet(String location) {
        this(location, StoreType.HASH_TABLE);
    }

    public TokyoCabinet(String location, StoreType sType) {
        switch (sType) {
            case HASH_TABLE: {
                this.db = new HDB();
                ((HDB)this.db).open(String.valueOf(location) + sType.getFileExtension(), 6);
                break;
            }
            case BTREE: {
                this.db = new BDB();
                ((BDB)this.db).open(String.valueOf(location) + sType.getFileExtension(), 6);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown StoreType: " + (Object)((Object)sType));
            }
        }
    }

    @Override
    public void close() {
        if (this.db instanceof HDB) {
            ((HDB)this.db).close();
        } else if (this.db instanceof BDB) {
            ((BDB)this.db).close();
        }
    }

    @Override
    public String get(String key) {
        return this.db.get(key);
    }

    @Override
    public void put(String key, String value) {
        this.db.put(key, value);
    }

    public void putInteger(String key, int value) {
        this.db.addint(key, value);
    }

    public void putDouble(String key, double value) {
        this.db.adddouble(key, value);
    }

    public boolean isEmpty() {
        return this.db.rnum() == 0L;
    }

    public static void main(String[] args) {
        TokyoCabinet test = new TokyoCabinet("TEST");
        System.out.println("ISEMPTY? " + test.isEmpty());
        test.put("key_1", "value_1");
        test.put("key_2", "value_2");
        test.put("key_3", "value_3");
        System.out.println("ISEMPTY? " + test.isEmpty());
        test.close();
        new File("TEST.kch").delete();
    }
}

