/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.stores;

import it.uniroma1.lcl.jlt.stores.StoreType;
import it.uniroma1.lcl.jlt.stores.StoredMapping;
import kyotocabinet.DB;

public class KyotoCabinet
implements StoredMapping<String, String> {
    private final DB db = new DB();

    public KyotoCabinet(String location) {
        this(location, StoreType.HASH_TABLE);
    }

    public KyotoCabinet(String location, StoreType sType) {
        switch (sType) {
            case HASH_TABLE: 
            case BTREE: {
                this.db.open(String.valueOf(location) + sType.getFileExtension(), 6);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown StoreType: " + (Object)((Object)sType));
            }
        }
    }

    @Override
    public void close() {
        this.db.close();
    }

    @Override
    public void put(String key, String value) {
        this.db.set(key, value);
    }

    public void putInteger(String key, int value) {
        this.db.increment(key, (long)value);
    }

    public void putDouble(String key, double value) {
        this.db.increment_double(key, value);
    }

    @Override
    public String get(String key) {
        return this.db.get(key);
    }
}

