/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.stores;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.collections.StoredMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.util.RuntimeExceptionWrapper;
import it.uniroma1.lcl.jlt.stores.StoredMapping;
import it.uniroma1.lcl.jlt.util.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BerkeleyDB<K, V>
implements StoredMapping<K, V> {
    protected static final Log log = LogFactory.getLog(BerkeleyDB.class);
    private transient Environment dbEnv;
    private transient Database db;
    private transient Database classCatalogDb;
    private transient EntryBinding<K> keyDatabinding;
    private transient EntryBinding<V> valueDatabinding;
    private transient StoredMap<K, V> mapView;

    public BerkeleyDB(String location, String dbName, Class<K> keyClass, Class<V> valueClass) {
        this(new File(location), dbName, keyClass, valueClass, true);
    }

    public BerkeleyDB(File location, String dbName, Class<K> keyClass, Class<V> valueClass) {
        this(location, dbName, keyClass, valueClass, true);
    }

    public BerkeleyDB(String location, String dbName, Class<K> keyClass, Class<V> valueClass, boolean allowSortedDuplicates) {
        this(new File(location), dbName, keyClass, valueClass, allowSortedDuplicates, false);
    }

    public BerkeleyDB(File location, String dbName, Class<K> keyClass, Class<V> valueClass, boolean allowSortedDuplicates) {
        this(location, dbName, keyClass, valueClass, allowSortedDuplicates, false);
    }

    public BerkeleyDB(String location, String dbName, Class<K> keyClass, Class<V> valueClass, boolean allowSortedDuplicates, boolean readOnly) {
        this(new File(location), dbName, keyClass, valueClass, allowSortedDuplicates, readOnly);
    }

    public BerkeleyDB(File location, String dbName, Class<K> keyClass, Class<V> valueClass, boolean allowSortedDuplicates, boolean readOnly) {
        this.createDBEnvironment(location);
        this.initDB(dbName, keyClass, valueClass, allowSortedDuplicates, readOnly);
    }

    private void createDBEnvironment(File location) {
        if (!location.exists()) {
            location.mkdirs();
        }
        try {
            EnvironmentConfig envConfig = new EnvironmentConfig();
            envConfig.setCachePercent(60);
            envConfig.setAllowCreate(true);
            envConfig.setConfigParam("je.log.fileMax", "100000000");
            this.dbEnv = new Environment(location, envConfig);
        }
        catch (DatabaseException dbe) {
            dbe.printStackTrace();
        }
    }

    private void initDB(String dbName, Class<K> keyClass, Class<V> valueClass, boolean allowSortedDuplicates, boolean readOnly) {
        try {
            DatabaseConfig dbConfig = new DatabaseConfig();
            if (!readOnly) {
                dbConfig.setAllowCreate(true);
            }
            dbConfig.setReadOnly(readOnly);
            this.classCatalogDb = this.dbEnv.openDatabase(null, String.valueOf(dbName) + "_class_catalog", dbConfig);
            StoredClassCatalog classCatalog = new StoredClassCatalog(this.classCatalogDb);
            this.keyDatabinding = TupleBinding.getPrimitiveBinding(keyClass);
            if (this.keyDatabinding == null) {
                this.keyDatabinding = new SerialBinding((ClassCatalog)classCatalog, keyClass);
            }
            this.valueDatabinding = TupleBinding.getPrimitiveBinding(valueClass);
            if (this.valueDatabinding == null) {
                new SerialBinding((ClassCatalog)classCatalog, valueClass);
            }
            dbConfig.setSortedDuplicates(allowSortedDuplicates);
            this.db = this.dbEnv.openDatabase(null, dbName, dbConfig);
            this.mapView = new StoredMap(this.db, this.keyDatabinding, this.valueDatabinding, true);
        }
        catch (DatabaseException dbe) {
            dbe.printStackTrace();
        }
    }

    @Override
    public void put(K key, V value) {
        if (value != null) {
            try {
                this.mapView.put(key, value);
            }
            catch (RuntimeExceptionWrapper dbe) {
                dbe.printStackTrace();
            }
        }
    }

    @Override
    public V get(K key) {
        try {
            return (V)this.mapView.get(key);
        }
        catch (RuntimeExceptionWrapper dbe) {
            dbe.printStackTrace();
            return null;
        }
    }

    public Collection<V> getAll(K key) {
        try {
            return this.mapView.duplicates(key);
        }
        catch (RuntimeExceptionWrapper dbe) {
            dbe.printStackTrace();
            return null;
        }
    }

    public boolean containsKey(K key) {
        try {
            return this.mapView.containsKey(key);
        }
        catch (RuntimeExceptionWrapper dbe) {
            dbe.printStackTrace();
            return false;
        }
    }

    @Override
    public void close() {
        try {
            this.db.close();
            this.classCatalogDb.close();
            this.dbEnv.close();
        }
        catch (DatabaseException dbe) {
            dbe.printStackTrace();
        }
    }

    public StoredMap<K, V> getAsMap() {
        return this.mapView;
    }

    public static <V> void queryContent(BerkeleyDB<String, V> db) {
        String user = "";
        while (true) {
            System.out.println("Please enter a key, then press <return> (type \"exit\" to quit)");
            BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
            try {
                user = input.readLine();
                if (user.startsWith("exit")) {
                    System.out.println("QUITTING, thank you ... ");
                    break;
                }
                System.out.println("SHOWING DB RECORD: " + user + " => " + db.getAll(user));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        try {
            BerkeleyDB<String, String> db = new BerkeleyDB<String, String>("tmp", "TMP_DB", String.class, String.class);
            db.put("Simone", "32");
            db.put("Simone", "33");
            db.put("Karin", "38");
            db.put("Roberto", "31");
            db.close();
            System.out.println("=================TESTING BDB==================\n");
            db = new BerkeleyDB<String, String>("tmp", "TMP_DB", String.class, String.class, true, true);
            StoredMap<String, String> map = db.getAsMap();
            System.out.println("NO DUPS:");
            for (String key : map.keySet()) {
                System.out.println("\tENTRY: " + key + "=>" + (String)map.get((Object)key));
            }
            System.out.println("\nWITH DUPS:");
            for (String key : map.keySet()) {
                System.out.println("\tENTRY: " + key + "=>" + map.duplicates((Object)key));
            }
            System.out.println("\n=============================================");
            BerkeleyDB.queryContent(db);
            db.close();
            Files.deleteDirectory(new File("tmp"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Environment getDBEnvironment() {
        return this.dbEnv;
    }
}

