/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.stats;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FleissKappa {
    private static final Log log = LogFactory.getLog(FleissKappa.class);

    public static float computeKappa(short[][] mat) {
        int i;
        int n = FleissKappa.checkEachLineCount(mat);
        int N = mat.length;
        int k = mat[0].length;
        log.info((Object)(String.valueOf(n) + " raters."));
        log.info((Object)(String.valueOf(N) + " instances."));
        log.info((Object)(String.valueOf(k) + " categories."));
        float pSum = 0.0f;
        float[] p = new float[k];
        int j = 0;
        while (j < k) {
            p[j] = 0.0f;
            i = 0;
            while (i < N) {
                int n2 = j;
                p[n2] = p[n2] + (float)mat[i][j];
                ++i;
            }
            int n3 = j;
            p[n3] = p[n3] / (float)(N * n);
            pSum += p[j];
            ++j;
        }
        log.info((Object)("p = " + Arrays.toString(p) + " sum = " + pSum));
        float[] P = new float[N];
        i = 0;
        while (i < N) {
            P[i] = 0.0f;
            int j2 = 0;
            while (j2 < k) {
                int n4 = i;
                P[n4] = P[n4] + (float)(mat[i][j2] * mat[i][j2]);
                ++j2;
            }
            P[i] = (P[i] - (float)n) / (float)(n * (n - 1));
            ++i;
        }
        log.info((Object)("P = " + Arrays.toString(P)));
        float Pbar = 0.0f;
        float[] fArray = P;
        int n5 = P.length;
        int n6 = 0;
        while (n6 < n5) {
            float Pi = fArray[n6];
            Pbar += Pi;
            ++n6;
        }
        log.info((Object)("Pbar = " + (Pbar /= (float)N)));
        float PbarE = 0.0f;
        float[] fArray2 = p;
        int n7 = p.length;
        n5 = 0;
        while (n5 < n7) {
            float pj = fArray2[n5];
            PbarE += pj * pj;
            ++n5;
        }
        log.info((Object)("PbarE = " + PbarE));
        float kappa = (Pbar - PbarE) / (1.0f - PbarE);
        log.info((Object)("kappa = " + kappa));
        return kappa;
    }

    private static int checkEachLineCount(short[][] mat) {
        int raters = 0;
        boolean firstLine = true;
        short[][] sArray = mat;
        int n = mat.length;
        int n2 = 0;
        while (n2 < n) {
            short[] instance = sArray[n2];
            int count = 0;
            short[] sArray2 = instance;
            int n3 = instance.length;
            int n4 = 0;
            while (n4 < n3) {
                short cell = sArray2[n4];
                count += cell;
                ++n4;
            }
            if (firstLine) {
                raters = count;
                firstLine = false;
            }
            if (count != raters) {
                throw new IllegalArgumentException("Line count: " + count + " != " + raters + " (raters value).");
            }
            ++n2;
        }
        return raters;
    }
}

