/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.stats;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AgreementMatrix<T> {
    private static final Log log = LogFactory.getLog(AgreementMatrix.class);
    private Map<T, short[]> ratings = new HashMap<T, short[]>();

    public short[][] toMatrix() {
        int raters = 0;
        int instanceIndex = 0;
        boolean firstLine = true;
        short[][] mat = new short[this.ratings.size()][];
        for (T key : this.ratings.keySet()) {
            short[] instanceRatings;
            int count = 0;
            short[] sArray = instanceRatings = this.ratings.get(key);
            int n = instanceRatings.length;
            int n2 = 0;
            while (n2 < n) {
                short cell = sArray[n2];
                count += cell;
                ++n2;
            }
            if (firstLine) {
                raters = count;
                firstLine = false;
            }
            if (count != raters) {
                throw new IllegalArgumentException("Line count for " + key + ": " + count + " != " + raters + " (raters value).");
            }
            mat[instanceIndex] = instanceRatings;
            ++instanceIndex;
        }
        return mat;
    }

    protected short[] getInstanceRating(T instance) {
        return this.ratings.get(instance);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (T key : this.ratings.keySet()) {
            buffer.append(key).append("\t").append(Arrays.toString(this.ratings.get(key))).append("\n");
        }
        return buffer.toString();
    }

    public void fill(int n) {
        HashMap<T, short[]> newRatings = new HashMap<T, short[]>();
        for (T key : this.ratings.keySet()) {
            short[] instanceRatings = this.ratings.get(key);
            int elems = instanceRatings.length;
            if (elems == n) {
                newRatings.put(key, instanceRatings);
                continue;
            }
            if (elems > n) {
                log.warn((Object)("Cannot fill: " + instanceRatings.length + ">" + n));
                continue;
            }
            short[] newInstanceRatings = new short[n];
            int i = 0;
            while (i < elems) {
                newInstanceRatings[i] = instanceRatings[i];
                ++i;
            }
            while (i < n) {
                newInstanceRatings[i] = 0;
                ++i;
            }
            newRatings.put(key, newInstanceRatings);
        }
        this.ratings = newRatings;
    }

    public void putRatingForInstance(T instance, short[] rating) {
        this.ratings.put(instance, rating);
    }
}

