/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.ser;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.index.Record;
import it.uniroma1.lcl.jlt.index.lucene.LuceneIndex;
import it.uniroma1.lcl.jlt.ser.SerializationField;
import it.uniroma1.lcl.jlt.util.Files;
import it.uniroma1.lcl.jlt.util.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Version;

public class ObjectSerializer<T> {
    private static final Log log = LogFactory.getLog(ObjectSerializer.class);
    private String className;
    private String id;
    private boolean applyNameHashing;
    private int k;
    private Indexing indexing;

    public ObjectSerializer(String className, String id) {
        this(className, id, Indexing.LUCENE);
    }

    public ObjectSerializer(String className, String id, Indexing indexing) {
        this(className, id, indexing, false, 0);
    }

    public ObjectSerializer(String className, String id, Indexing indexing, boolean bApplyNameHashing) {
        this(className, id, indexing, bApplyNameHashing, 2);
    }

    public ObjectSerializer(String className, String id, Indexing indexing, boolean bApplyNameHashing, int k) {
        if (!Configuration.getInstance().isSerializationConfigured()) {
            throw new RuntimeException("Serialization settings not found in " + Configuration.CONFIG_FILE);
        }
        this.className = className;
        this.id = id;
        this.applyNameHashing = bApplyNameHashing;
        this.k = k;
        this.indexing = indexing;
    }

    public Indexing getIndexing() {
        return this.indexing;
    }

    public String getUniqueName() {
        return String.valueOf(this.id) + "@" + this.className;
    }

    public T loadFromSER() {
        String fileName = null;
        try {
            if (this.indexing == Indexing.LUCENE) {
                Record result1;
                int k;
                LuceneIndex idx = new LuceneIndex(this.getLuceneDirectory());
                List<Pair<String, String>> constraints = Configuration.getInstance().getClassSerializationParameterValues(this.className);
                if (constraints.size() == 0) {
                    constraints.add(new Pair<String, String>("ID", this.id));
                    log.info((Object)("No constraint specified in ser.properties for: " + this.className));
                }
                List<Record> results = idx.getRecords(constraints);
                idx.close();
                if (results.size() > 0 && (k = (fileName = (result1 = results.get(0)).get(SerializationField.FILENAME.toString())).lastIndexOf(47)) != -1) {
                    fileName = fileName.substring(k + 1);
                }
            } else {
                fileName = "1.ser";
            }
            if (fileName != null) {
                String fullFileName = String.valueOf(this.getStoreDirectory()) + "/" + fileName;
                Object object = null;
                FileInputStream fis = null;
                ObjectInputStream in = null;
                fis = new FileInputStream(fullFileName);
                in = new ObjectInputStream(fis);
                object = in.readObject();
                in.close();
                log.info((Object)(String.valueOf(fileName) + " LOADED."));
                return (T)object;
            }
        }
        catch (IOException e) {
            log.error((Object)(String.valueOf(this.getStoreDirectory()) + "/" + fileName + " not found."));
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("SERIALIZATION ERROR WHILE LOADING OBJECT WITH ID = " + this.id));
            e.printStackTrace();
        }
        return null;
    }

    public void saveToSER(T object) {
        IndexWriter writer = null;
        String thisFileName = null;
        String storeDir = this.getStoreDirectory();
        new File(String.valueOf(storeDir) + File.separator).mkdirs();
        if (this.indexing == Indexing.LUCENE) {
            LuceneIndex idx = null;
            List<Object> results = new ArrayList();
            boolean bCreate = false;
            List<Pair<String, String>> constraints = Configuration.getInstance().getClassSerializationParameterValues(this.className);
            if (constraints.size() == 0) {
                log.info((Object)("No constraint specified in ser.properties for: " + this.className));
            }
            try {
                idx = new LuceneIndex(this.getLuceneDirectory());
                constraints.add(new Pair<String, String>(SerializationField.ID.toString(), this.id));
                results = idx.getRecords(constraints);
                if (results.size() > 0) {
                    Record result1 = (Record)results.get(0);
                    thisFileName = result1.get(SerializationField.FILENAME.toString());
                    idx.removeRecords(constraints);
                }
                idx.close();
            }
            catch (IOException e) {
                bCreate = true;
            }
            if (thisFileName == null) {
                thisFileName = this.getNextFileName();
            }
            try {
                String luceneDir = this.getLuceneDirectory();
                try {
                    SimpleFSDirectory fsDirectory = new SimpleFSDirectory(new File(luceneDir));
                    writer = new IndexWriter((Directory)fsDirectory, (Analyzer)new StandardAnalyzer(Version.LUCENE_29), bCreate, IndexWriter.MaxFieldLength.UNLIMITED);
                }
                catch (IOException f) {
                    log.error((Object)("Cannot create index " + luceneDir));
                    f.printStackTrace();
                }
                Document doc = new Document();
                if (bCreate) {
                    doc.add((Fieldable)new Field(SerializationField.ID.toString(), this.id, Field.Store.YES, Field.Index.NOT_ANALYZED));
                }
                doc.add((Fieldable)new Field(SerializationField.FILENAME.toString(), thisFileName, Field.Store.YES, Field.Index.NO));
                for (Pair<String, String> pair : constraints) {
                    doc.add((Fieldable)new Field(pair.getFirst(), pair.getSecond(), Field.Store.YES, Field.Index.NOT_ANALYZED));
                }
                writer.addDocument(doc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            thisFileName = "1.ser";
        }
        try {
            FileOutputStream fos = null;
            ObjectOutputStream out = null;
            String fullNextFileName = String.valueOf(this.getStoreDirectory()) + "/" + thisFileName;
            log.info((Object)("SERIALIZATION OF: " + fullNextFileName));
            fos = new FileOutputStream(fullNextFileName);
            out = new ObjectOutputStream(fos);
            out.writeObject(object);
            out.close();
            log.info((Object)(String.valueOf(thisFileName) + " SERIALIZED"));
            if (writer != null) {
                writer.optimize();
                writer.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getLuceneDirectory() {
        String path = null;
        path = this.applyNameHashing ? Files.getFullPathWithAlphabeticalHashing(Configuration.getInstance().getSerializationDir(), String.valueOf(this.getUniqueName()) + "/idx", this.k) : String.valueOf(Configuration.getInstance().getSerializationDir()) + "/" + this.getUniqueName() + "/idx";
        return path;
    }

    private String getStoreDirectory() {
        String path = null;
        path = this.applyNameHashing ? Files.getFullPathWithAlphabeticalHashing(Configuration.getInstance().getSerializationDir(), String.valueOf(this.getUniqueName()) + "/store", this.k) : String.valueOf(Configuration.getInstance().getSerializationDir()) + "/" + this.getUniqueName() + "/store";
        return path;
    }

    private String getNextFileName() {
        String storeDir = this.getStoreDirectory();
        int max = 0;
        File dir = new File(storeDir);
        if (dir.exists()) {
            String[] stringArray = dir.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String k = stringArray[n2];
                try {
                    int v;
                    if (k.endsWith(".ser") && max < (v = Integer.parseInt(k.substring(0, k.length() - 4)))) {
                        max = v;
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        return String.valueOf(max + 1) + ".ser";
    }

    public static void main(String[] args) {
        ObjectSerializer<String> ser = new ObjectSerializer<String>("java.lang.String", "pippo", Indexing.LUCENE);
        String s = "stringa di pippo";
        ser.saveToSER(s);
        String t = (String)ser.loadFromSER();
        System.out.println(t);
        ObjectSerializer<String> ser2 = new ObjectSerializer<String>("java.lang.String", "supercalifragi", Indexing.NO, true);
        String s2 = "MaryPopppins";
        ser2.saveToSER(s2);
        String t2 = (String)ser2.loadFromSER();
        System.out.println(t2);
        ObjectSerializer<String> ser3 = new ObjectSerializer<String>("java.lang.String", "superman", Indexing.LUCENE, true);
        String s3 = "SUPERMAN";
        ser3.saveToSER(s3);
        String t3 = (String)ser3.loadFromSER();
        System.out.println(t3);
        ObjectSerializer<String> ser4 = new ObjectSerializer<String>("java.lang.String", "supermercato", Indexing.NO, false);
        String s4 = "SuperMercato";
        ser4.saveToSER(s4);
        String t4 = (String)ser4.loadFromSER();
        System.out.println(t4);
        ObjectSerializer<String> ser5 = new ObjectSerializer<String>("java.lang.String", "supermercatoScoperto", Indexing.NO, true, 5);
        String s5 = "SuperMercatoScoperto";
        ser5.saveToSER(s5);
        String t5 = (String)ser5.loadFromSER();
        System.out.println(t5);
    }

    public static enum Indexing {
        LUCENE,
        NO;

    }
}

