/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.semeval10.util;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.collocs.enumeration.CollocsDB;
import it.uniroma1.lcl.jlt.semeval07.wsi.Semeval07WSI;
import it.uniroma1.lcl.jlt.semeval07.wsi.Semeval07WSIInstance;
import it.uniroma1.lcl.jlt.semeval10.Semeval10;
import it.uniroma1.lcl.jlt.semeval10.data.SemevalInstance;
import it.uniroma1.lcl.jlt.util.WeightedUnorderedPair;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SemevalSimilarityCalculator {
    protected static final Log log = LogFactory.getLog(SemevalSimilarityCalculator.class);
    protected NumberFormat nf = NumberFormat.getInstance(Locale.UK);
    protected String word;
    protected HashMap<Integer, SemevalInstance> hash;
    protected BufferedReader br;
    protected String similarityPath;

    public SemevalSimilarityCalculator(String word, String similarityPath) {
        this.nf.setMaximumFractionDigits(5);
        this.word = word;
        this.similarityPath = similarityPath;
        new File(similarityPath).mkdirs();
    }

    public static void main(String[] args) throws IOException {
        String word = args[0];
        String filename = args[1];
        new SemevalSimilarityCalculator(word, filename).storeSimilarities();
    }

    public void storeSimilarities() {
        SemevalInstance[] list = Semeval10.getInstance().getInstances(this.word, CollocsDB.SEMEVAL10_TRAIN).toArray(new SemevalInstance[0]);
        String filename = String.valueOf(this.similarityPath) + "/" + this.word + "." + Configuration.getInstance().getBncVectorMethod() + ".vectorsim";
        log.info((Object)("Storing SemEval similarities for the target word " + this.word + " (file: " + filename + ")"));
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
            int i = 0;
            while (i < list.length) {
                SemevalInstance ci = list[i];
                int j = i + 1;
                while (j < list.length) {
                    SemevalInstance cj = list[j];
                    bw.write(String.valueOf(ci.getId()) + " " + cj.getId() + " " + this.nf.format(ci.bow_similarity(cj)) + "\n");
                    ++j;
                }
                ++i;
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.info((Object)("Finished storing SemEval similarities for the target word " + this.word));
    }

    public void store07Similarities() {
        Semeval07WSIInstance[] list = Semeval07WSI.getInstance().getInstances(this.word).toArray(new Semeval07WSIInstance[0]);
        String filename = String.valueOf(this.similarityPath) + "/" + this.word + "." + Configuration.getInstance().getBncVectorMethod() + ".vectorsim";
        log.info((Object)("Storing SemEval similarities for the target word " + this.word + " (file: " + filename + ")"));
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
            int i = 0;
            while (i < list.length) {
                Semeval07WSIInstance ci = list[i];
                int j = i + 1;
                while (j < list.length) {
                    Semeval07WSIInstance cj = list[j];
                    bw.write(String.valueOf(ci.getNumber()) + " " + cj.getNumber() + " " + this.nf.format(ci.bow_similarity(cj)) + "\n");
                    ++j;
                }
                ++i;
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.info((Object)("Finished storing SemEval similarities for the target word " + this.word));
    }

    public void open() {
        String filename = String.valueOf(this.similarityPath) + "/" + this.word + "." + Configuration.getInstance().getBncVectorMethod() + ".vectorsim";
        log.info((Object)("Opening SemEval similarities for the target word " + this.word + " (file: " + filename + ")"));
        try {
            this.br = new BufferedReader(new FileReader(filename));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        log.info((Object)("Closing SemEval similarities for the target word " + this.word));
        try {
            this.br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public WeightedUnorderedPair<Integer> getNextSimilarity() {
        String line = null;
        try {
            line = this.br.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (line == null) {
            return null;
        }
        String[] pieces = line.split(" ");
        double value = new Double(pieces[2]);
        return new WeightedUnorderedPair<Integer>(new Integer(pieces[0]), new Integer(pieces[1]), value);
    }
}

