/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.semeval07;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import it.uniroma1.lcl.jlt.pipeline.stanford.DataProcessor;
import it.uniroma1.lcl.jlt.pipeline.stanford.StanfordSentence;
import it.uniroma1.lcl.jlt.semeval07.Semeval07;
import it.uniroma1.lcl.jlt.util.EnglishLemmatizer;
import it.uniroma1.lcl.jlt.util.IntegerCounter;
import it.uniroma1.lcl.jlt.util.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Semeval07Instance {
    protected static final Log log = LogFactory.getLog(Semeval07.class);
    protected String sentence;
    protected String textId;
    protected String sentenceNumber;
    protected ArrayList<String> plainTargetWords = new ArrayList();
    protected List<String> posTaggedWNwords;
    protected ArrayList<String> posTaggedTargetWords = new ArrayList();
    protected HashMultimap<String, String> lemmaPosesMap = new HashMultimap();
    protected ArrayListMultimap<String, String> ids = new ArrayListMultimap();
    protected static final String UNWANTED_SYMBOLS = "\"|'|\\.|~|\\,|;|!|\\?|:|\\(|\\)|\\[|\\]";
    protected static EnglishLemmatizer lemmatizer;

    public Semeval07Instance(String content, String textId, int number) {
        this.sentence = content;
        this.textId = textId;
        this.sentenceNumber = "s" + number;
        try {
            StanfordSentence taggedSentence = new StanfordSentence(DataProcessor.getInstance().processSentence(this.sentence.replaceAll(UNWANTED_SYMBOLS, "")));
            this.posTaggedWNwords = taggedSentence.getTerms(Arrays.asList("n", "j", "v", "r"), false, false, true, StanfordSentence.MultiwordBelongingTo.WORDNET);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            lemmatizer = new EnglishLemmatizer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addTargetWord(String targetWord, String id) {
        int size = this.posTaggedTargetWords.size();
        boolean needToPos = true;
        if (targetWord.startsWith("hint:")) {
            String old = new String(targetWord);
            targetWord = targetWord.split("hint:")[1];
            needToPos = false;
            log.debug((Object)("I've found that i should follow the hint for target word '" + old + "' : new target word => '" + targetWord + "'"));
        }
        this.plainTargetWords.add(targetWord);
        if (needToPos) {
            try {
                StanfordSentence stanfordTaggedWord = new StanfordSentence(DataProcessor.getInstance().processSentence(targetWord.replaceAll(UNWANTED_SYMBOLS, "")));
                List<String> taggedWords = stanfordTaggedWord.getTerms(Arrays.asList("n", "v", "j", "r"), false, false, true, StanfordSentence.MultiwordBelongingTo.WORDNET);
                if (taggedWords.isEmpty()) {
                    log.error((Object)("Could not find any lemmatization for word " + targetWord + " with id=" + id));
                    return;
                }
                ArrayList<String> extendedTaggedWords = new ArrayList<String>();
                extendedTaggedWords.addAll(taggedWords);
                extendedTaggedWords.addAll(lemmatizer.getLemmasWithPos(targetWord));
                for (String taggedWord : taggedWords) {
                    this.posTaggedTargetWords.add(taggedWord);
                }
                for (String taggedWord : extendedTaggedWords) {
                    this.lemmaPosesMap.put((Object)Strings.getLemma(taggedWord), (Object)taggedWord);
                    this.ids.put((Object)taggedWord, (Object)id);
                }
                if (extendedTaggedWords.size() > 1) {
                    log.debug((Object)("MULTIPLE:" + extendedTaggedWords));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.posTaggedTargetWords.add(targetWord);
            this.ids.put((Object)targetWord, (Object)id);
        }
        if (this.posTaggedTargetWords.size() == size) {
            log.info((Object)("ERROR: I've added no target word : " + targetWord + " id=" + id));
        }
    }

    public List<String> getWords() {
        ArrayList<String> words = new ArrayList<String>();
        words.addAll(Arrays.asList(this.sentence.split(" ")));
        return words;
    }

    public String getSentence() {
        return this.sentence;
    }

    public String getSentenceNumber() {
        return this.sentenceNumber;
    }

    public String getTextId() {
        return this.textId;
    }

    public String getSentenceID() {
        return String.valueOf(this.getTextId()) + "." + this.getSentenceNumber();
    }

    public List<String> getRealPosTaggedWords() {
        ArrayList<String> realPosTaggedTargetWords = new ArrayList<String>();
        for (String word : this.getPosTaggedWords()) {
            for (String s : this.lemmaPosesMap.get((Object)Strings.getLemma(word))) {
                if (!s.equals(word) || !this.ids.containsKey((Object)s)) continue;
                realPosTaggedTargetWords.add(s);
            }
        }
        return realPosTaggedTargetWords;
    }

    public List<String> getPosTaggedWords() {
        return this.posTaggedWNwords;
    }

    public List<String> getTargetWords() {
        return this.plainTargetWords;
    }

    public List<String> getPosTaggedTargetWords() {
        return this.posTaggedTargetWords;
    }

    public boolean isTargetWord(String word) {
        return this.posTaggedTargetWords.contains(word);
    }

    public String getTargetWordID(String word, int i) {
        return (String)this.ids.get((Object)word).get(i);
    }

    public String toSemevalString() {
        StringBuffer buffer = new StringBuffer();
        IntegerCounter<String> timesEncountered = new IntegerCounter<String>();
        for (String tw : this.getRealPosTaggedWords()) {
            timesEncountered.count(tw);
            buffer.append(String.valueOf(this.textId) + "\n");
            int i = 0;
            HashSet<String> encountered = new HashSet<String>();
            for (String word : this.getPosTaggedWords()) {
                if (encountered.contains(word)) continue;
                encountered.add(word);
                boolean isTarget = word.equals(tw) && timesEncountered.getTotal() < (double)this.getRealPosTaggedWords().size();
                int disambiguate = isTarget ? 1 : 0;
                String id = isTarget ? this.getTargetWordID(word, (Integer)timesEncountered.get(word) - 1) : new String(String.valueOf(i));
                buffer.append(" " + word + "#" + id + "#" + disambiguate);
                ++i;
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(this.textId) + "-" + this.getSentenceNumber() + ") ");
        int i = 0;
        for (String word : this.getWords()) {
            if (i < this.plainTargetWords.size() && this.plainTargetWords.get(i).equals(word)) {
                buffer.append(" t:" + word);
                ++i;
                continue;
            }
            buffer.append(" " + word);
        }
        return buffer.toString();
    }
}

