/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.semeval07;

import com.google.common.collect.Lists;
import edu.mit.jwi.item.ISenseKey;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.IWord;
import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.collocs.enumeration.CollocsDB;
import it.uniroma1.lcl.jlt.minipar.MiniparSentence;
import it.uniroma1.lcl.jlt.minipar.SyntacticRelation;
import it.uniroma1.lcl.jlt.semeval07.Semeval07Instance;
import it.uniroma1.lcl.jlt.util.DoubleCounter;
import it.uniroma1.lcl.jlt.util.Files;
import it.uniroma1.lcl.jlt.util.FormattedFileReader;
import it.uniroma1.lcl.jlt.util.Maths;
import it.uniroma1.lcl.jlt.util.Triple;
import it.uniroma1.lcl.jlt.wordnet.WordNet;
import it.uniroma1.lcl.jlt.wordnet.WordNetVersion;
import it.uniroma1.lcl.jlt.wordnet.data.WordNetExtendedMappings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Semeval07 {
    protected static final Log log = LogFactory.getLog(Semeval07.class);
    protected ArrayList<Semeval07Instance> instances;
    private static Semeval07 instance;

    public static Semeval07 getInstance() {
        if (instance == null) {
            instance = new Semeval07();
        }
        return instance;
    }

    private Semeval07() {
    }

    public File[] list(CollocsDB collocsDB) {
        Object[] list = new File(Configuration.getInstance().getSemEval07TestDataDirectory()).listFiles();
        Arrays.sort(list);
        return list;
    }

    public List<Semeval07Instance> getInstances(CollocsDB collocsDB) {
        throw new Error("Unresolved compilation problems: \n\tThe method getTextContent() is undefined for the type Node\n\tThe method getTextContent() is undefined for the type Node\n\tThe method getTextContent() is undefined for the type Node\n\tThe method getTextContent() is undefined for the type Node\n");
    }

    public void exportToUkbFormat() {
        try {
            BufferedWriter writer = Files.getBufferedWriter("semeval07toUkb.txt");
            for (Semeval07Instance instance : this.getInstances(CollocsDB.SEMEVAL07_TEST)) {
                if (instance.getTargetWords().isEmpty()) continue;
                writer.write(instance.toSemevalString());
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.info((Object)"Semeval test set correctly exported to UKB format.");
    }

    public void convertFromUkbToScorer(String ukbFilePath) {
        WordNet wn = WordNet.getInstance();
        WordNetExtendedMappings wnm = WordNetExtendedMappings.getInstance();
        String outputUkbFilePath = String.valueOf(ukbFilePath) + ".2scorer";
        log.info((Object)("Converting the ukb answer file to Semeval07's scorer format --> " + outputUkbFilePath));
        int total = 0;
        int notConverted = 0;
        try {
            BufferedReader reader = Files.getBufferedReader(ukbFilePath);
            BufferedWriter writer = Files.getBufferedWriter(outputUkbFilePath);
            String line = "";
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("!!")) continue;
                ArrayList pieces = Lists.newArrayList();
                String[] stringArray = line.split(" ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String piece = stringArray[n2];
                    if (!piece.isEmpty()) {
                        pieces.add(piece);
                    }
                    ++n2;
                }
                String referenceId = (String)pieces.remove(0);
                String referenceNumber = (String)pieces.remove(0);
                String word = (String)pieces.remove(pieces.size() - 1);
                pieces.remove(pieces.size() - 1);
                DoubleCounter<String> ranking = new DoubleCounter<String>();
                for (String senseAndScore : pieces) {
                    ++total;
                    String offset = senseAndScore.split("/")[0];
                    ISynset synset = wn.getSynsetFromOffset(offset);
                    IWord sense = wn.getSenseFromSynset(synset, word);
                    ISenseKey key = sense.getSenseKey();
                    ISenseKey translatedKey = wnm.getTargetSenseKey(key, WordNetVersion.WN_30, WordNetVersion.WN_21);
                    if (translatedKey == null) {
                        log.info((Object)("Could not convert the key " + key.toString() + " into version 2.1 [word: " + word + " synset: " + wn.synsetToSenseString(synset) + " offset: " + offset + "] (line: " + line + ")"));
                        ++notConverted;
                        continue;
                    }
                    double score = 0.0;
                    if (senseAndScore.split("/").length > 1) {
                        score = new Double(senseAndScore.split("/")[1]);
                    }
                    ranking.count(translatedKey.toString(), score);
                }
                writer.write(String.valueOf(referenceId) + " " + referenceNumber + " " + ranking.toLineString());
                writer.write("\n");
            }
            reader.close();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.info((Object)(String.valueOf(notConverted) + "/" + total + " senses not converted (" + Maths.getFormattedPercentage(notConverted, total) + ")."));
    }

    public void exportCleanedVersion() {
        try {
            BufferedWriter writer = Files.getBufferedWriter("semeval07.cleaned");
            for (Semeval07Instance instance : this.getInstances(CollocsDB.SEMEVAL07_TEST)) {
                for (String word : instance.getPosTaggedWords()) {
                    writer.write(word);
                    if (instance.isTargetWord(word)) {
                        writer.write("@" + instance.getTargetWordID(word, 0));
                    }
                    writer.write(" ");
                }
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public HashMap<String, HashMap<String, String>> getKeys() {
        HashMap<String, HashMap<String, String>> keys = new HashMap<String, HashMap<String, String>>();
        FormattedFileReader reader = new FormattedFileReader(Configuration.getInstance().getSemeval07Keys(), FormattedFileReader.COMMON_FORMATS.THREE_COLUMNS);
        for (List pieces : reader) {
            String ID = (String)pieces.get(0);
            String sentence = String.valueOf(ID.split("\\.")[0]) + ".s" + new Integer(ID.split("\\.")[1].replace("s", ""));
            String word = (String)pieces.get(1);
            String sense = (String)pieces.get(2);
            HashMap<String, String> key = keys.get(sentence);
            if (key == null) {
                key = new HashMap();
                keys.put(sentence, key);
            }
            key.put(word, sense);
        }
        return keys;
    }

    public void exportToAnnotatedSyntacticRelations() throws IOException {
        HashMap<String, HashMap<String, String>> keys = this.getKeys();
        BufferedWriter writer = Files.getBufferedWriter(Configuration.getInstance().getSemeval07SyntacticRelations());
        for (Semeval07Instance instance : this.getInstances(CollocsDB.SEMEVAL07_TEST)) {
            String sentenceID = instance.getSentenceID();
            HashMap<String, String> pairs = keys.get(sentenceID);
            if (pairs == null) {
                log.error((Object)("No annotated pairs for the sentence ID " + sentenceID));
                continue;
            }
            String parsed = MiniparSentence.parseSentence(instance.getSentence());
            MiniparSentence sentence = new MiniparSentence(parsed, false);
            for (Triple<SyntacticRelation, String, String> relation : sentence.getRelations()) {
                if (!pairs.containsKey(relation.getSecond()) || !pairs.containsKey(relation.getThird())) continue;
                Triple<SyntacticRelation, String, String> annotatedRelation = new Triple<SyntacticRelation, String, String>(relation.getFirst(), pairs.get(relation.getSecond()), pairs.get(relation.getThird()));
                writer.write((Object)((Object)annotatedRelation.getFirst()) + "\t" + annotatedRelation.getSecond() + "\t" + annotatedRelation.getThird() + "\n");
                log.info((Object)("[+1 RELATIONSHIP]" + annotatedRelation));
            }
        }
        writer.close();
    }

    public static void main(String[] args) throws IOException {
        Semeval07 semeval = Semeval07.getInstance();
        semeval.exportToAnnotatedSyntacticRelations();
    }
}

