/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.semcor;

import com.google.common.collect.Lists;
import edu.mit.jsemcor.element.IContext;
import edu.mit.jsemcor.element.ISentence;
import edu.mit.jsemcor.main.IConcordance;
import edu.mit.jsemcor.main.IConcordanceSet;
import edu.mit.jsemcor.main.Semcor;
import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.semcor.SemCor2WordNetSentences;
import it.uniroma1.lcl.jlt.semcor.SemCorSentence;
import it.uniroma1.lcl.jlt.util.Files;
import it.uniroma1.lcl.jlt.util.Strings;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SemCorIterator
implements Iterator<SemCorSentence> {
    public static final Log log = LogFactory.getLog(SemCorIterator.class);
    public static final String DEFAULT_SEMCOR_BASEDIR = Files.addFileSeparator(Configuration.getInstance().getSemcorHome());
    public static final String SUBDIR = "/tagfiles/";
    private IConcordanceSet semcor;
    private List<File> files;
    private int currentFile;
    private int totalFiles;
    private int currentSentence;
    private Iterator<File> fileIterator;
    private Iterator<ISentence> sentenceIterator;

    public SemCorIterator() {
        this(DEFAULT_SEMCOR_BASEDIR);
    }

    public SemCorIterator(String basedir) {
        this(basedir, SemCorIterator.getAllFiles(basedir));
    }

    public static List<File> getAllFiles(String basedir) {
        ArrayList<File> files = new ArrayList<File>();
        ArrayList directories = Lists.newArrayList((Object[])new String[]{String.valueOf(basedir) + (Object)((Object)DefaultSemcorDirectories.BROWN_1) + SUBDIR, String.valueOf(basedir) + (Object)((Object)DefaultSemcorDirectories.BROWN_2) + SUBDIR, String.valueOf(basedir) + (Object)((Object)DefaultSemcorDirectories.BROWNV) + SUBDIR});
        log.info((Object)directories);
        for (String directory : directories) {
            files.addAll(Files.listFiles(new File(directory), ".*"));
        }
        return files;
    }

    public SemCorIterator(String basedir, List<File> files) {
        log.info((Object)("Files in input: " + files));
        this.files = new ArrayList<File>();
        for (File file : files) {
            if (file.isDirectory()) continue;
            this.files.add(file);
        }
        log.info((Object)("Files to process: " + files));
        this.totalFiles = this.files.size();
        try {
            this.semcor = new Semcor(new URL("file", null, basedir));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.semcor.open();
        this.fileIterator = files.iterator();
        this.prepareNextFile();
    }

    @Override
    public boolean hasNext() {
        return this.sentenceIterator.hasNext();
    }

    @Override
    public SemCorSentence next() {
        ++this.currentSentence;
        ISentence iSentence = this.sentenceIterator.next();
        String filePrefix = this.files.get(this.currentFile - 1).getName();
        int number = iSentence.getNumber();
        SemCorSentence sentence = new SemCorSentence(iSentence, String.valueOf(filePrefix) + "#" + number);
        if (!this.sentenceIterator.hasNext()) {
            this.prepareNextFile();
        }
        return sentence;
    }

    public int getCurrentSentenceNumber() {
        return this.currentSentence;
    }

    private boolean prepareNextFile() {
        if (!this.fileIterator.hasNext()) {
            return false;
        }
        File file = this.fileIterator.next();
        ++this.currentFile;
        log.info((Object)("Opening file: " + file.getAbsolutePath() + " [" + this.currentFile + "/" + this.totalFiles + " -- " + Strings.getPercentage(this.currentFile, this.totalFiles) + "]"));
        String baseDir = Files.getBaseDir(Files.getBaseDir(file.getAbsolutePath()));
        IConcordance iConcordance = (IConcordance)this.semcor.get((Object)new File(baseDir).getName());
        IContext context = iConcordance.getContext(file.getName());
        this.sentenceIterator = context.getSentences().iterator();
        return true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.semcor.close();
    }

    public static void main(String[] args) throws MalformedURLException {
        SemCorIterator semCorIterator = new SemCorIterator();
        while (semCorIterator.hasNext()) {
            SemCorSentence next = semCorIterator.next();
            log.info(next.getID());
            log.info((Object)("\t" + SemCor2WordNetSentences.getAnnotatedWordsMap2WordNet(next, true).values()));
            log.info((Object)("\t" + SemCor2WordNetSentences.sentence2WordNetLemmaPos(next)));
            log.info((Object)("\t" + SemCor2WordNetSentences.sentence2SenseAnnotatedWordNet(next, SemCor2WordNetSentences.getAnnotatedWordsMap2WordNet(next, true))));
        }
    }

    public static enum DefaultSemcorDirectories {
        BROWN_1,
        BROWN_2,
        BROWNV;


        public String toString() {
            return super.toString().toLowerCase().replaceAll("_", "");
        }
    }
}

