/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.semcor;

import edu.mit.jsemcor.element.ISemanticTag;
import edu.mit.jsemcor.element.IWordform;
import edu.mit.jwi.item.ISenseKey;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.POS;
import it.uniroma1.lcl.jlt.semcor.SemCorSentence;
import it.uniroma1.lcl.jlt.wordnet.WordNet;
import it.uniroma1.lcl.jlt.wordnet.WordNetVersion;
import it.uniroma1.lcl.jlt.wordnet.data.WordNetExtendedMappings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SemCor2WordNetSentences {
    private static WordNetExtendedMappings wnMapper = WordNetExtendedMappings.getInstance();
    private static WordNetVersion[] versions = new WordNetVersion[]{WordNetVersion.WN_21, WordNetVersion.WN_20, WordNetVersion.WN_171, WordNetVersion.WN_16};
    private static WordNet wn = WordNet.getInstance();

    public static Map<Integer, String> getAnnotatedWordsMap2WordNet(SemCorSentence sentence) {
        return SemCor2WordNetSentences.getAnnotatedWordsMap2WordNet(sentence, false);
    }

    public static Map<Integer, String> getAnnotatedWordsMap2WordNet(SemCorSentence sentence, boolean bCheckBackwardPreviousWordNetVersions) {
        HashMap<Integer, String> annotatedWordsMap2Wn = new HashMap<Integer, String>();
        Map<Integer, IWordform> annotatedWordsMap = sentence.getAnnotatedWordsMap();
        for (Integer index : annotatedWordsMap.keySet()) {
            IWord wordSense;
            IWordform word = annotatedWordsMap.get(index);
            ISemanticTag tag = word.getSemanticTag();
            String lemma = tag.getLemma();
            char posChar = word.getPOSTag().getValue().toLowerCase().charAt(0);
            if (posChar == 'j') {
                posChar = 'a';
            }
            String originalSenseKey = (String)tag.getSenseKeys().get(0);
            ISenseKey senseKey = wn.getSenseKeyFromString(originalSenseKey);
            if (bCheckBackwardPreviousWordNetVersions && senseKey == null) {
                int i = 0;
                while (senseKey == null && i < versions.length) {
                    senseKey = wnMapper.getTargetSenseKey(originalSenseKey, versions[i++], WordNetVersion.WN_30);
                }
                if (senseKey == null) continue;
            }
            if ((wordSense = wn.getSenseFromSenseKey(senseKey)) == null) continue;
            int senseNumber = wn.getSenseNumber(wordSense);
            POS pos = WordNet.getPOSfromChar(posChar);
            annotatedWordsMap2Wn.put(index, String.valueOf(lemma) + "#" + pos.getTag() + "#" + senseNumber);
        }
        return annotatedWordsMap2Wn;
    }

    public static List<String> sentence2WordNetLemmaPos(SemCorSentence sentence) {
        ArrayList<String> wordNetSentence = new ArrayList<String>();
        for (IWordform word : sentence.getSentence().getWordList()) {
            String lemma = word.getText();
            char posChar = word.getPOSTag().getValue().toLowerCase().charAt(0);
            if (posChar == 'j') {
                posChar = 'a';
            }
            wordNetSentence.add(String.valueOf(lemma) + "#" + posChar);
        }
        return wordNetSentence;
    }

    public static List<String> sentence2SenseAnnotatedWordNet(SemCorSentence sentence) {
        return SemCor2WordNetSentences.sentence2SenseAnnotatedWordNet(sentence, SemCor2WordNetSentences.getAnnotatedWordsMap2WordNet(sentence));
    }

    public static List<String> sentence2SenseAnnotatedWordNet(SemCorSentence sentence, Map<Integer, String> annotations) {
        ArrayList<String> wordNetSentence = new ArrayList<String>();
        int i = 0;
        for (IWordform word : sentence.getSentence().getWordList()) {
            if (annotations.containsKey(i)) {
                wordNetSentence.add(annotations.get(i));
            } else {
                String lemma = word.getText();
                char posChar = word.getPOSTag().getValue().toLowerCase().charAt(0);
                if (posChar == 'j') {
                    posChar = 'a';
                }
                wordNetSentence.add(String.valueOf(lemma) + "#" + posChar);
            }
            ++i;
        }
        return wordNetSentence;
    }

    public static List<String> sentence2SimpleWords(SemCorSentence sentence) {
        ArrayList<String> words = new ArrayList<String>();
        for (IWordform word : sentence.getSentence().getWordList()) {
            words.add(word.getText());
        }
        return words;
    }
}

