/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.semcor;

import com.google.common.collect.HashMultimap;
import edu.mit.jsemcor.element.IContext;
import edu.mit.jsemcor.element.IContextID;
import edu.mit.jsemcor.element.ISemanticTag;
import edu.mit.jsemcor.element.ISentence;
import edu.mit.jsemcor.element.IWordform;
import edu.mit.jsemcor.main.IConcordance;
import edu.mit.jsemcor.main.IConcordanceSet;
import edu.mit.jsemcor.main.Semcor;
import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.util.IntegerCounter;
import it.uniroma1.lcl.jlt.util.MapCounter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SemCor {
    private static String[] ALL_CONTENT_TAGGED = new String[]{"brown1", "brown2"};
    private static String[] VERB_TAGGED = new String[]{"brownv"};
    private IConcordanceSet semcor;
    private static SemCor instance;

    private SemCor() {
        try {
            String data = Configuration.getInstance().getSemcorHome();
            this.semcor = new Semcor(new URL("file", null, data));
            this.semcor.open();
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
    }

    public static synchronized SemCor getInstance() {
        if (instance == null) {
            instance = new SemCor();
        }
        return instance;
    }

    public void close() {
        this.semcor.close();
    }

    public Collection<IConcordance> getContentWordConcordances() {
        HashSet<IConcordance> concordances = new HashSet<IConcordance>();
        String[] stringArray = ALL_CONTENT_TAGGED;
        int n = ALL_CONTENT_TAGGED.length;
        int n2 = 0;
        while (n2 < n) {
            String contentTagged = stringArray[n2];
            concordances.add((IConcordance)this.semcor.get((Object)contentTagged));
            ++n2;
        }
        return concordances;
    }

    public Collection<IConcordance> getVerbConcordances() {
        return Collections.singleton((IConcordance)this.semcor.get((Object)VERB_TAGGED[0]));
    }

    public List<IContext> getContexts(IConcordance concordance) {
        ArrayList<IContext> contexts = new ArrayList<IContext>();
        for (IContextID id : concordance.getContextIDs()) {
            contexts.add(concordance.getContext(id));
        }
        return contexts;
    }

    public static void main(String[] args) {
        IntegerCounter<String> counter = new IntegerCounter<String>();
        SemCor sc = SemCor.getInstance();
        HashMultimap poly = new HashMultimap();
        IntegerCounter<String> occurrenceCounter = new IntegerCounter<String>();
        MapCounter<String, String> lemma2senses = new MapCounter<String, String>();
        for (IConcordance con : sc.getContentWordConcordances()) {
            System.out.println("CONCORDANCE: " + con.getName());
            for (IContext c : sc.getContexts(con)) {
                System.out.println(" FILE: " + c.getFilename());
                for (ISentence s : c.getSentences()) {
                    for (IWordform wf : s.getWordList()) {
                        ISemanticTag st = wf.getSemanticTag();
                        if (st == null || !wf.getPOSTag().getValue().toLowerCase().startsWith("n")) continue;
                        counter.count("N");
                        String lemma = st.getLemma().toLowerCase();
                        for (String sense : st.getLexicalSense()) {
                            lemma2senses.count(lemma, sense);
                        }
                        occurrenceCounter.count(lemma);
                    }
                }
            }
        }
        for (String lemma : lemma2senses.keySet()) {
            int p = lemma2senses.get(lemma).size();
            poly.put((Object)p, (Object)lemma);
        }
        System.out.println(poly.get((Object)2).size());
        System.out.println(counter);
        System.exit(0);
        int currPoly = 2;
        int total = 0;
        for (Integer p : poly.keySet()) {
            if (p != currPoly) continue;
            System.out.println(p + ":" + poly.get((Object)p).size());
            HashSet<String> goodLemmas = new HashSet<String>();
            IntegerCounter<Integer> totalDist = new IntegerCounter<Integer>();
            System.out.println("size " + p + " : " + poly.get((Object)p).size());
            total = poly.get((Object)p).size();
            for (String lemma : poly.get((Object)p)) {
                ArrayList<Integer> values = new ArrayList<Integer>();
                for (int i : lemma2senses.get(lemma).values()) {
                    values.add(i);
                }
                Collections.sort(values);
                System.out.print(String.valueOf(lemma) + "\t");
                int indx = 0;
                Iterator iterator = values.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    totalDist.count(Integer.valueOf(indx), i);
                    System.out.print(String.valueOf(i) + "\t");
                    ++indx;
                }
                System.out.println();
                if ((Integer)occurrenceCounter.get(lemma) <= 0) continue;
                goodLemmas.add(lemma);
            }
            Iterator<Object> iterator = totalDist.keySet().iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                System.out.println((double)((Integer)totalDist.get(i)).intValue() / totalDist.getTotal());
            }
            System.out.println(" # sent. > 10 = " + goodLemmas.size() + ":" + goodLemmas);
        }
        System.out.println("TOTAL distinct words: " + total);
    }
}

