/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.pipeline.stanford;

import edu.stanford.nlp.trees.CollocationFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.WordNetConnection;
import it.uniroma1.lcl.jlt.wordnet.WordNet;

public class TreeCollocationFinder {
    private static final WordNet WN = WordNet.getInstance();
    private static final WordNetConnection WN_CONNECTION = new WordNetConnectionImpl();
    private static TreeCollocationFinder instance;

    private TreeCollocationFinder() {
    }

    public static synchronized TreeCollocationFinder getInstance() {
        if (instance == null) {
            instance = new TreeCollocationFinder();
        }
        return instance;
    }

    public Tree getCollocationsTree(Tree tree) {
        return new CollocationFinder(tree, WN_CONNECTION).getMangledTree();
    }

    private static class WordNetConnectionImpl
    implements WordNetConnection {
        private WordNetConnectionImpl() {
        }

        public boolean wordNetContains(String string) {
            return WN.getIndexWord(string) != null;
        }
    }
}

