/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.pipeline.stanford;

import edu.mit.jwi.item.POS;
import edu.stanford.nlp.ling.WordLemmaTag;
import it.uniroma1.lcl.jlt.pipeline.stanford.StanfordPOSTagger;
import it.uniroma1.lcl.jlt.util.IntegerCounter;
import it.uniroma1.lcl.jlt.util.Language;
import it.uniroma1.lcl.jlt.util.Pair;
import it.uniroma1.lcl.jlt.util.Sets;
import it.uniroma1.lcl.jlt.util.Stopwords;
import it.uniroma1.lcl.jlt.util.Strings;
import it.uniroma1.lcl.jlt.util.Terminology;
import it.uniroma1.lcl.jlt.wiki.SearchWiki;
import it.uniroma1.lcl.jlt.wiki.SearchWikiCentral;
import it.uniroma1.lcl.jlt.wiki.data.WikiPage;
import it.uniroma1.lcl.jlt.wordnet.WordNet;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StanfordSentence
implements Iterable<WordLemmaTag>,
Serializable {
    private static final long serialVersionUID = 7876288403086125201L;
    protected static final Log log = LogFactory.getLog(StanfordSentence.class);
    public static final int MULTIWORD_MAX_LENGTH = 5;
    private List<WordLemmaTag> words;

    public StanfordSentence() throws IOException {
        this.words = new ArrayList<WordLemmaTag>();
    }

    public StanfordSentence(List<WordLemmaTag> wordLemmaTags) {
        this.words = wordLemmaTags;
    }

    public void addWord(WordLemmaTag wordLemmaTag) {
        this.words.add(wordLemmaTag);
    }

    public List<WordLemmaTag> getWords() {
        return new ArrayList<WordLemmaTag>(this.words);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (WordLemmaTag wordLemmaTag : this.words) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(wordLemmaTag.word());
        }
        return sb.toString();
    }

    public String toLemmaString() {
        StringBuffer sb = new StringBuffer();
        for (WordLemmaTag wordLemmaTag : this.words) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(wordLemmaTag.lemma());
        }
        return sb.toString();
    }

    @Override
    public Iterator<WordLemmaTag> iterator() {
        return this.words.iterator();
    }

    public boolean contains(String word) {
        for (WordLemmaTag wlt : this.words) {
            if (!wlt.lemma().equalsIgnoreCase(word)) continue;
            return true;
        }
        return false;
    }

    public Set<String> containsWhichOf(Collection<String> lemmas) {
        return this.containsWhichOf(lemmas, null);
    }

    public Set<String> containsWhichOf(Collection<String> lemmas, POS pos) {
        HashSet<String> contained = new HashSet<String>();
        for (WordLemmaTag wlt : this.words) {
            String lemma = wlt.lemma().toLowerCase();
            if (pos != null && StanfordPOSTagger.getPOSFromTag(wlt.tag()) != pos || !lemmas.contains(lemma)) continue;
            contained.add(lemma);
        }
        return contained;
    }

    public boolean containsSequence(List<String> sequence) {
        if (sequence.isEmpty()) {
            return true;
        }
        if (sequence.size() > this.words.size()) {
            return false;
        }
        boolean bFound = false;
        String firstToken = sequence.get(0);
        int rightBoundary = this.words.size() - sequence.size() + 1;
        int i = 0;
        while (i < rightBoundary) {
            WordLemmaTag thisWord = this.words.get(i);
            if (thisWord.word().equals(firstToken)) {
                bFound = true;
                int j = 1;
                while (j < sequence.size()) {
                    WordLemmaTag otherWord = this.words.get(i + j);
                    String otherToken = sequence.get(j);
                    if (!otherWord.word().equals(otherToken)) {
                        bFound = false;
                    }
                    ++j;
                }
                if (bFound) break;
            }
            ++i;
        }
        return bFound;
    }

    @Deprecated
    public Set<String> getBOW() throws IOException {
        IntegerCounter<String> bow = this.getBOW(null, false, false, true, MultiwordBelongingTo.WORDNET, false, Language.EN);
        return bow.keySet();
    }

    public Set<String> getBOWNew() throws IOException {
        CompoundingParameter[] parameters = new CompoundingParameter[]{CompoundingParameter.APPEND_POS};
        IntegerCounter<String> bow = this.getBOW(null, Language.EN, new Terminology(), MultiwordBelongingTo.WORDNET, parameters);
        return bow.keySet();
    }

    @Deprecated
    public IntegerCounter<String> getBOW(Collection<String> validPOSes, boolean bMultiwordExpressions, boolean bAllowOverlap, boolean bIncludePOSInString, MultiwordBelongingTo belonging, boolean bOnlyOverNoun, Language sentenceLanguage) throws IOException {
        List<String> terms = this.getTerms(validPOSes, bMultiwordExpressions, bAllowOverlap, bIncludePOSInString, belonging, bOnlyOverNoun, sentenceLanguage);
        IntegerCounter<String> termCounter = new IntegerCounter<String>();
        for (String term : terms) {
            termCounter.count(term);
        }
        return termCounter;
    }

    public IntegerCounter<String> getBOW(Collection<Character> validPOSes, MultiwordBelongingTo belonging, CompoundingParameter ... parameters) throws IOException {
        return this.getBOW(validPOSes, Language.EN, new Terminology(), belonging, parameters);
    }

    public IntegerCounter<String> getBOW(Collection<Character> validPOSes, Language sentenceLanguage, Terminology customLexicon, MultiwordBelongingTo belonging, CompoundingParameter ... parameters) throws IOException {
        List<String> terms = this.getTerms(validPOSes, sentenceLanguage, customLexicon, belonging, parameters);
        IntegerCounter<String> termCounter = new IntegerCounter<String>();
        for (String term : terms) {
            termCounter.count(term);
        }
        return termCounter;
    }

    @Deprecated
    public List<String> getTerms(String validPOS, boolean bMultiwordExpressions, boolean bAllowOverlap, boolean bIncludePOSInString, MultiwordBelongingTo belonging) throws IOException {
        HashSet<String> validPOSes = new HashSet<String>();
        validPOSes.add(validPOS);
        return this.getTerms(validPOSes, bMultiwordExpressions, bAllowOverlap, bIncludePOSInString, belonging);
    }

    @Deprecated
    public List<String> getTerms(String validPOS, boolean bMultiwordExpressions, boolean bAllowOverlap, boolean bIncludePOSInString, MultiwordBelongingTo belonging, boolean bOnlyOverNoun) throws IOException {
        HashSet<String> validPOSes = new HashSet<String>();
        validPOSes.add(validPOS);
        return this.getTerms(validPOSes, bMultiwordExpressions, bAllowOverlap, bIncludePOSInString, belonging, bOnlyOverNoun);
    }

    @Deprecated
    public List<String> getTerms(String validPOS, boolean bMultiwordExpressions, boolean bAllowOverlap, boolean bIncludePOSInString, MultiwordBelongingTo belonging, boolean bOnlyOverNoun, Language sentenceLanguage) throws IOException {
        HashSet<String> validPOSes = new HashSet<String>();
        validPOSes.add(validPOS);
        return this.getTerms(validPOSes, bMultiwordExpressions, bAllowOverlap, bIncludePOSInString, belonging, bOnlyOverNoun, sentenceLanguage);
    }

    @Deprecated
    public List<String> getTerms(Collection<String> validPOSes, boolean bMultiwordExpressions, boolean bAllowOverlap, boolean bIncludePOSInString, MultiwordBelongingTo belonging, boolean bOnlyOverNoun) throws IOException {
        return this.getTerms(validPOSes, bMultiwordExpressions, bAllowOverlap, bIncludePOSInString, belonging, bOnlyOverNoun, null, Language.EN);
    }

    @Deprecated
    public List<String> getTerms(Collection<String> validPOSes, boolean bMultiwordExpressions, boolean bAllowOverlap, boolean bIncludePOSInString, MultiwordBelongingTo belonging, boolean bOnlyOverNoun, Language sentenceLanguage) throws IOException {
        return this.getTerms(validPOSes, bMultiwordExpressions, bAllowOverlap, bIncludePOSInString, belonging, bOnlyOverNoun, null, sentenceLanguage);
    }

    @Deprecated
    public List<String> getTerms(Collection<String> validPOSes, boolean bMultiwordExpressions, boolean bAllowOverlap, boolean bIncludePOSInString, MultiwordBelongingTo belonging, boolean bOnlyOverNoun, Collection<String> customLexicon) throws IOException {
        return this.getTerms(validPOSes, bMultiwordExpressions, bAllowOverlap, bIncludePOSInString, belonging, bOnlyOverNoun, customLexicon, Language.EN);
    }

    @Deprecated
    public List<String> getTerms(Collection<String> validPOSes, boolean bMultiwordExpressions, boolean bAllowOverlap, boolean bIncludePOSInString, MultiwordBelongingTo belonging, boolean bOnlyOverNoun, Collection<String> customLexicon, Language sentenceLanguage) throws IOException {
        return this.getTerms(validPOSes, bMultiwordExpressions, bAllowOverlap, bIncludePOSInString, belonging, bOnlyOverNoun, customLexicon, sentenceLanguage, false);
    }

    @Deprecated
    public List<String> getTerms(Collection<String> validPOSes, boolean bMultiwordExpressions, boolean bAllowOverlap, boolean bIncludePOSInString, MultiwordBelongingTo belonging, boolean bOnlyOverNoun, Collection<String> customLexicon, Language sentenceLanguage, boolean bIncludeTokenPosition) throws IOException {
        if (belonging.isWordNet() && !sentenceLanguage.equals((Object)Language.EN)) {
            log.info((Object)("THERE'S NO WORDNET SUPPORT FOR THE LANGUAGE:" + sentenceLanguage.name()));
            System.exit(1);
        }
        ArrayList<String> posLowercase = null;
        if (validPOSes != null) {
            posLowercase = new ArrayList<String>();
            for (String validPOS : validPOSes) {
                posLowercase.add(validPOS.toLowerCase());
            }
        }
        StringBuffer sb = new StringBuffer();
        ArrayList<String> terms = new ArrayList<String>();
        Stopwords stopWords = Stopwords.getInstance();
        int maxLength = bMultiwordExpressions ? 5 : 1;
        int h = 0;
        while (h < this.words.size()) {
            int i = maxLength - 1;
            while (i >= 0) {
                sb.setLength(0);
                WordLemmaTag wlt = null;
                boolean lastIsNoun = false;
                int j = 0;
                while (j <= i) {
                    if (h + j >= this.words.size()) break;
                    wlt = this.words.get(h + j);
                    if (j == i) {
                        sb.append(wlt.lemma());
                        lastIsNoun = wlt.tag().substring(0, 1).toLowerCase().equals("n");
                    } else {
                        sb.append(wlt.word()).append("_");
                    }
                    ++j;
                }
                String multiWord = sb.toString().toLowerCase();
                if (i == 0) {
                    Character pos = StanfordPOSTagger.getCharFromTag(wlt.tag());
                    if (pos == null) {
                        pos = Character.valueOf('?');
                    }
                    if (bIncludePOSInString) {
                        multiWord = String.valueOf(multiWord) + "#" + pos;
                    }
                    if (bIncludeTokenPosition) {
                        multiWord = String.valueOf(multiWord) + "#" + (h + 1);
                    }
                    String sfdPOS = wlt.tag().substring(0, 1).toLowerCase();
                    if ((posLowercase == null || posLowercase.contains(sfdPOS)) && multiWord.length() > 1) {
                        terms.add(multiWord);
                    }
                } else if ((lastIsNoun || !bOnlyOverNoun) && !stopWords.isStopword(multiWord) && (belonging.isWordNet() && StanfordSentence.isWordNetLemma(multiWord) || belonging.isWikipedia() && StanfordSentence.isWikipediaLemma(multiWord, sentenceLanguage) || belonging.isCustomLexicon() && customLexicon.contains(multiWord))) {
                    if (bIncludePOSInString) {
                        multiWord = String.valueOf(multiWord) + "#n";
                    }
                    if (bIncludeTokenPosition) {
                        multiWord = String.valueOf(multiWord) + "#";
                        int k = h;
                        while (k <= h + i) {
                            multiWord = String.valueOf(multiWord) + (k + 1) + (k < h + i ? "," : "");
                            ++k;
                        }
                    }
                    terms.add(multiWord);
                    if (!bAllowOverlap) {
                        h += i;
                        break;
                    }
                }
                --i;
            }
            ++h;
        }
        return terms;
    }

    @Deprecated
    public List<String> getTerms(Collection<String> validPOSes, boolean bMultiwordExpressions, boolean bAllowOverlap, boolean bIncludePOSInString, MultiwordBelongingTo belonging, Language sentenceLanguage) throws IOException {
        return this.getTerms(validPOSes, bMultiwordExpressions, bAllowOverlap, bIncludePOSInString, belonging, false, sentenceLanguage);
    }

    @Deprecated
    public List<String> getTerms(Collection<String> validPOSes, boolean bMultiwordExpressions, boolean bAllowOverlap, boolean bIncludePOSInString, MultiwordBelongingTo belonging) throws IOException {
        return this.getTerms(validPOSes, bMultiwordExpressions, bAllowOverlap, bIncludePOSInString, belonging, false);
    }

    public List<String> getTerms(Collection<Character> validPOSes, MultiwordBelongingTo belonging, CompoundingParameter ... parameters) throws IOException {
        return this.getTerms(validPOSes, Language.EN, null, belonging, parameters);
    }

    public List<String> getTerms(Collection<Character> validPOSes, Terminology customLexicon, MultiwordBelongingTo belonging, CompoundingParameter ... parameters) throws IOException {
        return this.getTerms(validPOSes, Language.EN, customLexicon, belonging, parameters);
    }

    public List<String> getTerms(Collection<Character> validPOSes, Language sentenceLanguage, MultiwordBelongingTo belonging, CompoundingParameter ... parameters) throws IOException {
        return this.getTerms(validPOSes, sentenceLanguage, null, belonging, parameters);
    }

    public List<String> getTerms(Collection<Character> validPOSes, Language sentenceLanguage, Terminology customLexicon, MultiwordBelongingTo belonging, CompoundingParameter ... parameters) throws IOException {
        boolean bMultiwordExpressions = false;
        boolean bIncludePOSInString = false;
        boolean bIncludeTokenPosition = false;
        boolean bOnlyOverNoun = false;
        boolean bAllowOverlap = false;
        if (parameters != null) {
            bMultiwordExpressions = it.uniroma1.lcl.jlt.util.Arrays.contains(parameters, CompoundingParameter.ALLOW_MULTIWORD_EXPRESSIONS);
            bIncludePOSInString = it.uniroma1.lcl.jlt.util.Arrays.contains(parameters, CompoundingParameter.APPEND_POS);
            bIncludeTokenPosition = it.uniroma1.lcl.jlt.util.Arrays.contains(parameters, CompoundingParameter.APPEND_TOKEN_POSITION);
            bOnlyOverNoun = it.uniroma1.lcl.jlt.util.Arrays.contains(parameters, CompoundingParameter.ALLOW_ONLY_NOUNS_FOR_MULTIWORD_EXPRESSIONS);
            bAllowOverlap = it.uniroma1.lcl.jlt.util.Arrays.contains(parameters, CompoundingParameter.ALLOW_OVERLAP_OVER_MULTIWORD_EXPRESSIONS);
        }
        if (belonging.isCustomLexicon() && customLexicon == null) {
            log.info((Object)"NULL CUSTOM LEXICON");
            System.exit(1);
        }
        if (belonging.isWordNet() && !sentenceLanguage.equals((Object)Language.EN)) {
            log.info((Object)("THERE'S NO WORDNET SUPPORT FOR THE LANGUAGE:" + sentenceLanguage.name()));
            System.exit(1);
        }
        StringBuffer sb = new StringBuffer();
        ArrayList<String> terms = new ArrayList<String>();
        Stopwords stopWords = Stopwords.getInstance();
        int maxLength = bMultiwordExpressions ? 5 : 1;
        int h = 0;
        while (h < this.words.size()) {
            int i = maxLength - 1;
            while (i >= 0) {
                sb.setLength(0);
                WordLemmaTag wlt = null;
                boolean lastIsNoun = false;
                int j = 0;
                while (j <= i) {
                    if (h + j >= this.words.size()) break;
                    wlt = this.words.get(h + j);
                    if (j == i) {
                        sb.append(wlt.lemma());
                        lastIsNoun = wlt.tag().substring(0, 1).toLowerCase().equals("n");
                    } else {
                        sb.append(wlt.word()).append("_");
                    }
                    ++j;
                }
                String multiWord = sb.toString().toLowerCase();
                if (i == 0) {
                    Character pos = StanfordPOSTagger.getCharFromTag(wlt.tag());
                    if (pos == null) {
                        pos = Character.valueOf('?');
                    }
                    if (bIncludePOSInString) {
                        multiWord = String.valueOf(multiWord) + "#" + pos;
                    }
                    if (bIncludeTokenPosition) {
                        multiWord = String.valueOf(multiWord) + "#" + (h + 1);
                    }
                    Character sfdPOS = Character.valueOf(Character.toLowerCase(wlt.tag().charAt(0)));
                    if ((validPOSes == null || validPOSes.contains(sfdPOS) || validPOSes.contains(Character.valueOf(Character.toUpperCase(sfdPOS.charValue())))) && multiWord.length() > 1) {
                        terms.add(multiWord);
                    }
                } else if ((lastIsNoun || !bOnlyOverNoun) && !stopWords.isStopword(multiWord) && (belonging.isWordNet() && StanfordSentence.isWordNetLemma(multiWord) || belonging.isWikipedia() && StanfordSentence.isWikipediaLemma(multiWord, sentenceLanguage) || belonging.isCustomLexicon() && customLexicon.contains(multiWord))) {
                    if (bIncludePOSInString) {
                        multiWord = String.valueOf(multiWord) + "#n";
                    }
                    if (bIncludeTokenPosition) {
                        multiWord = String.valueOf(multiWord) + "#";
                        int k = h;
                        while (k <= h + i) {
                            multiWord = String.valueOf(multiWord) + (k + 1) + (k < h + i ? "," : "");
                            ++k;
                        }
                    }
                    terms.add(multiWord);
                    if (!bAllowOverlap) {
                        h += i;
                        break;
                    }
                }
                --i;
            }
            ++h;
        }
        return terms;
    }

    public List<String> getVerbs(Collection<Character> validPOSes, Language sentenceLanguage, CompoundingParameter ... parameters) throws IOException {
        boolean bMultiwordExpressions = false;
        boolean bIncludePOSInString = false;
        boolean bIncludeTokenPosition = false;
        boolean bAllowOverlap = false;
        if (parameters != null) {
            bMultiwordExpressions = it.uniroma1.lcl.jlt.util.Arrays.contains(parameters, CompoundingParameter.ALLOW_MULTIWORD_EXPRESSIONS);
            bIncludePOSInString = it.uniroma1.lcl.jlt.util.Arrays.contains(parameters, CompoundingParameter.APPEND_POS);
            bIncludeTokenPosition = it.uniroma1.lcl.jlt.util.Arrays.contains(parameters, CompoundingParameter.APPEND_TOKEN_POSITION);
            bAllowOverlap = it.uniroma1.lcl.jlt.util.Arrays.contains(parameters, CompoundingParameter.ALLOW_OVERLAP_OVER_MULTIWORD_EXPRESSIONS);
        }
        if (!sentenceLanguage.equals((Object)Language.EN)) {
            log.info((Object)("THERE'S NO WORDNET SUPPORT FOR THE LANGUAGE:" + sentenceLanguage.name()));
            System.exit(1);
        }
        StringBuffer sb = new StringBuffer();
        ArrayList<String> terms = new ArrayList<String>();
        int maxLength = bMultiwordExpressions ? 5 : 1;
        int h = 0;
        while (h < this.words.size()) {
            int i = maxLength - 1;
            while (i >= 0) {
                sb.setLength(0);
                WordLemmaTag wlt = null;
                int j = 0;
                while (j <= i) {
                    if (h + j >= this.words.size()) break;
                    wlt = this.words.get(h + j);
                    if (j == i) {
                        sb.append(wlt.lemma());
                    } else {
                        sb.append(wlt.lemma()).append("_");
                    }
                    ++j;
                }
                String multiWord = sb.toString().toLowerCase();
                if (i == 0) {
                    Character pos = StanfordPOSTagger.getCharFromTag(wlt.tag());
                    if (pos == null) {
                        pos = Character.valueOf('?');
                    }
                    if (bIncludePOSInString) {
                        multiWord = String.valueOf(multiWord) + "#" + pos;
                    }
                    if (bIncludeTokenPosition) {
                        multiWord = String.valueOf(multiWord) + "#" + (h + 1);
                    }
                    Character sfdPOS = Character.valueOf(Character.toLowerCase(wlt.tag().charAt(0)));
                    if ((validPOSes == null || validPOSes.contains(sfdPOS) || validPOSes.contains(Character.valueOf(Character.toUpperCase(sfdPOS.charValue())))) && multiWord.length() > 1) {
                        terms.add(multiWord);
                    }
                } else if (StanfordSentence.isWordNetVerb(multiWord)) {
                    if (bIncludePOSInString) {
                        multiWord = String.valueOf(multiWord) + "#v";
                    }
                    if (bIncludeTokenPosition) {
                        multiWord = String.valueOf(multiWord) + "#";
                        int k = h;
                        while (k <= h + i) {
                            multiWord = String.valueOf(multiWord) + (k + 1) + (k < h + i ? "," : "");
                            ++k;
                        }
                    }
                    terms.add(multiWord);
                    if (!bAllowOverlap) {
                        h += i;
                        break;
                    }
                }
                --i;
            }
            ++h;
        }
        return terms;
    }

    public StanfordSentence getMultiwordSentence(MultiwordBelongingTo belonging, Language sentenceLanguage) throws IOException {
        if (belonging.isCustomLexicon()) {
            log.info((Object)"NO CUSTOM LEXICON SPECIFIED PLEASE USE:getMultiwordSentence(MultiwordBelongingTo belonging,Language sentenceLanguage,Terminology customLexicon) OR CHANGE THE BELONGING PARAMETER");
            System.exit(1);
        }
        return this.getMultiwordSentence(belonging, sentenceLanguage, new Terminology());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public StanfordSentence getMultiwordSentence(MultiwordBelongingTo belonging, Language sentenceLanguage, Terminology customLexicon) throws IOException {
        if (belonging.isCustomLexicon() && customLexicon == null) {
            log.info((Object)"NULL CUSTOM LEXICON");
            System.exit(1);
        }
        if (belonging.isWordNet() && !sentenceLanguage.equals((Object)Language.EN)) {
            log.info((Object)("THERE'S NO WORDNET SUPPORT FOR THE LANGUAGE:" + sentenceLanguage.name()));
            System.exit(1);
        }
        StanfordSentence result = new StanfordSentence();
        ArrayList<Pair<Integer, Integer>> cues = new ArrayList<Pair<Integer, Integer>>();
        StringBuffer sb = new StringBuffer();
        StringBuffer oLemmaSb = new StringBuffer();
        StringBuffer oPosSb = new StringBuffer();
        StringBuffer oWordSb = new StringBuffer();
        Stopwords stopWords = Stopwords.getInstance();
        int maxLength = 5;
        int h = 0;
        while (h < this.words.size()) {
            int i = maxLength - 1;
            while (i >= 0) {
                sb.setLength(0);
                oLemmaSb.setLength(0);
                oPosSb.setLength(0);
                oWordSb.setLength(0);
                Object var14_17 = null;
                boolean lastIsNoun = false;
                int j = 0;
                while (j <= i) {
                    if (h + j >= this.words.size()) break;
                    try {
                        WordLemmaTag wordLemmaTag = this.words.get(h + j);
                        if (j == i) {
                            sb.append(wordLemmaTag.lemma());
                            lastIsNoun = wordLemmaTag.tag().substring(0, 1).toLowerCase().equals("n");
                        } else {
                            sb.append(wordLemmaTag.word()).append("_");
                        }
                    }
                    catch (Exception e) {
                        void var14_16;
                        log.info((Object)"PROBLEM: existing blank field in the word-lemma-tag triple\n");
                        log.info((Object)("at word: " + var14_16.toString() + "\n"));
                        log.info((Object)("at sentence: " + this.words + "\n"));
                        e.printStackTrace();
                    }
                    ++j;
                }
                String multiWord = sb.toString().toLowerCase();
                if (i != 0 && lastIsNoun && !stopWords.isStopword(multiWord) && (belonging.isWordNet() && StanfordSentence.isWordNetLemma(multiWord) || belonging.isWikipedia() && StanfordSentence.isWikipediaLemma(multiWord, sentenceLanguage) || belonging.isCustomLexicon() && customLexicon.contains(multiWord))) {
                    Pair<Integer, Integer> cue = new Pair<Integer, Integer>(h, h + i);
                    cues.add(cue);
                    h += i;
                    break;
                }
                --i;
            }
            ++h;
        }
        h = 0;
        while (h < this.words.size()) {
            Pair position = null;
            for (Pair pair : cues) {
                if (h < (Integer)pair.getFirst() || h > (Integer)pair.getSecond()) continue;
                position = pair;
                break;
            }
            if (position == null) {
                result.addWord(this.words.get(h));
                ++h;
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer zWsb = new StringBuffer();
            int z = (Integer)position.getFirst();
            while (z < (Integer)position.getSecond() + 1) {
                WordLemmaTag wltz = this.words.get(z);
                if (z == (Integer)position.getSecond()) {
                    stringBuffer.append(wltz.lemma());
                    zWsb.append(wltz.word());
                } else {
                    stringBuffer.append(wltz.word()).append("_");
                    zWsb.append(wltz.word()).append("_");
                }
                ++z;
            }
            String newMultiLemma = stringBuffer.toString().toLowerCase();
            String newMultiWord = zWsb.toString();
            WordLemmaTag newWLT = new WordLemmaTag();
            newWLT.setLemma(newMultiLemma);
            newWLT.setWord(newMultiWord);
            newWLT.setTag("N");
            result.addWord(newWLT);
            h = (Integer)position.getSecond() + 1;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public StanfordSentence getMultiwordSentence(Collection<Character> validPOSes, Language sentenceLanguage, Terminology customLexicon, MultiwordBelongingTo belonging, CompoundingParameter ... parameters) throws IOException {
        boolean bMultiwordExpressions = false;
        boolean bIncludePOSInString = false;
        boolean bIncludeTokenPosition = false;
        boolean bOnlyOverNoun = false;
        boolean bAllowOverlap = false;
        if (parameters != null) {
            bMultiwordExpressions = it.uniroma1.lcl.jlt.util.Arrays.contains(parameters, CompoundingParameter.ALLOW_MULTIWORD_EXPRESSIONS);
            bIncludePOSInString = it.uniroma1.lcl.jlt.util.Arrays.contains(parameters, CompoundingParameter.APPEND_POS);
            bIncludeTokenPosition = it.uniroma1.lcl.jlt.util.Arrays.contains(parameters, CompoundingParameter.APPEND_TOKEN_POSITION);
            bOnlyOverNoun = it.uniroma1.lcl.jlt.util.Arrays.contains(parameters, CompoundingParameter.ALLOW_ONLY_NOUNS_FOR_MULTIWORD_EXPRESSIONS);
            bAllowOverlap = it.uniroma1.lcl.jlt.util.Arrays.contains(parameters, CompoundingParameter.ALLOW_OVERLAP_OVER_MULTIWORD_EXPRESSIONS);
        }
        if (belonging.isCustomLexicon() && customLexicon == null) {
            log.info((Object)"NULL CUSTOM LEXICON");
            System.exit(1);
        }
        if (belonging.isWordNet() && !sentenceLanguage.equals((Object)Language.EN)) {
            log.info((Object)("THERE'S NO WORDNET SUPPORT FOR THE LANGUAGE:" + sentenceLanguage.name()));
            System.exit(1);
        }
        StanfordSentence result = new StanfordSentence();
        ArrayList<Pair<Integer, Integer>> cues = new ArrayList<Pair<Integer, Integer>>();
        StringBuffer sb = new StringBuffer();
        StringBuffer oLemmaSb = new StringBuffer();
        StringBuffer oPosSb = new StringBuffer();
        StringBuffer oWordSb = new StringBuffer();
        Stopwords stopWords = Stopwords.getInstance();
        int maxLength = bMultiwordExpressions ? 5 : 1;
        int h = 0;
        while (h < this.words.size()) {
            int i = maxLength - 1;
            while (i >= 0) {
                sb.setLength(0);
                oLemmaSb.setLength(0);
                oPosSb.setLength(0);
                oWordSb.setLength(0);
                Object var21_24 = null;
                boolean lastIsNoun = false;
                int j = 0;
                while (j <= i) {
                    if (h + j >= this.words.size()) break;
                    try {
                        WordLemmaTag wordLemmaTag = this.words.get(h + j);
                        if (j == i) {
                            sb.append(wordLemmaTag.lemma());
                            lastIsNoun = wordLemmaTag.tag().substring(0, 1).toLowerCase().equals("n");
                        } else {
                            sb.append(wordLemmaTag.word()).append("_");
                        }
                    }
                    catch (Exception e) {
                        void var21_23;
                        log.info((Object)"PROBLEM: existing blank field in the word-lemma-tag triple\n");
                        log.info((Object)("at word: " + var21_23.toString() + "\n"));
                        log.info((Object)("at sentence: " + this.words + "\n"));
                        e.printStackTrace();
                    }
                    ++j;
                }
                String multiWord = sb.toString().toLowerCase();
                if (i != 0 && (lastIsNoun || !bOnlyOverNoun) && !stopWords.isStopword(multiWord) && (belonging.isWordNet() && StanfordSentence.isWordNetLemma(multiWord) || belonging.isWikipedia() && StanfordSentence.isWikipediaLemma(multiWord, sentenceLanguage) || belonging.isCustomLexicon() && customLexicon.contains(multiWord))) {
                    if (bIncludePOSInString) {
                        multiWord = String.valueOf(multiWord) + "#n";
                    }
                    if (bIncludeTokenPosition) {
                        multiWord = String.valueOf(multiWord) + "#";
                        int k = h;
                        while (k <= h + i) {
                            multiWord = String.valueOf(multiWord) + (k + 1) + (k < h + i ? "," : "");
                            ++k;
                        }
                    }
                    Pair<Integer, Integer> cue = new Pair<Integer, Integer>(h, h + i);
                    cues.add(cue);
                    if (!bAllowOverlap) {
                        h += i;
                        break;
                    }
                }
                --i;
            }
            ++h;
        }
        h = 0;
        while (h < this.words.size()) {
            Pair position = null;
            for (Pair pair : cues) {
                if (h < (Integer)pair.getFirst() || h > (Integer)pair.getSecond()) continue;
                position = pair;
                break;
            }
            if (position == null) {
                result.addWord(this.words.get(h));
                ++h;
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer zWsb = new StringBuffer();
            int z = (Integer)position.getFirst();
            while (z < (Integer)position.getSecond() + 1) {
                WordLemmaTag wltz = this.words.get(z);
                if (z == (Integer)position.getSecond()) {
                    stringBuffer.append(wltz.lemma());
                    zWsb.append(wltz.word());
                } else {
                    stringBuffer.append(wltz.word()).append("_");
                    zWsb.append(wltz.word()).append("_");
                }
                ++z;
            }
            String newMultiLemma = stringBuffer.toString().toLowerCase();
            String newMultiWord = zWsb.toString();
            WordLemmaTag newWLT = new WordLemmaTag();
            newWLT.setLemma(newMultiLemma);
            newWLT.setWord(newMultiWord);
            newWLT.setTag("N");
            result.addWord(newWLT);
            h = (Integer)position.getSecond() + 1;
        }
        return result;
    }

    public static boolean isWordNetVerb(String multiword) {
        return WordNet.getInstance().getIndexWord(multiword, POS.VERB) != null;
    }

    public static boolean isWordNetLemma(String multiword) {
        return WordNet.getInstance().getIndexWord(multiword, POS.NOUN) != null;
    }

    public static boolean isWikipediaLemma(String multiword) throws IOException {
        return StanfordSentence.isWikipediaLemma(multiword, Language.EN);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isWikipediaLemma(String multiword, Language sentenceLanguage) throws IOException {
        try {
            WikiPage page;
            String pageLemma;
            String cleanMultiWord = multiword.replaceAll("_", " ");
            String[] splits = cleanMultiWord.split(" ");
            if (splits != null && splits.length > 0 && Strings.isEnglishArticle(splits[0])) {
                return false;
            }
            SearchWiki sw = SearchWikiCentral.getInstance(sentenceLanguage);
            Set<WikiPage> pages = sw.getSenses(cleanMultiWord);
            if (pages == null || pages.isEmpty()) {
                return false;
            }
            Iterator<WikiPage> iterator = pages.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(pageLemma = (page = iterator.next()).getLemma()).equalsIgnoreCase(cleanMultiWord));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Pair<IntegerCounter<String>, List<String>> getCooccurrences(Collection<String> validPOSes, boolean bMultiwordExpressions, boolean bAllowOverlap, boolean bIncludePOSInString, int windowRadius, MultiwordBelongingTo belonging) throws IOException {
        return this.getCooccurrences(validPOSes, bMultiwordExpressions, bAllowOverlap, bIncludePOSInString, windowRadius, belonging, null);
    }

    @Deprecated
    public Pair<IntegerCounter<String>, List<String>> getCooccurrences(Collection<String> validPOSes, boolean bMultiwordExpressions, boolean bAllowOverlap, boolean bIncludePOSInString, int windowRadius, MultiwordBelongingTo belonging, Set<String> customLexicon) throws IOException {
        IntegerCounter<String> bow = new IntegerCounter<String>();
        ArrayList<String> encoutered = new ArrayList<String>();
        Stopwords stopWords = Stopwords.getInstance();
        int h = 0;
        while (h < this.words.size()) {
            int maxLength = bMultiwordExpressions ? 5 : 1;
            int i = maxLength - 1;
            while (i >= 0) {
                StringBuffer sb = new StringBuffer();
                WordLemmaTag wlt = null;
                int j = 0;
                while (j <= i) {
                    if (h + j >= this.words.size()) break;
                    wlt = this.words.get(h + j);
                    if (j == i) {
                        sb.append(wlt.lemma());
                    } else {
                        sb.append(wlt.word()).append("_");
                    }
                    ++j;
                }
                String multiWord = sb.toString().toLowerCase();
                if (i == 0) {
                    Character pos = StanfordPOSTagger.getCharFromTag(wlt.tag());
                    if (pos == null) {
                        pos = Character.valueOf('?');
                    }
                    if (bIncludePOSInString) {
                        multiWord = String.valueOf(multiWord) + "#" + pos;
                    }
                    String sfdPOS = "" + wlt.tag().charAt(0);
                    if ((validPOSes == null || validPOSes.contains(sfdPOS)) && multiWord.length() > 1) {
                        bow.count(multiWord);
                        encoutered.add(multiWord);
                    }
                } else if (!stopWords.isStopword(multiWord) && (belonging.isWordNet() && StanfordSentence.isWordNetLemma(multiWord) || belonging.isWikipedia() && StanfordSentence.isWikipediaLemma(multiWord)) || belonging.isCustomLexicon() && customLexicon.contains(multiWord)) {
                    if (bIncludePOSInString) {
                        multiWord = String.valueOf(multiWord) + "#n";
                    }
                    bow.count(multiWord);
                    encoutered.add(multiWord);
                    if (!bAllowOverlap) {
                        h += i;
                        break;
                    }
                }
                --i;
            }
            ++h;
        }
        return new Pair<IntegerCounter<String>, List<String>>(bow, encoutered);
    }

    public Pair<IntegerCounter<String>, List<String>> getCooccurrences(Collection<Character> validPOSes, Language sentenceLanguage, Terminology customLexicon, MultiwordBelongingTo belonging, int windowRadius, CompoundingParameter ... parameters) throws IOException {
        boolean bMultiwordExpressions = false;
        boolean bIncludePOSInString = false;
        boolean bIncludeTokenPosition = false;
        boolean bOnlyOverNoun = false;
        boolean bAllowOverlap = false;
        if (parameters != null) {
            bMultiwordExpressions = it.uniroma1.lcl.jlt.util.Arrays.contains(parameters, CompoundingParameter.ALLOW_MULTIWORD_EXPRESSIONS);
            bIncludePOSInString = it.uniroma1.lcl.jlt.util.Arrays.contains(parameters, CompoundingParameter.APPEND_POS);
            bIncludeTokenPosition = it.uniroma1.lcl.jlt.util.Arrays.contains(parameters, CompoundingParameter.APPEND_TOKEN_POSITION);
            bOnlyOverNoun = it.uniroma1.lcl.jlt.util.Arrays.contains(parameters, CompoundingParameter.ALLOW_ONLY_NOUNS_FOR_MULTIWORD_EXPRESSIONS);
            bAllowOverlap = it.uniroma1.lcl.jlt.util.Arrays.contains(parameters, CompoundingParameter.ALLOW_OVERLAP_OVER_MULTIWORD_EXPRESSIONS);
        }
        if (belonging.isCustomLexicon() && customLexicon == null) {
            log.info((Object)"NULL CUSTOM LEXICON");
            System.exit(1);
        }
        if (belonging.isWordNet() && !sentenceLanguage.equals((Object)Language.EN)) {
            log.info((Object)("THERE'S NO WORDNET SUPPORT FOR THE LANGUAGE:" + sentenceLanguage.name()));
            System.exit(1);
        }
        IntegerCounter<String> bow = new IntegerCounter<String>();
        ArrayList<String> encoutered = new ArrayList<String>();
        Stopwords stopWords = Stopwords.getInstance();
        int h = 0;
        while (h < this.words.size()) {
            int maxLength = bMultiwordExpressions ? 5 : 1;
            int i = maxLength - 1;
            while (i >= 0) {
                StringBuffer sb = new StringBuffer();
                WordLemmaTag wlt = null;
                boolean lastIsNoun = false;
                int j = 0;
                while (j <= i) {
                    if (h + j >= this.words.size()) break;
                    wlt = this.words.get(h + j);
                    if (j == i) {
                        sb.append(wlt.lemma());
                        lastIsNoun = wlt.tag().substring(0, 1).toLowerCase().equals("n");
                    } else {
                        sb.append(wlt.word()).append("_");
                    }
                    ++j;
                }
                String multiWord = sb.toString().toLowerCase();
                if (i == 0) {
                    Character pos = StanfordPOSTagger.getCharFromTag(wlt.tag());
                    if (pos == null) {
                        pos = Character.valueOf('?');
                    }
                    if (bIncludePOSInString) {
                        multiWord = String.valueOf(multiWord) + "#" + pos;
                    }
                    if (bIncludeTokenPosition) {
                        multiWord = String.valueOf(multiWord) + "#" + (h + 1);
                    }
                    Character sfdPOS = Character.valueOf(Character.toLowerCase(wlt.tag().charAt(0)));
                    if ((validPOSes == null || validPOSes.contains(sfdPOS) || validPOSes.contains(Character.valueOf(Character.toUpperCase(sfdPOS.charValue())))) && multiWord.length() > 1) {
                        encoutered.add(multiWord);
                        bow.count(multiWord);
                    }
                } else if ((lastIsNoun || !bOnlyOverNoun) && !stopWords.isStopword(multiWord) && (belonging.isWordNet() && StanfordSentence.isWordNetLemma(multiWord) || belonging.isWikipedia() && StanfordSentence.isWikipediaLemma(multiWord, sentenceLanguage) || belonging.isCustomLexicon() && customLexicon.contains(multiWord))) {
                    if (bIncludePOSInString) {
                        multiWord = String.valueOf(multiWord) + "#n";
                    }
                    if (bIncludeTokenPosition) {
                        multiWord = String.valueOf(multiWord) + "#";
                        int k = h;
                        while (k <= h + i) {
                            multiWord = String.valueOf(multiWord) + (k + 1) + (k < h + i ? "," : "");
                            ++k;
                        }
                    }
                    bow.count(multiWord);
                    encoutered.add(multiWord);
                    if (!bAllowOverlap) {
                        h += i;
                        break;
                    }
                }
                --i;
            }
            ++h;
        }
        return new Pair<IntegerCounter<String>, List<String>>(bow, encoutered);
    }

    public String getWord(int k) {
        if (k < 0 || k >= this.words.size()) {
            return "??";
        }
        WordLemmaTag wlt = this.words.get(k);
        return wlt.word();
    }

    public String getLemma(int k) {
        if (k < 0 || k >= this.words.size()) {
            return "??";
        }
        WordLemmaTag wlt = this.words.get(k);
        return wlt.lemma();
    }

    public String getPOS(int k) {
        if (k < 0 || k >= this.words.size()) {
            return "??";
        }
        WordLemmaTag wlt = this.words.get(k);
        return wlt.tag();
    }

    public Map<String, String> getLocalFeaturesAroundFirstOccurrence(String target) {
        int k = 0;
        while (k < this.words.size()) {
            if (this.words.get(k).lemma().equalsIgnoreCase(target)) {
                return this.getLocalFeaturesAround(k);
            }
            ++k;
        }
        return new LinkedHashMap<String, String>();
    }

    public Map<String, String> getLocalFeaturesAround(int k) {
        LinkedHashMap<String, String> features = new LinkedHashMap<String, String>();
        features.put("c-3", this.getWord(k - 3));
        features.put("c-2", this.getWord(k - 2));
        features.put("c-1", this.getWord(k - 1));
        features.put("c-3-2", String.valueOf(this.getWord(k - 3)) + "_" + this.getWord(k - 2));
        features.put("c-3-1", String.valueOf(this.getWord(k - 3)) + "_" + this.getWord(k - 1));
        features.put("c-2-1", String.valueOf(this.getWord(k - 2)) + "_" + this.getWord(k - 1));
        features.put("p-3", this.getPOS(k - 3));
        features.put("p-2", this.getPOS(k - 2));
        features.put("p-1", this.getPOS(k - 1));
        features.put("c+3", this.getWord(k + 3));
        features.put("c+2", this.getWord(k + 2));
        features.put("c+1", this.getWord(k + 1));
        features.put("c+3+2", String.valueOf(this.getWord(k + 3)) + "_" + this.getWord(k + 2));
        features.put("c+3+1", String.valueOf(this.getWord(k + 3)) + "_" + this.getWord(k + 1));
        features.put("c+2+1", String.valueOf(this.getWord(k + 2)) + "_" + this.getWord(k + 1));
        features.put("p+3", this.getPOS(k + 3));
        features.put("p+2", this.getPOS(k + 2));
        features.put("p+1", this.getPOS(k + 1));
        features.put("c-1+1", String.valueOf(this.getWord(k - 1)) + "_" + this.getWord(k + 1));
        features.put("c-1+2", String.valueOf(this.getWord(k - 1)) + "_" + this.getWord(k + 2));
        features.put("c-1+3", String.valueOf(this.getWord(k - 1)) + "_" + this.getWord(k + 3));
        features.put("c-2+1", String.valueOf(this.getWord(k - 2)) + "_" + this.getWord(k + 1));
        features.put("c-2+2", String.valueOf(this.getWord(k - 2)) + "_" + this.getWord(k + 2));
        features.put("c-2+3", String.valueOf(this.getWord(k - 2)) + "_" + this.getWord(k + 3));
        features.put("c-3+1", String.valueOf(this.getWord(k - 3)) + "_" + this.getWord(k + 1));
        features.put("c-3+2", String.valueOf(this.getWord(k - 3)) + "_" + this.getWord(k + 2));
        features.put("c-3+3", String.valueOf(this.getWord(k - 3)) + "_" + this.getWord(k + 3));
        return features;
    }

    public String getFeatureVectorAround(int k) {
        StringBuffer buffer = new StringBuffer();
        Map<String, String> features = this.getLocalFeaturesAround(k);
        for (String featureName : features.keySet()) {
            String featureValue = features.get(featureName);
            buffer.append(featureName).append(":").append(featureValue).append(" ");
        }
        if (!features.isEmpty()) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public static StanfordSentence fromLine(String line) {
        return StanfordSentence.fromLine(line, " ");
    }

    public static StanfordSentence fromLine(String line, String separator) {
        ArrayList<WordLemmaTag> wlts = new ArrayList<WordLemmaTag>();
        String[] wordLemmaTags = line.split(separator);
        if (wordLemmaTags.length == 0) {
            throw new RuntimeException("Invalid word/lemma/tag sequence: " + Arrays.asList(wordLemmaTags));
        }
        String[] stringArray = wordLemmaTags;
        int n = wordLemmaTags.length;
        int n2 = 0;
        while (n2 < n) {
            String wordLemmaTag = stringArray[n2];
            String[] wltSplit = wordLemmaTag.split("/");
            if (wltSplit.length != 3) {
                if (wltSplit.length > 3 && wltSplit.length % 2 == 1) {
                    int wordNumber = wltSplit.length / 2;
                    int k = 0;
                    while (k < wordNumber) {
                        WordLemmaTag wlt = new WordLemmaTag(wltSplit[k], wltSplit[wordNumber + k], wltSplit[wltSplit.length - 1]);
                        wlts.add(wlt);
                        ++k;
                    }
                } else {
                    log.warn((Object)("Invalid word/lemma/tag : " + Arrays.asList(wltSplit)));
                }
            } else {
                WordLemmaTag wlt = new WordLemmaTag(wltSplit[0], wltSplit[1], wltSplit[2]);
                wlts.add(wlt);
            }
            ++n2;
        }
        return new StanfordSentence(wlts);
    }

    public static void main(String[] args) throws IOException {
        List<Character> validPOSes = Arrays.asList(Character.valueOf('V'), Character.valueOf('R'), Character.valueOf('J'), Character.valueOf('N'));
        String doc = "first/first/RB of/of/IN all/all/PDT this/this/DT is/be/VBZ a/a/DT veery/veery/NN difficult/difficult/JJ testing/testing/NN to/to/TO evaluating/evaluate/VBG the/the/DT measures/measure/NNS ashen/ashen/VBP sadfsdf/sadfsdf/NN]";
        StanfordSentence d = StanfordSentence.fromLine(doc);
        Terminology T = Terminology.fromFile("/home/pilehvar/Works/WiktionaryGraph/word.list");
        List<String> terms = d.getTerms(validPOSes, Language.EN, T, MultiwordBelongingTo.CUSTOM_LEXICON, CompoundingParameter.ALLOW_MULTIWORD_EXPRESSIONS, CompoundingParameter.APPEND_POS);
        System.out.println(terms);
    }

    public static void testOldEnglish() throws IOException {
        List<String> posTagList = Arrays.asList("N");
        String doc = "this/this/DT is/be/VBZ a/a/DT pulling/pull/VBG up/up/RP";
        StanfordSentence d = StanfordSentence.fromLine(doc);
        List<String> cs1 = d.getTerms(posTagList, true, false, true, MultiwordBelongingTo.WIKIPEDIA, false, Sets.varargsToHashSet("bus_driver", "computer_science"));
        System.out.println("Original");
        log.info((Object)"FOUND:");
        for (String s : cs1) {
            log.info((Object)s);
        }
    }

    public static void testOld_French() throws IOException {
        List<String> posTagList = Arrays.asList("N", "V", "J");
        String frenchSentence = "Le/le/DT Languedoc-Roussillon/Languedoc-Roussillon/NN est/est/VB une/une/DT r\u00e9gion/r\u00e9gion/NN fran\u00e7aise/fran\u00e7aise/JJ Languedoc-Roussillon/Languedoc-Roussillon/NN ././SENT";
        StanfordSentence frenchSS = StanfordSentence.fromLine(frenchSentence);
        List<String> frenchcs = frenchSS.getTerms(posTagList, true, false, true, MultiwordBelongingTo.WIKIPEDIA, Language.FR);
        log.info((Object)"FOUND:");
        for (String s : frenchcs) {
            log.info((Object)s);
        }
        System.out.println(frenchSS.getMultiwordSentence(MultiwordBelongingTo.WIKIPEDIA, Language.FR).toString());
        IntegerCounter<String> csbow = frenchSS.getBOW(null, true, false, true, MultiwordBelongingTo.WIKIPEDIA, true, Language.FR);
        System.out.println(csbow);
    }

    public static enum CompoundingParameter {
        ALLOW_MULTIWORD_EXPRESSIONS,
        ALLOW_OVERLAP_OVER_MULTIWORD_EXPRESSIONS,
        APPEND_POS,
        APPEND_TOKEN_POSITION,
        ALLOW_ONLY_NOUNS_FOR_MULTIWORD_EXPRESSIONS;

    }

    public static enum MultiwordBelongingTo {
        WORDNET(true, false, false),
        WIKIPEDIA(false, true, false),
        CUSTOM_LEXICON(false, false, true),
        WORDNET_OR_WIKIPEDIA(true, true, false),
        WORDNET_OR_CUSTOM(true, false, true),
        WIKIPEDIA_OR_CUSTOM(false, true, true),
        WORDNET_OR_WIKIPEDIA_OR_CUSTOM(true, true, true);

        boolean bWordNet;
        boolean bWikipedia;
        boolean bCustomLexicon;

        private MultiwordBelongingTo(boolean bWordNet, boolean bWikipedia, boolean bCustomLexicon) {
            this.bWordNet = bWordNet;
            this.bWikipedia = bWikipedia;
            this.bCustomLexicon = bCustomLexicon;
        }

        public boolean isWordNet() {
            return this.bWordNet;
        }

        public boolean isWikipedia() {
            return this.bWikipedia;
        }

        public boolean isCustomLexicon() {
            return this.bCustomLexicon;
        }
    }
}

