/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.pipeline.stanford;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TypedDependency;
import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.pipeline.stanford.AbstractStanfordParser;
import it.uniroma1.lcl.jlt.pipeline.stanford.Parser;
import java.util.Collection;
import java.util.List;

public class StanfordParser
extends AbstractStanfordParser {
    private static StanfordParser singleton;
    private final Parser parser = new Parser(Configuration.getInstance().getStanfordParserModel());
    private final GrammaticalStructureFactory gsFactory = this.parser.getOp().langpack().grammaticalStructureFactory();

    public static synchronized StanfordParser getInstance() {
        if (singleton == null) {
            singleton = new StanfordParser();
        }
        return singleton;
    }

    private StanfordParser() {
    }

    @Override
    public Tree parse(List<? extends HasWord> sentence) {
        return this.parser.apply(sentence);
    }

    @Override
    public Collection<TypedDependency> getTypedDependencies(Tree parse) {
        return this.gsFactory.newGrammaticalStructure(parse).typedDependencies();
    }

    @Override
    public Collection<TypedDependency> getTypedDependenciesCollapsed(Tree parse) {
        return this.gsFactory.newGrammaticalStructure(parse).typedDependenciesCollapsed();
    }

    public static void main(String[] args) {
        try {
            StanfordParser.getInstance().test("I go to school at Stanford University, which is located in California.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

