/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.pipeline.stanford;

import edu.mit.jwi.item.POS;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.pipeline.stanford.StanfordTokenizer;
import java.util.ArrayList;
import java.util.List;

public class StanfordPOSTagger {
    private final MaxentTagger tagger;
    private static StanfordPOSTagger instance;

    private StanfordPOSTagger() {
        try {
            this.tagger = new MaxentTagger(Configuration.getInstance().getStanfordPOSModel());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot init: " + e);
        }
    }

    public static synchronized StanfordPOSTagger getInstance() {
        if (instance == null) {
            instance = new StanfordPOSTagger();
        }
        return instance;
    }

    public ArrayList<TaggedWord> tag(String sentence) {
        List tokens = Sentence.toWordList((String[])sentence.split("\\s+"));
        return this.tag(tokens);
    }

    public ArrayList<TaggedWord> tag(List<? extends HasWord> sentence) {
        if (sentence == null || sentence.size() == 0) {
            return new ArrayList<TaggedWord>();
        }
        return this.tagger.tagSentence(sentence);
    }

    public static POS getPOSFromTag(String tag) {
        if (tag == null || tag.isEmpty()) {
            return null;
        }
        return StanfordPOSTagger.getPOSFromTag(tag.charAt(0));
    }

    public static POS getPOSFromTag(char tag) {
        switch (Character.toLowerCase(tag)) {
            case 'n': {
                return POS.NOUN;
            }
            case 'j': {
                return POS.ADJECTIVE;
            }
            case 'v': {
                return POS.VERB;
            }
            case 'r': {
                return POS.ADVERB;
            }
        }
        return null;
    }

    public static Character getCharFromTag(String tag) {
        if (tag == null || tag.isEmpty()) {
            return null;
        }
        return StanfordPOSTagger.getCharFromTag(tag.charAt(0));
    }

    public static Character getCharFromTag(char tag) {
        char c = Character.toLowerCase(tag);
        switch (c) {
            case 'n': 
            case 'r': 
            case 'v': {
                return Character.valueOf(c);
            }
            case 'j': {
                return Character.valueOf('a');
            }
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            String test = "industry analyst";
            System.out.println("TAGGING: industry analyst");
            List<Word> tokens = StanfordTokenizer.getInstance().tokenize("industry analyst");
            ArrayList<TaggedWord> tags = StanfordPOSTagger.getInstance().tag(tokens);
            System.out.println("RESULT: ");
            for (TaggedWord tag : tags) {
                System.out.println("\t" + tag.word() + "/" + tag.tag());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

