/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.pipeline.stanford;

import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.pipeline.stanford.StanfordTokenizer;
import java.io.File;
import java.util.List;

public class StanfordNER {
    private final AbstractSequenceClassifier<CoreLabel> classifier;
    private static StanfordNER singleton;

    private StanfordNER() {
        try {
            this.classifier = CRFClassifier.getClassifier((File)new File(Configuration.getInstance().getStanfordNERModel()));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot init: " + e);
        }
    }

    public static synchronized StanfordNER getInstance() {
        if (singleton == null) {
            singleton = new StanfordNER();
        }
        return singleton;
    }

    public List<CoreLabel> tag(String string) {
        return this.tag(StanfordTokenizer.getInstance().tokenize(string));
    }

    public static boolean isNETag(String neTag) {
        return !StanfordNER.isNotNETag(neTag);
    }

    public static boolean isNotNETag(String neTag) {
        return neTag.equals("O");
    }

    public void test(String test) {
        for (CoreLabel label : this.tag(test)) {
            System.out.print(String.valueOf(label.word()) + "/" + label.getString(CoreAnnotations.AnswerAnnotation.class) + " ");
        }
        System.out.println();
    }

    public List<CoreLabel> tag(List<? extends HasWord> tokens) {
        return this.classifier.classifySentence(tokens);
    }

    public static void main(String[] args) {
        try {
            StanfordNER.getInstance().test("jaguar company");
            StanfordNER.getInstance().test("American");
            StanfordNER.getInstance().test("Harvard");
            StanfordNER.getInstance().test("Yale");
            StanfordNER.getInstance().test("Arafat");
            StanfordNER.getInstance().test("Jackson");
            StanfordNER.getInstance().test("Mexico");
            StanfordNER.getInstance().test("Brazil");
            StanfordNER.getInstance().test("Mars");
            StanfordNER.getInstance().test("king");
            StanfordNER.getInstance().test("Wednesday");
            StanfordNER.getInstance().test("CD");
            StanfordNER.getInstance().test("brother");
            StanfordNER.getInstance().test("jaguar");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

