/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.pipeline.stanford;

import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.WordLemmaTag;
import edu.stanford.nlp.ling.WordTag;
import edu.stanford.nlp.process.Morphology;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StanfordLemmatizer {
    private static StanfordLemmatizer singleton;
    private final Morphology analyzer = new Morphology();

    private StanfordLemmatizer() {
    }

    public static synchronized StanfordLemmatizer getInstance() {
        if (singleton == null) {
            singleton = new StanfordLemmatizer();
        }
        return singleton;
    }

    public WordLemmaTag lemmatize(String word, String tag) {
        String lemma = this.analyzer.stem(word, tag).word();
        return new WordLemmaTag(word, lemma, tag);
    }

    public WordLemmaTag lemmatize(TaggedWord tw) {
        return this.lemmatize(tw.word(), tw.tag());
    }

    public List<WordTag> lemmatizeText(String tokenizedText) {
        String[] tokens;
        ArrayList<WordTag> lemmatized = new ArrayList<WordTag>();
        String[] stringArray = tokens = tokenizedText.split("\\s+");
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            String lemma = this.analyzer.stem(token);
            lemmatized.add(new WordTag(token, lemma));
            ++n2;
        }
        return lemmatized;
    }

    public String[] lemmatizeText(String[] words) {
        String[] stems = new String[words.length];
        int word = 0;
        while (word < words.length) {
            stems[word] = this.analyzer.stem(words[word]);
            ++word;
        }
        return stems;
    }

    public String lemmatizeWord(String word) {
        return this.analyzer.stem(word);
    }

    public static void main(String[] args) {
        StanfordLemmatizer lemmatizer = StanfordLemmatizer.getInstance();
        String word = "teams";
        String label = "NNS";
        System.out.println("TESTING lemmatize(String, String)");
        System.out.println("LEMMATIZING: teams/NNS");
        System.out.println("OUTPUT: " + lemmatizer.lemmatize("teams", "NNS"));
        System.out.println("=========================");
        String text = "I love exciting news articles";
        System.out.println("TESTING lemmatizeText(String)");
        System.out.println("LEMMATIZING: I love exciting news articles");
        System.out.println("OUTPUT: " + lemmatizer.lemmatizeText("I love exciting news articles"));
        System.out.println("=========================");
        System.out.println("TESTING lemmatizeText(String[])");
        System.out.println("LEMMATIZING: I love exciting news articles");
        System.out.println("OUTPUT: " + Arrays.asList(lemmatizer.lemmatizeText("I love exciting news articles".split("\\s+"))));
        System.out.println("=========================");
        System.out.println("TESTING lemmatize(TaggedWord)");
        TaggedWord tw = new TaggedWord("teams", "NNS");
        System.out.println("LEMMATIZING: " + tw);
        System.out.println("OUTPUT: " + lemmatizer.lemmatize(tw));
        System.out.println("=========================");
    }
}

