/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.pipeline.stanford;

import edu.stanford.nlp.trees.CollinsHeadFinder;
import edu.stanford.nlp.trees.Tree;

public class RightNPHeadFinder
extends CollinsHeadFinder {
    private static final long serialVersionUID = 8232401797232438222L;

    public RightNPHeadFinder() {
        this.nonTerminalInfo.put("NP", new String[][]{{"rightdis", "NN", "NNP", "NNPS", "NNS", "NX", "POS", "JJR"}, {"right", "NP"}, {"rightdis", "$", "ADJP", "PRN"}, {"right", "CD"}, {"rightdis", "JJ", "JJS", "RB", "QP"}});
    }

    protected int postOperationFix(int headIdx, Tree[] daughterTrees) {
        String prevLab;
        if (headIdx >= 2 && (prevLab = this.tlp.basicCategory(daughterTrees[headIdx - 1].value())).equals(",")) {
            int newHeadIdx = headIdx - 2;
            Tree t = daughterTrees[newHeadIdx];
            while (newHeadIdx >= 0 && t.isPreTerminal() && this.tlp.isPunctuationTag(t.value())) {
                --newHeadIdx;
            }
            if (newHeadIdx >= 0) {
                headIdx = newHeadIdx;
            }
        }
        return headIdx;
    }
}

