/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.pipeline.stanford;

import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.parser.lexparser.GrammarCompactor;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.ParserData;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.Treebank;
import java.io.FileFilter;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Parser
extends LexicalizedParser {
    private static final TreeFactory TREEFACTORY = new LabeledScoredTreeFactory();

    public Parser() {
    }

    public Parser(Options arg0) {
        super(arg0);
    }

    public Parser(String arg0) {
        super(arg0);
    }

    public Parser(ParserData arg0) {
        super(arg0);
    }

    public Parser(ObjectInputStream arg0) throws Exception {
        super(arg0);
    }

    public Parser(String arg0, Options arg1) {
        super(arg0, arg1);
    }

    public Parser(Treebank arg0, Options arg1) {
        super(arg0, arg1);
    }

    public Parser(String arg0, boolean arg1, Options arg2) {
        super(arg0, arg1, arg2);
    }

    public Parser(Treebank arg0, GrammarCompactor arg1, Options arg2) {
        super(arg0, arg1, arg2);
    }

    public Parser(String arg0, FileFilter arg1, Options arg2) {
        super(arg0, arg1, arg2);
    }

    public Parser(Treebank arg0, GrammarCompactor arg1, Options arg2, Treebank arg3) {
        super(arg0, arg1, arg2, arg3);
    }

    public Parser(Treebank arg0, DiskTreebank arg1, double arg2, GrammarCompactor arg3, Options arg4) {
        super(arg0, arg1, arg2, arg3, arg4);
    }

    public Tree apply(List<? extends HasWord> sentence) {
        try {
            if (this.parse(sentence)) {
                return this.getBestParse();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.err.println("----->" + sentence + "<-----");
        System.err.println("Falling back to PCFG parse...");
        if (this.pparser != null && this.pparser.hasParse()) {
            return Parser.returnTree(this.getBestPCFGParse());
        }
        System.err.println("Creating dummy parse...");
        return Parser.createDummyParse(sentence);
    }

    private static Tree returnTree(Tree tree) {
        System.err.println(tree);
        return tree;
    }

    public static Tree createDummyParse(List<? extends HasWord> sentence) {
        ArrayList<Tree> root = new ArrayList<Tree>();
        for (HasWord hasWord : sentence) {
            Tree t = TREEFACTORY.newLeaf(hasWord.word().toString());
            Tree t2 = null;
            t2 = hasWord instanceof HasTag ? TREEFACTORY.newTreeNode(((HasTag)hasWord).tag().toString(), Collections.singletonList(t)) : TREEFACTORY.newTreeNode("X", Collections.singletonList(t));
            root.add(t2);
        }
        return Parser.returnTree(TREEFACTORY.newTreeNode("X", root));
    }
}

