/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.pipeline.stanford;

import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.ling.WordLemmaTag;
import it.uniroma1.lcl.jlt.pipeline.stanford.StanfordLemmatizer;
import it.uniroma1.lcl.jlt.pipeline.stanford.StanfordPOSTagger;
import it.uniroma1.lcl.jlt.pipeline.stanford.StanfordTokenizer;
import java.util.ArrayList;
import java.util.List;

public class DataProcessor {
    private static DataProcessor instance;

    private DataProcessor() {
    }

    public static synchronized DataProcessor getInstance() {
        if (instance == null) {
            instance = new DataProcessor();
        }
        return instance;
    }

    public List<List<WordLemmaTag>> processText(List<String> sentences) {
        return this.processText(sentences, true);
    }

    public List<List<WordLemmaTag>> processText(List<String> sentences, boolean isTokenized) {
        ArrayList<List<WordLemmaTag>> taggedSentences = new ArrayList<List<WordLemmaTag>>();
        for (String sentence : sentences) {
            taggedSentences.add(this.processSentence(sentence, isTokenized));
        }
        return taggedSentences;
    }

    public List<WordLemmaTag> processSentence(String sentence) {
        return this.processSentence(sentence, true);
    }

    public List<WordLemmaTag> processSentence(String sentence, boolean isTokenized) {
        StanfordLemmatizer lemmatizer = StanfordLemmatizer.getInstance();
        StanfordPOSTagger tagger = StanfordPOSTagger.getInstance();
        ArrayList<WordLemmaTag> tlSentence = new ArrayList<WordLemmaTag>();
        ArrayList<TaggedWord> tSentence = null;
        if (isTokenized) {
            tSentence = tagger.tag(sentence);
        } else {
            StanfordTokenizer tokenizer = StanfordTokenizer.getInstance();
            List<Word> tokens = tokenizer.tokenize(sentence);
            tSentence = tagger.tag(tokens);
        }
        for (TaggedWord tw : tSentence) {
            tlSentence.add(lemmatizer.lemmatize(tw));
        }
        return tlSentence;
    }

    public static void main(String[] args) {
        DataProcessor DP = new DataProcessor();
        System.out.println(DP.processSentence("alertness (The quality of being [[alert]] or on the alert; briskness; nimbleness; activity., )", false));
    }
}

