/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.pipeline.stanford;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.ling.WordTag;
import edu.stanford.nlp.trees.CollinsHeadFinder;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TypedDependency;
import it.uniroma1.lcl.jlt.pipeline.stanford.RightNPHeadFinder;
import it.uniroma1.lcl.jlt.pipeline.stanford.StanfordTokenizer;
import it.uniroma1.lcl.jlt.util.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractStanfordParser {
    private static final Types<List<TaggedWord>> TAGGEDWORD = null;
    private static final WordTag COORDINATION = new WordTag("and", "CC");
    protected static final CollinsHeadFinder COLLINS_HF = new CollinsHeadFinder();
    protected static RightNPHeadFinder RIGHT_NP_HEAD_FINDER = new RightNPHeadFinder();

    protected AbstractStanfordParser() {
    }

    public abstract Tree parse(List<? extends HasWord> var1);

    public abstract Collection<TypedDependency> getTypedDependencies(Tree var1);

    public abstract Collection<TypedDependency> getTypedDependenciesCollapsed(Tree var1);

    public static List<WordTag> getHeads(Tree parse, List<WordTag> taggedYield) {
        for (WordTag word : taggedYield) {
            if (!word.equals((Object)COORDINATION)) continue;
            return AbstractStanfordParser.getHeads(parse);
        }
        ArrayList<WordTag> list = new ArrayList<WordTag>();
        list.add(AbstractStanfordParser.getHead(parse, (HeadFinder)RIGHT_NP_HEAD_FINDER));
        return list;
    }

    public static List<WordTag> getHeads(Tree parse) {
        return AbstractStanfordParser.removeDups(AbstractStanfordParser.getHead(parse, (HeadFinder)COLLINS_HF), AbstractStanfordParser.getHead(parse, (HeadFinder)RIGHT_NP_HEAD_FINDER));
    }

    public static List<Tree> getHeadPreTerminals(Tree parse, List<WordTag> taggedYield) {
        for (WordTag word : taggedYield) {
            if (!word.equals((Object)COORDINATION)) continue;
            return AbstractStanfordParser.getHeadPreTerminals(parse);
        }
        ArrayList<Tree> list = new ArrayList<Tree>();
        list.add(AbstractStanfordParser.getHeadPreTerminal(parse, (HeadFinder)RIGHT_NP_HEAD_FINDER));
        return list;
    }

    public static List<Tree> getHeadPreTerminals(Tree parse) {
        return AbstractStanfordParser.removeDups(AbstractStanfordParser.getHeadPreTerminal(parse, (HeadFinder)COLLINS_HF), AbstractStanfordParser.getHeadPreTerminal(parse, (HeadFinder)RIGHT_NP_HEAD_FINDER));
    }

    private static Tree getHeadPreTerminal(Tree parse, HeadFinder hf) {
        Tree headPre = parse.headPreTerminal(hf);
        if (!headPre.label().toString().startsWith("N") && !headPre.label().toString().equals("VBZ")) {
            for (Tree node : parse) {
                if (!node.isPhrasal() || !node.label().value().startsWith("N")) continue;
                headPre = node.headPreTerminal(hf);
                break;
            }
        }
        return headPre;
    }

    private static WordTag getHead(Tree parse, HeadFinder hf) {
        Tree headPre = AbstractStanfordParser.getHeadPreTerminal(parse, hf);
        return new WordTag(headPre.firstChild().label(), headPre.label());
    }

    public static List<List<WordTag>> getMinimalHeadPhrases(Tree parseTree) {
        ArrayList<List<WordTag>> headPhrases = new ArrayList<List<WordTag>>();
        for (Tree headMinimalPhrase : AbstractStanfordParser.getMinimalHeadTrees(parseTree)) {
            headPhrases.add(AbstractStanfordParser.getYield(headMinimalPhrase));
        }
        return headPhrases;
    }

    public static List<Tree> getMinimalHeadTrees(Tree parse) {
        ArrayList<Tree> minimalHeadPhrases = new ArrayList<Tree>();
        List<WordTag> taggedYield = AbstractStanfordParser.getYield(parse);
        for (Tree headPreTerminal : AbstractStanfordParser.getHeadPreTerminals(parse, taggedYield)) {
            Tree minimalPhrase = null;
            for (Tree dominationNode : parse.dominationPath(headPreTerminal)) {
                if (!dominationNode.isPhrasal()) continue;
                minimalPhrase = dominationNode;
            }
            minimalHeadPhrases.add(minimalPhrase);
        }
        return minimalHeadPhrases;
    }

    public static List<WordTag> getYield(Tree parse) {
        ArrayList<WordTag> wordTagYield = new ArrayList<WordTag>();
        for (TaggedWord word : Types.uncheckedCast(parse.taggedYield(), TAGGEDWORD)) {
            wordTagYield.add(new WordTag(word.value(), word.tag()));
        }
        return wordTagYield;
    }

    private static <T> List<T> removeDups(T collinsHead, T myHead) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(collinsHead);
        if (!myHead.equals(collinsHead)) {
            list.add(myHead);
        }
        return list;
    }

    public static List<Integer> getHeadIdx(List<WordTag> taggedYield, List<WordTag> taggedHeads) {
        ArrayList<Integer> headIdxs = new ArrayList<Integer>();
        block0: for (WordTag word : taggedHeads) {
            int constituent = 0;
            while (constituent < taggedYield.size()) {
                if (taggedYield.get(constituent).equals((Object)word)) {
                    headIdxs.add(constituent);
                    continue block0;
                }
                ++constituent;
            }
        }
        return headIdxs;
    }

    public static CollinsHeadFinder getCollinshf() {
        return COLLINS_HF;
    }

    public static RightNPHeadFinder getRightNPHf() {
        return RIGHT_NP_HEAD_FINDER;
    }

    public void test(String test) {
        System.out.println("INPUT: " + test);
        List<Word> tokens = StanfordTokenizer.getInstance().tokenize(test);
        Tree parse = this.parse(tokens);
        System.out.println("PARSE: " + parse + "\n" + parse.pennString());
        List<WordTag> yield = AbstractStanfordParser.getYield(parse);
        System.out.println("YIELD: " + yield);
        List<WordTag> heads = AbstractStanfordParser.getHeads(parse);
        System.out.println("HEADS: " + heads);
        System.out.println("HEADSIDXS: " + AbstractStanfordParser.getHeadIdx(yield, heads));
    }
}

