/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.mysql;

import it.uniroma1.lcl.jlt.mysql.AbstractTableCache;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class TableCache<K, V>
extends AbstractTableCache<K, V> {
    protected final Map<K, V> map = new HashMap();
    protected final String valueField;

    public TableCache(String url, String user, String password, String table, String keyField, String valueField) {
        super(url, user, password, table, keyField);
        this.valueField = valueField;
    }

    public void put(K k, V v) {
        this.flush();
        this.map.put(k, v);
    }

    @Override
    public void dumpStmtFile(Writer writer) throws IOException {
        log.info((Object)("FLUSHING " + this.map.size() + " ENTRIES INTO TABLE " + this.table));
        StringBuilder buffer = new StringBuilder();
        int counter = 0;
        for (K k : this.map.keySet()) {
            buffer.setLength(0);
            String kval = this.getQuoted(k);
            V v = this.map.get(k);
            String vval = this.getQuoted(v);
            String query = buffer.append("insert into ").append(this.table).append("(").append(this.keyField).append(",").append(this.valueField).append(") values(").append(kval).append(",").append(vval).append(") on duplicate key update ").append(this.valueField).append("=").append(vval).append(";\n").toString();
            writer.write(query);
            if (++counter % 100000 != 0) continue;
            log.info((Object)("\tDUMPED " + counter + " KEYS SO FAR ... "));
        }
        this.map.clear();
        log.info((Object)"DONE!");
    }

    public static void main(String[] args) {
        try {
            TableCache<Integer, String> tc = new TableCache<Integer, String>("jdbc:mysql://localhost:3306/test", "root", "root", "pippo", "id", "word");
            tc.put(1, "attila");
            tc.put(2, "flacello");
            tc.put(2, "ti");
            tc.put(3, "tio");
            int k = 0;
            while (k < 1000000) {
                tc.put(k, "valore" + k);
                ++k;
            }
            tc.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

