/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.mysql;

import it.uniroma1.lcl.jlt.mysql.TableCache;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;

public class NumericTableCache<K, V extends Number>
extends TableCache<K, Double> {
    protected Set<K> put = new HashSet<K>();

    public NumericTableCache(String url, String user, String password, String table, String keyField, String valueField) {
        super(url, user, password, table, keyField, valueField);
    }

    @Override
    public void put(K k, Double v) {
        this.flush();
        this.put.add(k);
        this.map.put(k, Double.valueOf(v));
    }

    public void add(K k, V v) {
        this.flush();
        Double prev = (Double)this.map.get(k);
        if (prev == null) {
            prev = 0.0;
        }
        this.map.put(k, prev + ((Number)v).doubleValue());
    }

    @Override
    public void dumpStmtFile(Writer writer) throws IOException {
        log.info((Object)("FLUSHING " + this.map.size() + " ENTRIES INTO TABLE " + this.table));
        StringBuilder buffer = new StringBuilder();
        int counter = 0;
        for (Object k : this.map.keySet()) {
            buffer.setLength(0);
            String kval = this.getQuoted(k);
            Double v = (Double)this.map.get(k);
            buffer.append("insert into ").append(this.table).append("(").append(this.keyField).append(",").append(this.valueField).append(") values(").append(kval).append(",").append(v).append(") on duplicate key update ").append(this.valueField).append("=");
            if (this.put.contains(k)) {
                buffer.append(v);
            } else {
                buffer.append(this.valueField).append("+").append(v).append(";\n");
            }
            writer.write(buffer.toString());
            if (++counter % 100000 != 0) continue;
            log.info((Object)("\tDUMPED " + counter + " KEYS SO FAR ... "));
        }
        this.map.clear();
        this.put.clear();
    }

    public static void main(String[] args) {
        NumericTableCache<Integer, Integer> tc = new NumericTableCache<Integer, Integer>("jdbc:mysql://localhost:3306/test", "root", "root", "pippo", "id", "word");
        int j = 0;
        while (j < 10) {
            int k = 0;
            while (k < 10) {
                tc.add(k, 3);
                ++k;
            }
            ++j;
        }
        tc.close();
    }
}

