/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.mysql;

import it.uniroma1.lcl.jlt.mysql.MultiTableCache;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NumericMultiTableCache<K, V>
extends MultiTableCache<K, V> {
    private final String numericField;
    private final Map<K, Double> scoreMap = new HashMap<K, Double>();

    public NumericMultiTableCache(String url, String user, String password, String table, String keyField, List<String> valueFields, String numericField) {
        super(url, user, password, table, keyField, valueFields);
        this.numericField = numericField;
    }

    public void add(K k, Number score, V ... vs) {
        this.put(k, vs);
        Double prev = this.scoreMap.get(k);
        if (prev == null) {
            prev = 0.0;
        }
        this.scoreMap.put(k, prev + score.doubleValue());
    }

    @Override
    public void dumpStmtFile(Writer writer) throws IOException {
        log.info((Object)("FLUSHING " + this.map.size() + " ENTRIES INTO TABLE " + this.table));
        StringBuilder buffer = new StringBuilder();
        int counter = 0;
        for (Object k : this.map.keySet()) {
            buffer.setLength(0);
            String kval = this.getQuoted(k);
            Collection vals = this.map.get(k);
            Double score = this.scoreMap.get(k);
            buffer.append("insert into ").append(this.table).append("(").append(this.keyField);
            for (String valueField : this.valueFields) {
                buffer.append(",").append(valueField);
            }
            buffer.append(",").append(this.numericField);
            buffer.append(") values(").append(kval).append(",");
            for (Object v : vals) {
                String vval = this.getQuoted(v);
                buffer.append(vval).append(",");
            }
            buffer.append(score);
            buffer.append(") on duplicate key update ");
            int i = 0;
            for (Object v : vals) {
                String vval = this.getQuoted(v);
                buffer.append((String)this.valueFields.get(i)).append("=").append(vval).append(",");
                ++i;
            }
            buffer.append(this.numericField).append("=").append(this.numericField).append("+").append(score).append(";\n");
            writer.write(buffer.toString());
            if (++counter % 100000 != 0) continue;
            log.info((Object)("\tDUMPED " + counter + " KEYS SO FAR ... "));
        }
        this.map.clear();
        this.scoreMap.clear();
        log.info((Object)"DONE!");
    }

    public static void main(String[] args) {
        try {
            ArrayList<String> vals = new ArrayList<String>();
            vals.add("w1");
            vals.add("w2");
            NumericMultiTableCache<Integer, String> tc = new NumericMultiTableCache<Integer, String>("PUT A DB NAME HERE", "PUT A DB USER HERE", "PUT A DB PASSWD HERE", "pippo", "id", vals, "count");
            tc.add(1, 11.0, "<s>", "attila");
            tc.add(2, 3.0, "attila", "flacello");
            tc.add(3, 76.0, "flacello", "ti");
            tc.add(4, 55.0, "ti", "tio");
            tc.add(5, 69.0, "tio", "</s>");
            tc.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

