/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.mysql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MySQLDB {
    protected static final Log log = LogFactory.getLog(MySQLDB.class);
    protected final Connection connection;

    public MySQLDB(String url, String user, String password) {
        this.connection = this.getConnection(url, user, password);
    }

    public ResultSet executeQuery(String query) {
        return this.executeQuery(query, false);
    }

    public ResultSet executeQuery(String query, boolean streamingResultSet) {
        try {
            Statement stmt = this.connection.createStatement();
            if (streamingResultSet) {
                stmt.setFetchSize(Integer.MIN_VALUE);
            }
            return stmt.executeQuery(query);
        }
        catch (SQLException e) {
            log.warn((Object)("CANNOT EXECUTE QUERY: " + query + " / EXCEPTION: " + e));
            return null;
        }
    }

    public void executeUpdate(String query) {
        try {
            Statement stmt = this.connection.createStatement();
            stmt.executeUpdate(query);
            stmt.close();
        }
        catch (SQLException e) {
            log.warn((Object)("CANNOT EXECUTE QUERY: " + query + " / EXCEPTION: " + e));
        }
    }

    public boolean executeQuery(PreparedStatement query) {
        try {
            return query.execute();
        }
        catch (SQLException e) {
            log.warn((Object)("CANNOT EXECUTE QUERY: " + query + " / EXCEPTION: " + e));
            return false;
        }
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            log.warn((Object)("CANNOT CLOSE: " + e));
        }
    }

    protected Connection getConnection(String url, String user, String password) {
        try {
            Class.forName("org.gjt.mm.mysql.Driver");
            return DriverManager.getConnection(url, user, password);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot init: " + e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }
}

