/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.mysql;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import it.uniroma1.lcl.jlt.mysql.AbstractTableCache;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MultiTableCache<K, V>
extends AbstractTableCache<K, V> {
    protected final List<String> valueFields;
    protected final Multimap<K, V> map = new LinkedHashMultimap();

    public MultiTableCache(String url, String user, String password, String table, String keyField, List<String> valueFields) {
        super(url, user, password, table, keyField);
        this.valueFields = valueFields;
    }

    public void put(K k, V ... vs) {
        this.flush();
        if (vs.length != this.valueFields.size()) {
            throw new IllegalArgumentException("ILLEGAL #VALS: " + vs.length + " vs. " + this.valueFields.size());
        }
        this.map.removeAll(k);
        V[] VArray = vs;
        int n = vs.length;
        int n2 = 0;
        while (n2 < n) {
            V v = VArray[n2];
            this.map.put(k, v);
            ++n2;
        }
    }

    @Override
    public void dumpStmtFile(Writer writer) throws IOException {
        log.info((Object)("FLUSHING " + this.map.size() + " ENTRIES INTO TABLE " + this.table));
        StringBuilder buffer = new StringBuilder();
        int counter = 0;
        for (Object k : this.map.keySet()) {
            buffer.setLength(0);
            String kval = this.getQuoted(k);
            Collection vals = this.map.get(k);
            buffer.append("insert into ").append(this.table).append("(").append(this.keyField);
            for (String valueField : this.valueFields) {
                buffer.append(",").append(valueField);
            }
            buffer.append(") values(").append(kval);
            for (Object v : vals) {
                String vval = this.getQuoted(v);
                buffer.append(",").append(vval);
            }
            buffer.append(") on duplicate key update ");
            int i = 0;
            for (Object v : vals) {
                if (i > 0) {
                    buffer.append(",");
                }
                String vval = this.getQuoted(v);
                buffer.append(this.valueFields.get(i)).append("=").append(vval);
                ++i;
            }
            buffer.append(";\n");
            writer.write(buffer.toString());
            if (++counter % 100000 != 0) continue;
            log.info((Object)("\tDUMPED " + counter + " KEYS SO FAR ... "));
        }
        this.map.clear();
        log.info((Object)"DONE!");
    }

    public static void main(String[] args) {
        try {
            ArrayList<String> vals = new ArrayList<String>();
            vals.add("w1");
            vals.add("w2");
            MultiTableCache<Integer, String> tc = new MultiTableCache<Integer, String>("PUT A DB NAME HERE", "PUT A DB USER HERE", "PUT A DB PASSWD HERE", "pippo", "id", vals);
            tc.put(1, "<s>", "attila");
            tc.put(2, "attila", "flacello");
            tc.put(3, "flacello", "ti");
            tc.put(4, "ti", "tio");
            tc.put(5, "tio", "</s>");
            tc.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

