/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.mysql;

import it.uniroma1.lcl.jlt.mysql.MySQLDB;
import it.uniroma1.lcl.jlt.util.Timer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class CooccurrenceDB
extends MySQLDB {
    public static final int TOTAL_ID = -1;
    private final PreparedStatement updateLexicon;
    private final PreparedStatement updateCollocs;
    private final PreparedStatement updateDice;
    private final PreparedStatement getDice;
    private final PreparedStatement lexiconCount;
    private final PreparedStatement collocsCount;

    public CooccurrenceDB(String url, String user, String password) {
        super(url, user, password);
        try {
            this.updateLexicon = this.connection.prepareStatement("INSERT INTO lexicon (id, word,count) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE count=count+?");
            this.updateCollocs = this.connection.prepareStatement("INSERT INTO collocs VALUES (?, ?, ?, 0) ON DUPLICATE KEY UPDATE count=count+?");
            this.updateDice = this.connection.prepareStatement("UPDATE collocs SET dice=? WHERE w1=? AND w2=?");
            this.getDice = this.connection.prepareStatement("SELECT dice FROM collocs WHERE w1=? AND w2=?");
            this.lexiconCount = this.connection.prepareStatement("SELECT count FROM lexicon WHERE id=?");
            this.collocsCount = this.connection.prepareStatement("SELECT count FROM collocs WHERE w1=? AND w2=?");
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot init: " + e);
        }
    }

    public void updateLexicon(int id, String word) {
        this.updateLexicon(id, word, 1);
    }

    public void updateLexicon(int id, String word, int increment) {
        try {
            this.updateLexicon.setInt(1, id);
            this.updateLexicon.setString(2, word);
            this.updateLexicon.setInt(3, increment);
            this.updateLexicon.setInt(4, increment);
        }
        catch (SQLException e) {
            log.warn((Object)("CANNOT SET QUERY: " + this.updateLexicon + " / EXCEPTION: " + e));
        }
        this.executeQuery(this.updateLexicon);
    }

    public void updateCollocs(int word1, int word2) {
        this.updateCollocs(word1, word2, 1);
    }

    public void updateCollocs(int word1, int word2, int increment) {
        try {
            this.updateCollocs.setInt(1, word1);
            this.updateCollocs.setInt(2, word2);
            this.updateCollocs.setInt(3, increment);
            this.updateCollocs.setInt(4, increment);
        }
        catch (SQLException e) {
            log.warn((Object)("CANNOT SET QUERY: " + this.updateCollocs + " / EXCEPTION: " + e));
        }
        this.executeQuery(this.updateCollocs);
    }

    public int getLexiconCount(int id) throws SQLException {
        this.lexiconCount.setInt(1, id);
        if (this.executeQuery(this.lexiconCount)) {
            ResultSet res = this.lexiconCount.getResultSet();
            if (res.next()) {
                int count = res.getInt(1);
                return count;
            }
        } else {
            log.warn((Object)("NO COUNTS FOR: " + id));
        }
        return -1;
    }

    public int getLexiconTotalCount() throws SQLException {
        return this.getLexiconCount(-1);
    }

    public int getCollocsCount(int id1, int id2) throws SQLException {
        this.collocsCount.setInt(1, id1);
        this.collocsCount.setInt(2, id2);
        if (this.executeQuery(this.collocsCount)) {
            ResultSet res = this.collocsCount.getResultSet();
            if (res.next()) {
                int count = res.getInt(1);
                return count;
            }
        } else {
            log.warn((Object)("NO COUNTS FOR: " + id1 + "/" + id2));
        }
        return -1;
    }

    public int getCollocsTotalCount() throws SQLException {
        return this.getCollocsCount(-1, -1);
    }

    public void updateDice(int id1, int id2, double dice) throws SQLException {
        this.updateDice.setDouble(1, dice);
        this.updateDice.setInt(2, id1);
        this.updateDice.setInt(3, id2);
        this.executeQuery(this.updateDice);
    }

    public Double getDice(int id1, int id2) throws SQLException {
        if (id1 < id2) {
            this.getDice.setInt(1, id1);
            this.getDice.setInt(2, id2);
        } else {
            this.getDice.setInt(1, id2);
            this.getDice.setInt(2, id1);
        }
        if (this.executeQuery(this.getDice)) {
            ResultSet res = this.getDice.getResultSet();
            if (res.next()) {
                double score = res.getDouble(1);
                return score;
            }
        } else {
            log.warn((Object)("NO COUNTS FOR: " + id1 + "/" + id2));
        }
        return -1.0;
    }

    public List<String> getCooccurringWords(int word) throws SQLException {
        ArrayList<Integer> resultIDs = new ArrayList<Integer>();
        String w1Query = "SELECT w1 FROM collocs WHERE w2=" + word;
        ResultSet results1 = this.executeQuery(w1Query);
        results1.beforeFirst();
        while (results1.next()) {
            resultIDs.add(results1.getInt(1));
        }
        results1.close();
        String w2Query = "SELECT w2 FROM collocs WHERE w1=" + word;
        ResultSet results2 = this.executeQuery(w2Query);
        results2.beforeFirst();
        while (results2.next()) {
            resultIDs.add(results2.getInt(1));
        }
        results2.close();
        ArrayList<String> resultWords = new ArrayList<String>();
        PreparedStatement lexiconQuery = this.connection.prepareStatement("select word FROM lexicon where id=?");
        Iterator iterator = resultIDs.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            lexiconQuery.setInt(1, id);
            if (!this.executeQuery(lexiconQuery)) continue;
            ResultSet lexiconResults = lexiconQuery.getResultSet();
            lexiconResults.last();
            if (lexiconResults.getRow() != 1) {
                throw new RuntimeException("Must return exactly 1 result for the id: " + id);
            }
            lexiconResults.beforeFirst();
            while (lexiconResults.next()) {
                resultWords.add(lexiconResults.getString(1));
            }
            lexiconResults.close();
        }
        return resultWords;
    }

    public static void createDiceStatements(CooccurrenceDB db, String dbName) throws IOException, SQLException {
        HashMap<Integer, Double> lexiconCountsCache = new HashMap<Integer, Double>();
        BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + dbName + "-dice.sql"));
        writer.write("USE " + dbName + ";\n");
        double lexiconTotal = db.getLexiconTotalCount();
        if (lexiconTotal == 0.0) {
            throw new RuntimeException("total(lexicon) cannot be 0!");
        }
        double collocsTotal = db.getCollocsTotalCount();
        if (collocsTotal == 0.0) {
            throw new RuntimeException("total(collocs) cannot be 0!");
        }
        int counter = 0;
        Timer timer = new Timer();
        Connection connection = db.getConnection();
        PreparedStatement selectStmt = connection.prepareStatement("SELECT w2,count FROM collocs WHERE w1=?");
        ResultSet iOffsets = db.executeQuery("SELECT id,count FROM lexicon");
        iOffsets.last();
        int allOffsets = iOffsets.getRow();
        iOffsets.beforeFirst();
        while (iOffsets.next()) {
            int iOffset = iOffsets.getInt(1);
            double iCount = iOffsets.getDouble(2);
            lexiconCountsCache.put(iOffset, iCount);
            if (iCount == 0.0) {
                throw new RuntimeException("count_i cannot be 0!");
            }
            selectStmt.setInt(1, iOffset);
            ResultSet jOffsets = selectStmt.executeQuery();
            while (jOffsets.next()) {
                int jOffset = jOffsets.getInt(1);
                Double jCount = (Double)lexiconCountsCache.get(jOffsets);
                if (jCount == null) {
                    jCount = db.getLexiconCount(jOffset);
                    lexiconCountsCache.put(jOffset, jCount);
                }
                if (jCount == 0.0) {
                    throw new RuntimeException("count_j cannot be 0!");
                }
                double ijCount = jOffsets.getDouble(2);
                if (ijCount == 0.0) {
                    throw new RuntimeException("count_ij cannot be 0!");
                }
                double dice = 2.0 * ijCount / (iCount + jCount);
                if (dice > 1.0) {
                    log.warn((Object)("DICE > 1 FOR w1=" + iOffset + " AND w2=" + jOffset));
                    dice = 1.0;
                }
                try {
                    writer.write("UPDATE collocs SET dice=" + dice + " WHERE w1=" + iOffset + " AND w2=" + jOffset + ";\n");
                }
                catch (Exception e) {
                    log.warn((Object)("\tEXCEPTION: " + e + "\n" + "\tICOUNT: " + iCount + "\n" + "\tJCOUNT: " + jCount + "\n" + "\tIJCOUNT: " + ijCount + "\n" + "\t=========================" + "\n" + "\tDICE => " + dice + "\n" + "\t=========================" + "\n" + "\t=========================" + "\n"));
                }
            }
            jOffsets.close();
            if (++counter % 1000 != 0) continue;
            timer.tick("to process " + counter + " items of " + allOffsets);
        }
        iOffsets.close();
        selectStmt.close();
        writer.flush();
        writer.close();
    }

    public static void computeDice(CooccurrenceDB db) throws SQLException {
        log.info((Object)("Computing the dice values for " + db.toString()));
        HashMap<Integer, Double> lexiconCountsCache = new HashMap<Integer, Double>();
        double lexiconTotal = db.getLexiconTotalCount();
        if (lexiconTotal == 0.0) {
            throw new RuntimeException("total(lexicon) cannot be 0!");
        }
        double collocsTotal = db.getCollocsTotalCount();
        if (collocsTotal == 0.0) {
            throw new RuntimeException("total(collocs) cannot be 0!");
        }
        int batchCounter = 0;
        int counter = 0;
        Timer timer1 = new Timer();
        Timer timer2 = new Timer();
        Connection connection = db.getConnection();
        connection.setAutoCommit(false);
        PreparedStatement selectStmt = connection.prepareStatement("SELECT w2,count FROM collocs WHERE w1=?");
        PreparedStatement updateStmt = connection.prepareStatement("UPDATE collocs SET dice=? WHERE w1=? AND w2=?");
        ResultSet iOffsets = db.executeQuery("SELECT id,count FROM lexicon");
        iOffsets.last();
        int allOffsets = iOffsets.getRow();
        iOffsets.beforeFirst();
        while (iOffsets.next()) {
            int iOffset = iOffsets.getInt(1);
            Double iCount = iOffsets.getDouble(2);
            lexiconCountsCache.put(iOffset, iCount);
            if (iCount == 0.0) {
                throw new RuntimeException("count_i cannot be 0!");
            }
            selectStmt.setInt(1, iOffset);
            ResultSet jOffsets = selectStmt.executeQuery();
            while (jOffsets.next()) {
                int jOffset = jOffsets.getInt(1);
                Double jCount = (Double)lexiconCountsCache.get(jOffsets);
                if (jCount == null) {
                    jCount = db.getLexiconCount(jOffset);
                    lexiconCountsCache.put(jOffset, jCount);
                }
                if (jCount == 0.0) {
                    throw new RuntimeException("count_j cannot be 0!");
                }
                double ijCount = jOffsets.getDouble(2);
                if (ijCount == 0.0) {
                    throw new RuntimeException("count_ij cannot be 0!");
                }
                double dice = 2.0 * ijCount / (iCount + jCount);
                if (dice > 1.0) {
                    log.warn((Object)("DICE > 1 FOR w1=" + iOffset + " AND w2=" + jOffset));
                    dice = 1.0;
                }
                updateStmt.setDouble(1, dice);
                updateStmt.setInt(2, iOffset);
                updateStmt.setInt(3, jOffset);
                updateStmt.addBatch();
                ++batchCounter;
            }
            jOffsets.close();
            if (++counter % 10000 != 0) continue;
            log.info((Object)("to load " + batchCounter + " batch commands, now updating"));
            timer1.tick("to load " + batchCounter + " batch commands, now updating");
            try {
                updateStmt.executeBatch();
                connection.commit();
                updateStmt.clearBatch();
            }
            catch (BatchUpdateException be) {
                log.warn((Object)"PROBLEMS COMMITTING: ROLLING BACK...");
                connection.rollback();
            }
            timer1.tick("to execute " + batchCounter + " batch updates");
            batchCounter = 0;
            timer2.tick("to overall process " + counter + " items of " + allOffsets);
        }
        iOffsets.close();
        updateStmt.executeBatch();
        updateStmt.close();
        selectStmt.close();
        connection.commit();
        connection.close();
        timer2.tick("to calculate dice for all the " + counter + " items");
    }

    public static void computeDiceIfNull(CooccurrenceDB db) throws SQLException {
        log.info((Object)("Computing the dice values for " + db.toString()));
        double lexiconTotal = db.getLexiconTotalCount();
        if (lexiconTotal == 0.0) {
            throw new RuntimeException("total(lexicon) cannot be 0!");
        }
        double collocsTotal = db.getCollocsTotalCount();
        if (collocsTotal == 0.0) {
            throw new RuntimeException("total(collocs) cannot be 0!");
        }
        int batchCounter = 0;
        int counter = 0;
        Timer timer1 = new Timer();
        Timer timer2 = new Timer();
        Connection connection = db.getConnection();
        connection.setAutoCommit(false);
        PreparedStatement selectStmt = connection.prepareStatement("SELECT w2,count FROM collocs WHERE w1=?");
        PreparedStatement updateStmt = connection.prepareStatement("UPDATE collocs SET dice=? WHERE w1=? AND w2=?");
        ResultSet targetPairs = db.executeQuery("SELECT w1,w2,count FROM collocs WHERE dice IS NULL");
        targetPairs.last();
        int allOffsets = targetPairs.getRow();
        targetPairs.beforeFirst();
        while (targetPairs.next()) {
            int w1 = targetPairs.getInt(1);
            int w2 = targetPairs.getInt(2);
            ResultSet w1Results = db.executeQuery("SELECT count FROM lexicon WHERE id=" + w1);
            ResultSet w2Results = db.executeQuery("SELECT count FROM lexicon WHERE id=" + w2);
            w1Results.first();
            w2Results.first();
            double w1Count = w1Results.getDouble(1);
            double w2Count = w2Results.getDouble(1);
            double w12Count = targetPairs.getDouble(3);
            if (w1Count == 0.0) {
                throw new RuntimeException("Count w1 (" + w1 + ") cannot be 0!");
            }
            if (w2Count == 0.0) {
                throw new RuntimeException("Count w2 (" + w2 + ") cannot be 0!");
            }
            if (w12Count == 0.0) {
                throw new RuntimeException("Count w1,w2 (" + w12Count + ") cannot be 0!");
            }
            double dice = 2.0 * w12Count / (w1Count + w2Count);
            if (dice > 1.0) {
                log.warn((Object)("DICE > 1 FOR w1=" + w1 + " AND w2=" + w2));
                dice = 1.0;
            }
            updateStmt.setDouble(1, dice);
            updateStmt.setInt(2, w1);
            updateStmt.setInt(3, w2);
            updateStmt.addBatch();
            ++batchCounter;
            if (++counter % 10 != 0) continue;
            log.info((Object)("to load " + batchCounter + " batch commands, now updating"));
            timer1.tick("to load " + batchCounter + " batch commands, now updating");
            try {
                updateStmt.executeBatch();
                connection.commit();
                updateStmt.clearBatch();
            }
            catch (BatchUpdateException be) {
                log.warn((Object)"PROBLEMS COMMITTING: ROLLING BACK...");
                connection.rollback();
            }
            timer1.tick("to execute " + batchCounter + " batch updates");
            batchCounter = 0;
            timer2.tick("to overall process " + counter + " items of " + allOffsets);
        }
        targetPairs.close();
        updateStmt.executeBatch();
        updateStmt.close();
        selectStmt.close();
        connection.commit();
        connection.close();
        timer2.tick("to calculate dice for all the " + counter + " items");
    }
}

