/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.mysql;

import it.uniroma1.lcl.jlt.util.Pair;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractTableCache<K, V> {
    protected static final Log log = LogFactory.getLog(AbstractTableCache.class);
    private static final long MEMORY_LIMIT = Runtime.getRuntime().maxMemory() / 0x100000L / 5L;
    protected final String db;
    protected final String user;
    protected final String passwd;
    protected final String table;
    protected final String keyField;
    protected final String sinkFile;

    protected AbstractTableCache(String db, String user, String password, String table, String keyField) {
        this.db = db;
        this.user = user;
        this.passwd = password;
        this.table = table;
        this.keyField = keyField;
        this.sinkFile = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + db + "-" + table + ".sql";
        try {
            FileWriter writer = new FileWriter(this.sinkFile);
            writer.write("USE " + db + ";\n");
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot dump: " + e);
        }
    }

    public void flush() {
        long freeMBs = Runtime.getRuntime().freeMemory() / 0x100000L;
        if (freeMBs < MEMORY_LIMIT) {
            log.info((Object)("FREE MEMORY: " + freeMBs + " LIMIT: " + MEMORY_LIMIT + " FORCING FLUSH"));
            this.forceFlush();
            Runtime.getRuntime().gc();
            freeMBs = Runtime.getRuntime().freeMemory() / 0x100000L;
            log.info((Object)("FREE MEMORY (after garbage collection): " + freeMBs));
        }
    }

    public void forceFlush() {
        try {
            log.info((Object)"\tDUMPING QUERIES TO AN EXTERNAL FILE ... ");
            FileWriter writer = new FileWriter(this.sinkFile, true);
            this.dumpStmtFile(writer);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot dump: " + e);
        }
    }

    public abstract void dumpStmtFile(Writer var1) throws IOException;

    public void close() {
        this.forceFlush();
    }

    protected String getQuoted(Object k) {
        StringBuilder buffer = new StringBuilder();
        if (k instanceof Iterable) {
            for (Object obj : (Iterable)k) {
                buffer.append(this.getSingleQuoted(obj)).append(",");
            }
            if (buffer.length() > 0) {
                buffer.deleteCharAt(buffer.length() - 1);
            }
            return buffer.toString();
        }
        if (k instanceof Pair) {
            Pair pair = (Pair)k;
            buffer.append(this.getSingleQuoted(pair.getFirst())).append(",").append(this.getSingleQuoted(pair.getSecond()));
            return buffer.toString();
        }
        return this.getSingleQuoted(k);
    }

    protected String getSingleQuoted(Object k) {
        if (k instanceof String) {
            String cleanK = k.toString();
            cleanK = cleanK.replaceAll("'", "_");
            cleanK = cleanK.replaceAll("\\\\", "\\\\\\\\");
            StringBuilder buffer = new StringBuilder();
            return buffer.append("'").append(cleanK).append("'").toString();
        }
        return k.toString();
    }

    public String getSinkFile() {
        return this.sinkFile;
    }
}

