/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.multilingual;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.util.Files;
import it.uniroma1.lcl.jlt.util.Language;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MultilingualPOS {
    private Map<String, HashMap<String, String>> cache = new HashMap<String, HashMap<String, String>>();
    private static MultilingualPOS instance = null;

    public static MultilingualPOS getInstance() {
        if (instance == null) {
            instance = new MultilingualPOS();
        }
        return instance;
    }

    private MultilingualPOS() {
    }

    public HashMap<String, String> getPosMap(String index) throws IOException {
        if (!this.cache.keySet().contains(index)) {
            String filename = String.valueOf(Configuration.getInstance().getMultilanguagePOSMappingFolder()) + index + ".tsv";
            HashMap<String, String> newMap = new HashMap<String, String>();
            BufferedReader br = Files.getBufferedReader(filename);
            while (br.ready()) {
                String line = br.readLine();
                String[] lines = line.split("\t");
                if (lines.length != 2) continue;
                newMap.put(lines[0], lines[1]);
            }
            br.close();
            this.cache.put(index, newMap);
        }
        return this.cache.get(index);
    }

    public String getPOS(String pos, Language sourceLanguage, Language destinationLanguage, TaggerSystem sourceTaggerSystem, TaggerSystem destinationTaggerSystem) throws IOException {
        String index = String.valueOf(sourceTaggerSystem.name()) + "-" + destinationTaggerSystem.name() + "-" + sourceLanguage.name() + "-" + destinationLanguage.name();
        HashMap<String, String> mapping = this.getPosMap(index);
        return mapping.get(pos);
    }

    public String getUniversalPOS(String pos, Language sourceLanguage, TaggerSystem sourceTaggerSystem) {
        return "";
    }

    public static void main(String[] args) throws IOException {
        MultilingualPOS mpos = MultilingualPOS.getInstance();
        String tpos = mpos.getPOS("NUM", Language.FR, Language.EN, TaggerSystem.STANFORD, TaggerSystem.TREETAGGER);
        System.out.println("NUM ->" + tpos);
    }

    public static enum TaggerSystem {
        STANFORD,
        TREETAGGER,
        TREETAGGERCHUNKER;

    }
}

