/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.mt.moses;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.mt.Sentence;
import it.uniroma1.lcl.jlt.mt.Translation;
import it.uniroma1.lcl.jlt.mt.Translator;
import it.uniroma1.lcl.jlt.mt.UnsupportedLanguageException;
import it.uniroma1.lcl.jlt.mt.moses.MosesTranslation;
import it.uniroma1.lcl.jlt.util.Language;
import it.uniroma1.lcl.jlt.util.Runner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MosesTranslator
extends Translator {
    public static final Log log = LogFactory.getLog(MosesTranslator.class);
    private static MosesTranslator instance = null;

    protected MosesTranslator() {
    }

    public static MosesTranslator getInstance() {
        if (instance == null) {
            instance = new MosesTranslator();
        }
        return instance;
    }

    @Override
    public List<Translation> translate(Collection<Sentence> sourceSentences, Language targetLang) throws UnsupportedLanguageException {
        ArrayList<Translation> translations = new ArrayList<Translation>();
        try {
            String fullPath = this.writeSentenceFile(sourceSentences, targetLang);
            Runner.getInstance().run(Configuration.getInstance().getMosesBin(), Configuration.getInstance().getMosesIniFile(targetLang), fullPath);
            new File(fullPath).delete();
            BufferedReader br = new BufferedReader(new FileReader(String.valueOf(fullPath) + ".out"));
            while (br.ready()) {
                String line = br.readLine();
                MosesTranslation t = new MosesTranslation(line);
                translations.add(t);
            }
            br.close();
            new File(String.valueOf(fullPath) + ".out").delete();
        }
        catch (IOException e) {
            log.info((Object)e);
        }
        this.store(sourceSentences, translations);
        return translations;
    }

    @Override
    public void store(Collection<Sentence> sourceSentences, List<Translation> translations) {
        Iterator<Sentence> i = sourceSentences.iterator();
        for (Translation t : translations) {
            Sentence source = i.next();
            List<Sentence.SenseAnnotation> senseAnnotations = source.getSenseAnnotations();
            for (Sentence.SenseAnnotation a : senseAnnotations) {
                String translationPhrase = t.getTranslationPhrase(a.getStartToken(), a.getEndToken()).toLowerCase();
                this.translationMemory.count(a.getTitle(), translationPhrase);
            }
        }
    }

    @Override
    public String translate(String input, Language source, Language target) {
        throw new UnsupportedOperationException();
    }
}

