/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.mt.moses;

import it.uniroma1.lcl.jlt.mt.Translation;
import it.uniroma1.lcl.jlt.util.Pair;
import it.uniroma1.lcl.jlt.util.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MosesTranslation
extends Translation {
    protected List<Pair<Integer, Integer>> alignment;

    public MosesTranslation(String sentence) {
        super(sentence);
    }

    @Override
    protected void process(String sentence) {
        this.alignment = new ArrayList<Pair<Integer, Integer>>();
        Pattern p = Pattern.compile(" \\|(\\d+)-(\\d+)\\| ");
        Matcher m = p.matcher(sentence);
        int last = 0;
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            int startSourceToken = Integer.parseInt(m.group(1));
            int endSourceToken = Integer.parseInt(m.group(2));
            String text = sentence.substring(last, start);
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(text);
            int count = Strings.count(text, ' ') + 1;
            int k = 0;
            while (k < count) {
                this.alignment.add(new Pair<Integer, Integer>(startSourceToken, endSourceToken));
                ++k;
            }
            last = end;
        }
        if (last < sentence.length()) {
            sb.append(sentence.substring(last));
        }
        this.sentence = sb.toString().split(" ");
    }

    @Override
    public String getTranslationPhrase(int index) throws UnsupportedOperationException {
        return this.sentence[index];
    }

    @Override
    public int getNumberOfTranslationPhrases() throws UnsupportedOperationException {
        return this.sentence.length;
    }

    @Override
    public String getTranslationPhrase(int start, int end) throws UnsupportedOperationException {
        int k = 0;
        StringBuffer sb = new StringBuffer();
        for (Pair<Integer, Integer> pair : this.alignment) {
            if (pair.getFirst() >= start && pair.getSecond() <= end) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(this.sentence[k]);
            }
            ++k;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            System.out.println(new MosesTranslation("a |2-2| b |3-3| c d e f |4-7| ").getTranslationPhrase(2, 3));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

