/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.mt.google;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.mt.Sentence;
import it.uniroma1.lcl.jlt.mt.Translation;
import it.uniroma1.lcl.jlt.mt.Translator;
import it.uniroma1.lcl.jlt.mt.UnsupportedLanguageException;
import it.uniroma1.lcl.jlt.mt.google.GoogleAJAXTranslator;
import it.uniroma1.lcl.jlt.mt.google.GoogleAPITranslator;
import it.uniroma1.lcl.jlt.util.Language;
import it.uniroma1.lcl.jlt.util.ScoredItem;
import it.uniroma1.lcl.jlt.util.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GoogleTranslator
extends Translator {
    protected static final Log log = LogFactory.getLog(GoogleTranslator.class);
    private final Translator translatorImpl;
    private static GoogleTranslator instance;

    private GoogleTranslator() {
        Configuration configuration = Configuration.getInstance();
        String googleUser = configuration.getGoogleTranslateAPIUSer();
        String googlePasswd = configuration.getGoogleTranslateAPIPassword();
        String googleApp = configuration.getGoogleTranslateAPIApplicationName();
        this.translatorImpl = googleUser == null || googlePasswd == null || googleApp == null || googleUser.isEmpty() || googlePasswd.isEmpty() || googleApp.isEmpty() ? new GoogleAJAXTranslator() : new GoogleAPITranslator(googleUser, googlePasswd, googleApp);
        log.info((Object)("USING " + this.translatorImpl.getClass().getSimpleName()));
    }

    public static synchronized GoogleTranslator getInstance() {
        if (instance == null) {
            instance = new GoogleTranslator();
        }
        return instance;
    }

    @Override
    public List<Translation> translate(Collection<Sentence> sourceSentences, Language targetLang) throws UnsupportedLanguageException {
        return this.translatorImpl.translate(sourceSentences, targetLang);
    }

    @Override
    public void store(Collection<Sentence> sourceSentences, List<Translation> translations) {
        this.translatorImpl.store(sourceSentences, translations);
    }

    @Override
    public List<ScoredItem<String>> getScoredTranslations(String title) {
        return this.translatorImpl.getScoredTranslations(title);
    }

    @Override
    public Set<String> getTitles() {
        return this.translatorImpl.getTitles();
    }

    @Override
    public String translate(String input, Language source, Language target) {
        return this.translatorImpl.translate(input, source, target);
    }

    @Override
    public void resetTranslationMemory() {
        this.translatorImpl.resetTranslationMemory();
    }

    public Translator getTranslatorImpl() {
        return this.translatorImpl;
    }

    public static void main(String[] args) throws Exception {
        Timer timer = new Timer();
        ArrayList<Sentence> sentences = new ArrayList<Sentence>();
        sentences.add(new Sentence("<s>A <t sense=\"Bus_driver\">bus driver</t> or omnibus driver is a person who drives buses as their profession.</s>"));
        sentences.add(new Sentence("<s>One of the most common jobs in the United States for a <t sense=\"Bus_driver\">bus driver</t> is to work for a public school , transporting students aboard a school bus to and from the school building .</s>"));
        sentences.add(new Sentence("<s>In the United States , finding a position as a <t sense=\"Bus_driver\">bus driver</t> usually requires that the individual possess a commercial driver's license ( CDL ) and specialized training for the vehicle .</s>"));
        sentences.add(new Sentence("<s>A <t sense=\"Bus_driver\">bus driver</t> also needs to possess social skills for interacting with their passengers, which is a daily occurrence.</s>"));
        GoogleTranslator translator = GoogleTranslator.getInstance();
        ((Translator)translator).translate(sentences, Language.ZH);
        log.info((Object)("TRANSLATIONS FOR BUS DRIVER:" + ((Translator)translator).getScoredTranslations("Bus_driver")));
        System.out.println("==============================");
        sentences.clear();
        ((Translator)translator).resetTranslationMemory();
        sentences.add(new Sentence("<s>In mathematics, <t sense=\"Connectedness\">connectedness</t> is used to refer to various properties meaning, in some sense, all one piece.</s>"));
        sentences.add(new Sentence("<s>Sometimes it is convenient to restate the definition of <t sense=\"Connectedness\">connectedness</t> in such fields.</s>"));
        sentences.add(new Sentence("<s>Graph theory also offers a context-free measure of <t sense=\"Connectedness\">connectedness</t>, called the clustering coefficient.</s>"));
        ((Translator)translator).translate(sentences, Language.ZH);
        log.info((Object)("TRANSLATIONS FOR CONNECTEDNESS:" + ((Translator)translator).getScoredTranslations("Connectedness")));
        System.out.println("==============================");
        sentences.clear();
        ((Translator)translator).resetTranslationMemory();
        sentences.add(new Sentence("<s>Thermoacidophile : Combination of <t sense=\"Thermophile\">thermophile</t> and <t sense=\"Acidophile (organisms)\">acidophile</t> that prefer temperatures of 70\u201380 \u00b0C and pH between 2 and 3</s>"));
        ((Translator)translator).translate(sentences, Language.ZH);
        log.info((Object)("TRANSLATIONS FOR ACIDOPHILE:" + ((Translator)translator).getScoredTranslations("Acidophile (organisms)")));
        System.out.println("==============================");
        sentences.clear();
        ((Translator)translator).resetTranslationMemory();
        sentences.add(new Sentence("<s>This probability distribution combines <t sense=\"A priori (statistics)\">a priori</t> information with new information obtained by measuring some observable parameters .</s>"));
        sentences.add(new Sentence("<s>In Bayesian inference , a prior probability distribution , often called simply the prior , is a probability distribution representing knowledge or belief about an unknown quantity <t sense=\"A priori (statistics)\">a priori</t> , that is , before any data have been observed P .</s>"));
        sentences.add(new Sentence("<s>Statistically we might assume that <t sense=\"A priori (statistics)\">a priori</t> we know that x is a random variable with a multivariate normal distribution .</s>"));
        sentences.add(new Sentence("<s>SOVA differs from the classical Viterbi algorithm in that it uses a modified path metric which takes into account the <t sense=\"A priori (statistics)\">a priori</t> probabilities of the input symbols , and produces a soft output indicating the reliability of the decision .</s>"));
        sentences.add(new Sentence("<s>Post-hoc analysis , in the context of design and analysis of experiments , refers to looking at the data\u2014after the experiment has concluded\u2014for patterns that were not specified <t sense=\"A priori (statistics)\">a priori</t> .</s>"));
        sentences.add(new Sentence("<s>The <t sense=\"A priori (statistics)\">a priori</t> probabilities that a given hand contains no more than a specified number of high card points is given in below table .</s>"));
        sentences.add(new Sentence("<s>First , the car can be behind any door , and all doors are <t sense=\"A priori (statistics)\">a priori</t> equally likely to hide the car .</s>"));
        sentences.add(new Sentence("<s>This classification is based on whether there is an <t sense=\"A priori (statistics)\">a priori</t> model and , if so , how it is used .</s>"));
        sentences.add(new Sentence("<s>Moreover , such event logs can also be used to compare event logs with some <t sense=\"A priori (statistics)\">a priori</t> model to see whether the observed reality conforms to some prescriptive or descriptive model .</s>"));
        ((Translator)translator).translate(sentences, Language.ZH);
        log.info((Object)("TRANSLATIONS FOR A PRIORI:" + ((Translator)translator).getScoredTranslations("A priori (statistics)")));
        sentences.clear();
        ((Translator)translator).resetTranslationMemory();
        sentences.add(new Sentence("<s>Hoijer 's Athabascan and my Yokuts share 71 identical meanings ( with allowance for several near synonyms like stomach <t sense=\"abdomen%1:08:00::\">abdomen</t> , big large , long far , many much , die dead , say speak ) .</s>"));
        sentences.add(new Sentence("<s>He rocked back in the chair , knee locked against <t sense=\"abdomen%1:08:00::\">abdomen</t> , his beady eyes fixed on Matson .</s>"));
        sentences.add(new Sentence("<s>He went prone on his <t sense=\"abdomen%1:08:00::\">abdomen</t> , the better to pursue his examination .</s>"));
        sentences.add(new Sentence("<s>She made General Burnside 's horse 's <t sense=\"abdomen%1:08:00::\">abdomen</t> do so funny when it was upside down .</s>"));
        sentences.add(new Sentence("<s>Isaac Pitt , one of the men from Lincoln , had taken a musket ball in his <t sense=\"abdomen%1:08:00::\">abdomen</t> ; and though he had found the strength to run with us , now he collapsed and lay on the ground , dying , the Reverend holding his head and wiping his hot brow .</s>"));
        sentences.add(new Sentence("<s>his quill drawings had a scratchiness , suggesting skin texture ; the clay he used plastically to suggest soft moving flesh , as in an <t sense=\"abdomen%1:08:00::\">abdomen</t> , in a reclining torso ; the wax he smoothed over to give the body surface an elastic pull .</s>"));
        sentences.add(new Sentence("<s>That 's why I only put towels on his chest and <t sense=\"abdomen%1:08:00::\">abdomen</t> .</s>"));
        sentences.add(new Sentence("<s>They 'd cut their mothers ' <t sense=\"abdomen%1:08:00::\">abdomen</t> open .</s>"));
        sentences.add(new Sentence("<s>His head undulated gradually , covering space , to come straining beneath the taut <t sense=\"abdomen%1:08:00::\">abdomen</t> within the warmth of those teats .</s>"));
        sentences.add(new Sentence("<s>He stepped inside Jess 's guard and landed two blows to the big man 's <t sense=\"abdomen%1:08:00::\">abdomen</t> , putting everything he had behind them .</s>"));
        ((Translator)translator).translate(sentences, Language.ZH);
        log.info((Object)("TRANSLATIONS FOR abdomen%1:08:00:::" + ((Translator)translator).getScoredTranslations("abdomen%1:08:00::")));
        sentences.clear();
        ((Translator)translator).resetTranslationMemory();
        sentences.add(new Sentence("<s>Besides , Miss Henrietta - as she was generally known since she had put up her hair with a chignon in the back - had little time to spare them from her teaching and writing ; so Cyrus Adler became interested in her friend Racie Friedenwald , and Joe Jastrow - the only <t sense=\"young_man%1:18:00::\">young_man</t> who when he wrote had the temerity to address her as Henrietta , and signed himself Joe - fell in love with pretty sister Rachel .</s>"));
        sentences.add(new Sentence("<s>The more I probed into this <t sense=\"young_man%1:18:00::\">young_man</t> 's activities and character , the less savory I found him .</s>"));
        sentences.add(new Sentence("<s>The letters took their source from a stream of my imagination in which I was transformed into a <t sense=\"young_man%1:18:00::\">young_man</t> not unlike my bunkmate Eliot Sands - he of the porch steps anecdotes - who smoked cigarettes , performed the tango , wore fifty dollar suits , and sneaked off into the dark with girls to do unimaginable things with them .</s>"));
        sentences.add(new Sentence("<s>The angriest <t sense=\"young_man%1:18:00::\">young_man</t> in Newport last night was at the Playhouse , where \" Epitaph for George Dillon \" opened as the jazz festival closed .</s>"));
        sentences.add(new Sentence("<s>\" Husky <t sense=\"young_man%1:18:00::\">young_man</t> \" , he said with mock distaste .</s>"));
        sentences.add(new Sentence("<s>The <t sense=\"young_man%1:18:00::\">young_man</t> spoke steadily enough , but all at once he looked grotesquely unshaven .</s>"));
        sentences.add(new Sentence("<s>The Szolds , like the Marches , enjoyed and loved living together , even in troubled times ; and , as in the March home , any <t sense=\"young_man%1:18:00::\">young_man</t> who called on the Szolds found himself confronted with a phalanx of femininity which made it rather difficult to direct his particular attention to any one of them .</s>"));
        sentences.add(new Sentence("<s>One thing Papa had not taught Henrietta was how to handle a <t sense=\"young_man%1:18:00::\">young_man</t> as high-spirited and opinionated as herself .</s>"));
        sentences.add(new Sentence("<s>That other Jew , a <t sense=\"young_man%1:18:00::\">young_man</t> too , had left that greatcoat behind , in a rich house , and marched away .</s>"));
        ((Translator)translator).translate(sentences, Language.ZH);
        log.info((Object)("TRANSLATIONS FOR young_man%1:18:00::" + ((Translator)translator).getScoredTranslations("young_man%1:18:00::")));
        System.out.println("==============================");
        System.out.println("==============================");
        log.info((Object)("MONO TRANSLATION FOR PLANT LIFE: " + translator.translate("plant life", Language.IT)));
        timer.tick("TO TRANSLATE");
    }

    public static class EmptyTranslationException
    extends RuntimeException {
        private static final long serialVersionUID = 5240320851245419857L;
    }

    public static class MaxLengthException
    extends RuntimeException {
        private static final long serialVersionUID = 5240720853145419857L;
    }
}

