/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.mt.google;

import it.uniroma1.lcl.jlt.mt.Translation;
import it.uniroma1.lcl.jlt.util.Strings;
import it.uniroma1.lcl.jlt.util.Tag;
import it.uniroma1.lcl.jlt.util.TagParser;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GoogleTranslation
extends Translation {
    protected static final Log log = LogFactory.getLog(GoogleTranslation.class);
    protected List<String> phrases;

    public GoogleTranslation(String sentence) {
        super(sentence);
    }

    @Override
    protected void process(String sentence) {
        this.phrases = new ArrayList<String>();
        for (Tag t : TagParser.parse(sentence)) {
            this.phrases.add(t.getText());
        }
        this.sentence = sentence.split(" ");
    }

    @Override
    public String getTranslationPhrase(int start, int end) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getTranslationPhrase(int index) throws UnsupportedOperationException {
        try {
            return this.phrases.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            log.warn((Object)("PROBLEM IN: " + Strings.join(this.sentence, " ") + " AT POSITION: " + index));
            return null;
        }
    }

    @Override
    public int getNumberOfTranslationPhrases() throws UnsupportedOperationException {
        return this.phrases.size();
    }

    public static void main(String[] args) {
        try {
            GoogleTranslation translation = new GoogleTranslation("<s>This is a <b sense=\"pippo\">beautiful thing</b> in <b>Italy</b></s>");
            System.out.println(((Translation)translation).getTranslationPhrase(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

