/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.mt.google;

import com.google.common.collect.TreeMultimap;
import com.google.gdata.client.Query;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;
import com.google.translate.gdata.data.TranslateEntry;
import com.google.translate.gdata.data.TranslateFeed;
import com.google.translate.gdata.data.TranslateQuery;
import com.google.translate.gdata.data.TranslateService;
import com.google.translate.gdata.data.TranslationAlignment;
import it.uniroma1.lcl.jlt.mt.Sentence;
import it.uniroma1.lcl.jlt.mt.Translation;
import it.uniroma1.lcl.jlt.mt.Translator;
import it.uniroma1.lcl.jlt.mt.UnsupportedLanguageException;
import it.uniroma1.lcl.jlt.mt.google.GoogleTranslation;
import it.uniroma1.lcl.jlt.mt.google.GoogleTranslator;
import it.uniroma1.lcl.jlt.util.IntegerCounter;
import it.uniroma1.lcl.jlt.util.Language;
import it.uniroma1.lcl.jlt.util.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GoogleAPITranslator
extends Translator {
    private static final boolean DEBUG = true;
    private static final Log log = LogFactory.getLog(GoogleAPITranslator.class);
    private final TranslateService service;

    GoogleAPITranslator(String user, String passwd, String applicationName) {
        this.service = new TranslateService(applicationName);
        try {
            this.service.setUserCredentials(user, passwd);
        }
        catch (AuthenticationException ae) {
            throw new RuntimeException("Cannot init: " + (Object)((Object)ae));
        }
    }

    @Override
    public List<Translation> translate(Collection<Sentence> sentences, Language targetLang) throws UnsupportedLanguageException {
        return this.translate(sentences, targetLang, false);
    }

    public List<Translation> translate(Collection<Sentence> sentences, Language targetLang, boolean batchTranslation) throws UnsupportedLanguageException {
        if (!(sentences instanceof Collection)) {
            log.warn((Object)"ERROR: needs sentences as a list, falling back to non-batch translation ...");
            return this.translateSingle(sentences, targetLang);
        }
        if (!batchTranslation) {
            return this.translateSingle(sentences, targetLang);
        }
        int batchIndex = 0;
        List sentenceList = (List)sentences;
        ArrayList<Translation> translations = new ArrayList<Translation>();
        try {
            int textLength = 0;
            ArrayList<Sentence> batch = new ArrayList<Sentence>();
            int i = 0;
            while (i < sentences.size()) {
                Sentence sentence = (Sentence)sentenceList.get(i);
                if (i == sentences.size() - 1) {
                    batch.add(sentence);
                    log.debug((Object)("FIRING FINAL BATCH " + batchIndex + " OF SIZE " + batch.size()));
                    translations.addAll(this.translateBatch(batch, targetLang));
                } else {
                    int sentenceLength = sentence.toString().length();
                    int newLength = textLength + sentenceLength;
                    if (newLength > 1024) {
                        log.debug((Object)("FIRING BATCH " + batchIndex + " OF SIZE " + batch.size()));
                        translations.addAll(this.translateBatch(batch, targetLang));
                        ++batchIndex;
                        batch.clear();
                        textLength = 0;
                    }
                    batch.add(sentence);
                    textLength = newLength;
                }
                ++i;
            }
            return translations;
        }
        catch (Exception e) {
            log.warn((Object)("EXCEPTION: " + e));
            log.warn((Object)"ERROR: falling back to non-batch translation ...");
            return this.translateSingle(sentences, targetLang);
        }
    }

    public List<Translation> translateBatch(List<Sentence> sentences, Language targetLanguage) throws UnsupportedLanguageException, IOException, ServiceException {
        ArrayList<Translation> translations = new ArrayList<Translation>();
        HashMap<Integer, Integer> sentenceIdx2startChar = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> sentenceIdx2startToken = new HashMap<Integer, Integer>();
        StringBuffer text = new StringBuffer();
        ArrayList<String> textTokens = new ArrayList<String>();
        int i = 0;
        while (i < sentences.size()) {
            Sentence sentence = sentences.get(i);
            String sentenceText = sentence.toString();
            sentenceIdx2startChar.put(i, text.length());
            sentenceIdx2startToken.put(i, textTokens.size());
            text.append(sentenceText).append(" ");
            String[] stringArray = sentenceText.split("\\s+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                textTokens.add(token);
                ++n2;
            }
            ++i;
        }
        if (text.length() > 0) {
            text.deleteCharAt(text.length() - 1);
        }
        TranslateQuery query = new TranslateQuery(text.toString(), Language.EN.toString().toLowerCase(), targetLanguage.toString().toLowerCase());
        query.setAlignmentRequest();
        TranslateFeed feed = (TranslateFeed)this.service.query((Query)query, TranslateFeed.class);
        if (feed.getEntries().size() > 0) {
            TranslateEntry entry = (TranslateEntry)feed.getEntries().get(0);
            StringBuffer sb = new StringBuffer();
            log.info((Object)("Text: " + text.toString()));
            log.info((Object)("Translated Text: " + entry.getText()));
            sb.append("Alignments: ");
            for (TranslationAlignment alignment : entry.getTranslationAlignments()) {
                sb.append(String.valueOf(alignment.getWord()) + " (" + alignment.getPosition() + ")  ");
            }
            log.info((Object)sb);
            log.info((Object)"=====");
            ArrayList<String> textDone = new ArrayList<String>();
            ArrayList<TranslationAlignment> alignmentsDone = new ArrayList<TranslationAlignment>();
            int i2 = 0;
            while (i2 < sentences.size()) {
                Sentence sentence = sentences.get(i2);
                int sentenceStartChar = (Integer)sentenceIdx2startChar.get(i2);
                int sentenceStartToken = (Integer)sentenceIdx2startToken.get(i2);
                String htmlSentence = this.sentenceToHTML(sentence, sentenceStartChar, sentenceStartToken, entry, targetLanguage, textDone, alignmentsDone);
                translations.add(new GoogleTranslation(htmlSentence));
                ++i2;
            }
        }
        this.store(sentences, translations);
        return translations;
    }

    public List<Translation> translateSingle(Collection<Sentence> sentences, Language targetLang) throws UnsupportedLanguageException {
        ArrayList<Translation> translations = new ArrayList<Translation>();
        for (Sentence sentence : sentences) {
            try {
                translations.add(this.translateSingle(sentence, targetLang));
            }
            catch (IOException ioe) {
                log.warn((Object)("Cannot translate: \"" + sentence + "\" " + ioe));
            }
            catch (ServiceException se) {
                log.warn((Object)("Cannot translate: \"" + sentence + "\" " + (Object)((Object)se)));
            }
        }
        this.store(sentences, translations);
        return translations;
    }

    public Translation translateSingle(Sentence sourceSentence, Language targetLanguage) throws IOException, ServiceException {
        TranslateQuery query = new TranslateQuery(sourceSentence.toString(), Language.EN.toString().toLowerCase(), targetLanguage.toString().toLowerCase());
        query.setAlignmentRequest();
        TranslateFeed feed = (TranslateFeed)this.service.query((Query)query, TranslateFeed.class);
        if (feed.getEntries().size() > 0) {
            TranslateEntry entry = (TranslateEntry)feed.getEntries().get(0);
            StringBuffer sb = new StringBuffer();
            log.info((Object)("Text: " + sourceSentence.toString()));
            log.info((Object)("Tagged: " + sourceSentence.toTaggedString()));
            log.info((Object)("Translated Text: " + entry.getText()));
            sb.append("Alignments: ");
            for (TranslationAlignment alignment : entry.getTranslationAlignments()) {
                sb.append(String.valueOf(alignment.getWord()) + " (" + alignment.getPosition() + ")  ");
            }
            log.info((Object)sb);
            String htmlSentence = this.sentenceToHTML(sourceSentence, entry, targetLanguage);
            log.info((Object)"=====");
            return new GoogleTranslation(htmlSentence);
        }
        return null;
    }

    private String sentenceToHTML(Sentence sourceSentence, TranslateEntry entry, Language targetLanguage) {
        return this.sentenceToHTML(sourceSentence, 0, 0, entry, targetLanguage, new ArrayList<String>(), new ArrayList<TranslationAlignment>());
    }

    private String sentenceToHTML(Sentence sourceSentence, int sentenceStartChar, int sentenceStartToken, TranslateEntry entry, Language targetLanguage, List<String> textDone, List<TranslationAlignment> alignmentsDone) {
        ArrayList<String> sentenceDone = new ArrayList<String>();
        List alignments = entry.getTranslationAlignments();
        TreeMultimap senseTag2tokens = new TreeMultimap();
        Map<Integer, Integer> char2token = this.charIndex2tokenIndex(sourceSentence.toString());
        int lastChar = new TreeSet<Integer>(char2token.keySet()).last();
        String previousToken = "";
        ArrayList<String> translatedSentence = new ArrayList<String>();
        for (TranslationAlignment alignment : alignments) {
            String currentToken = alignment.getWord();
            if (currentToken.equals(previousToken)) continue;
            translatedSentence.add(currentToken);
            previousToken = currentToken;
        }
        int j = alignmentsDone.size();
        int i = textDone.size();
        block4: while (i < translatedSentence.size()) {
            String translatedToken = (String)translatedSentence.get(i);
            while (j < alignments.size()) {
                TranslationAlignment alignment = (TranslationAlignment)alignments.get(j);
                String alignmentToken = alignment.getWord();
                if (!alignmentToken.equals(translatedToken)) break;
                int startChar = alignment.getPosition() - sentenceStartChar;
                if (startChar > lastChar) break block4;
                if (!char2token.containsKey(startChar)) {
                    alignmentsDone.add(alignment);
                } else {
                    int tokenPos = char2token.get(startChar);
                    for (Sentence.SenseAnnotation sAnnotation : sourceSentence.getSenseAnnotations()) {
                        int annotationStart = sAnnotation.getStartToken();
                        int annotationEnd = sAnnotation.getEndToken();
                        if (tokenPos < annotationStart || tokenPos > annotationEnd) continue;
                        String title = sAnnotation.getTitle();
                        senseTag2tokens.put((Object)title, (Object)(i - textDone.size()));
                    }
                    alignmentsDone.add(alignment);
                }
                ++j;
            }
            sentenceDone.add(translatedToken);
            ++i;
        }
        textDone.addAll(sentenceDone);
        TreeMultimap start2senseTag = new TreeMultimap();
        IntegerCounter<Integer> ends = new IntegerCounter<Integer>();
        log.info((Object)("senseTag2tokens=" + senseTag2tokens.toString()));
        for (String senseTag : senseTag2tokens.keySet()) {
            SortedSet tokens = senseTag2tokens.get((Object)senseTag);
            start2senseTag.put((Object)((Integer)tokens.first()), (Object)senseTag);
            ends.count((Integer)tokens.last());
        }
        log.info((Object)("start2senseTag=" + start2senseTag.toString()));
        log.info((Object)ends.toString());
        boolean addWhiteSpaces = true;
        switch (targetLanguage) {
            case JA: 
            case ZH: {
                addWhiteSpaces = false;
                break;
            }
        }
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < sentenceDone.size()) {
            if (start2senseTag.containsKey((Object)i2)) {
                for (String senseTag : start2senseTag.get((Object)i2)) {
                    sb.append("<b sense=\"").append(senseTag).append("\">");
                }
            }
            sb.append((String)sentenceDone.get(i2));
            int k = 0;
            while (k < (Integer)ends.get(i2)) {
                sb.append("</b>");
                ++k;
            }
            if (addWhiteSpaces) {
                sb.append(" ");
            }
            ++i2;
        }
        if (sb.length() > 0 && addWhiteSpaces) {
            sb.deleteCharAt(sb.length() - 1);
        }
        log.info((Object)("HTML: " + sb));
        return sb.toString();
    }

    public Map<Integer, Integer> charIndex2tokenIndex(String text) {
        TreeMap<Integer, Integer> indexMap = new TreeMap<Integer, Integer>();
        int tokens = 0;
        char[] chars = text.toCharArray();
        boolean inBoundary = false;
        int i = 0;
        while (i < chars.length) {
            char c;
            if (i == 0) {
                indexMap.put(i, tokens);
            }
            if ((c = chars[i]) == ' ') {
                inBoundary = true;
            } else if (inBoundary) {
                indexMap.put(i, ++tokens);
                inBoundary = false;
            }
            ++i;
        }
        return indexMap;
    }

    @Override
    public String translate(String input, Language sourceLang, Language targetLang) {
        try {
            TranslateQuery query = new TranslateQuery(input, sourceLang.toString().toLowerCase(), targetLang.toString().toLowerCase());
            TranslateFeed feed = (TranslateFeed)this.service.query((Query)query, TranslateFeed.class);
            if (feed.getEntries().size() > 0) {
                TranslateEntry entry = (TranslateEntry)feed.getEntries().get(0);
                return entry.getText();
            }
        }
        catch (IOException ioe) {
            log.warn((Object)("CANNOT TRANSLATE: " + input + " EXCEPTION: " + ioe));
        }
        catch (ServiceException se) {
            if (se.getResponseBody().contains("Translated text matches original text.")) {
                return input;
            }
            log.warn((Object)("CANNOT TRANSLATE: " + input + " EXCEPTION: " + (Object)((Object)se)));
        }
        return null;
    }

    @Override
    public void store(Collection<Sentence> sourceSentences, List<Translation> translations) {
        Iterator<Sentence> i = sourceSentences.iterator();
        for (Translation t : translations) {
            Sentence source = i.next();
            List<Sentence.SenseAnnotation> senseAnnotations = source.getSenseAnnotations();
            int k = 0;
            for (Sentence.SenseAnnotation a : senseAnnotations) {
                String translationPhrase = t.getTranslationPhrase(k);
                if (translationPhrase != null) {
                    translationPhrase = translationPhrase.toLowerCase();
                    this.translationMemory.count(a.getTitle(), translationPhrase);
                }
                ++k;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        GoogleTranslator translator = GoogleTranslator.getInstance();
        System.out.println(translator.getTranslatorImpl().getClass());
        Sentence s = new Sentence("<t sense=\"RGET\">An apple</t> <t sense=\"VERB\">is a kind of</t> <t sense=\"GENUS\">coloured <t sense=\"HYPER\">fruit</t> </t> <t sense=\"REST\">whose colour is typically red, yellow or green.</t>");
        Sentence s2 = new Sentence("<t sense=\"SENT\"><t sense=\"a\">An <t sense=\"b\">apple</t> is <t sense=\"c\">a</t> kind of </t> <t sense=\"d\"> fruit</t></t>");
        Sentence s3 = new Sentence("<t sense=\"b\">The <t sense=\"tt\">AK-47</t> ( )</t> <t sense=\"i\">is</t> <t sense=\"em\">a 7.62 mm assault <t sense=\"u\">rifle</t></t> developed in the Soviet Union by Mikhail Kalashnikov in two versions : the fixed stock <t sense=\"TARGET\">target</t> and the AKS-47 ( ) variant equipped with an underfolding metal shoulder stock .");
        Sentence s4 = new Sentence("<b><tt>Giga-</tt> ( )</b> <i>is</i> <em>a <u>prefix</u></em> in the SI system of units denoting 10 < ; 9 < ; , or 1,000,000,000 ( ) .".replaceAll("<([^/> ][^/>]*)>", "<t sense=\"$1\">").replaceAll("</([^> ][^>]*)>", "</t>").replaceAll("<t sense=\"TARGET\">", "<t sense=\"TARGET\">target</t>"));
        List<Sentence> sentences = Arrays.asList(s, s2, s3, s4);
        for (Sentence sentence : sentences) {
            System.out.println("SENTENCE: " + sentence);
            for (Translation t : translator.translate(Sets.varargsToHashSet(s4), Language.FR)) {
                System.out.println("TRANSLATION: " + t.toString());
            }
            System.out.println("---------------");
        }
    }
}

