/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.mt.google;

import com.google.api.translate.Translate;
import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.mt.Sentence;
import it.uniroma1.lcl.jlt.mt.Translation;
import it.uniroma1.lcl.jlt.mt.Translator;
import it.uniroma1.lcl.jlt.mt.UnsupportedLanguageException;
import it.uniroma1.lcl.jlt.mt.google.GoogleLanguage;
import it.uniroma1.lcl.jlt.mt.google.GoogleTranslation;
import it.uniroma1.lcl.jlt.mt.google.GoogleTranslator;
import it.uniroma1.lcl.jlt.util.Language;
import it.uniroma1.lcl.jlt.web.Proxy;
import it.uniroma1.lcl.jlt.web.ProxyList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GoogleAJAXTranslator
extends Translator {
    private static final Log log = LogFactory.getLog(GoogleAJAXTranslator.class);
    private static final String LENGTH_ERROR = "[400] the string to be translated exceeds the maximum length allowed";
    private static int MAX_ATTEMPTS = 5;

    GoogleAJAXTranslator() {
        Translate.setHttpReferrer((String)Configuration.getInstance().getGoogleRequester());
    }

    @Override
    public List<Translation> translate(Collection<Sentence> sentences, Language targetLang) throws UnsupportedLanguageException {
        try {
            return this.translateBatch(sentences, targetLang);
        }
        catch (GoogleTranslator.MaxLengthException e) {
            log.warn((Object)"MAX LENGTH ERROR: falling back to non-batch translation ...");
            return this.translateSingle(sentences, targetLang);
        }
        catch (GoogleTranslator.EmptyTranslationException e) {
            log.warn((Object)"EMPTY TRANSLATION: falling back to non-batch translation ...");
            return this.translateSingle(sentences, targetLang);
        }
    }

    public List<Translation> translateBatch(Collection<Sentence> sentences, Language targetLang) throws UnsupportedLanguageException, GoogleTranslator.MaxLengthException, GoogleTranslator.EmptyTranslationException {
        StringBuffer buffer = new StringBuffer();
        ArrayList<Translation> translations = new ArrayList<Translation>();
        int counter = 0;
        for (Sentence sentence : sentences) {
            String taggedSentence = sentence.toTaggedString().replaceAll("</?s>", "").replaceAll("<t ", "<b ").replaceAll("</t>", "</b>");
            buffer.append(taggedSentence);
            if (counter < sentences.size() - 1) {
                buffer.append("<br>");
            }
            ++counter;
        }
        String gTranslations = this.translate(buffer.toString(), targetLang);
        if (gTranslations == null) {
            throw new GoogleTranslator.EmptyTranslationException();
        }
        String[] stringArray = gTranslations.split("<br>");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String gTranslation = stringArray[n2];
            if ((gTranslation = gTranslation.trim()) != null) {
                translations.add(new GoogleTranslation(gTranslation));
            }
            this.store(sentences, translations);
            ++n2;
        }
        return translations;
    }

    public List<Translation> translateSingle(Collection<Sentence> sentences, Language targetLang) throws UnsupportedLanguageException {
        ArrayList<Translation> translations = new ArrayList<Translation>();
        for (Sentence sentence : sentences) {
            String taggedSentence = sentence.toTaggedString().replaceAll("</?s>", "").replaceAll("<t ", "<b ").replaceAll("</t>", "</b>");
            String translation = this.translate(taggedSentence, targetLang);
            if (translation == null) continue;
            translations.add(new GoogleTranslation(translation));
        }
        this.store(sentences, translations);
        return translations;
    }

    @Override
    public String translate(String input, Language source, Language target) {
        int attempts = 0;
        String translation = null;
        GoogleLanguage googleSource = GoogleLanguage.valueOf(source.toString());
        GoogleLanguage googleTarget = GoogleLanguage.valueOf(target.toString());
        do {
            Proxy proxy = null;
            if (Configuration.getInstance().useProxy()) {
                proxy = ProxyList.getInstance().getNextRandomProxy();
                System.setProperty("http.proxyHost", proxy.getHost());
                System.setProperty("http.proxyPort", "" + proxy.getPort());
                Translate.setHttpReferrer((String)proxy.getHost());
            }
            try {
                translation = GoogleAJAXTranslator.getTranslation(input, googleSource, googleTarget);
            }
            catch (Exception e) {
                String msg = e.getMessage();
                if (msg != null && msg.contains(LENGTH_ERROR)) {
                    throw new GoogleTranslator.MaxLengthException();
                }
                log.warn((Object)("Could not translate \"" + input + "\" exception: " + e));
                if (proxy == null) continue;
                log.warn((Object)("EXCEPTION:" + e));
                log.warn((Object)("BAD PROXY? = " + proxy.toString() + ", current size: " + ProxyList.getInstance().size()));
                log.warn((Object)("ATTEMPT: " + attempts));
                ProxyList.getInstance().remove(proxy);
                ++attempts;
            }
        } while (translation == null && attempts < MAX_ATTEMPTS);
        return translation;
    }

    private static String getTranslation(final String input, final GoogleLanguage src, final GoogleLanguage target) throws TimeoutException, InterruptedException, ExecutionException {
        FutureTask<String> translationTask = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Translate.execute((String)input, (com.google.api.translate.Language)src.getGoogleLanguage(), (com.google.api.translate.Language)target.getGoogleLanguage());
            }
        });
        new Thread(translationTask).start();
        return translationTask.get(10L, TimeUnit.SECONDS);
    }

    @Override
    public void store(Collection<Sentence> sourceSentences, List<Translation> translations) {
        Iterator<Sentence> i = sourceSentences.iterator();
        for (Translation t : translations) {
            Sentence source = i.next();
            List<Sentence.SenseAnnotation> senseAnnotations = source.getSenseAnnotations();
            int k = 0;
            for (Sentence.SenseAnnotation a : senseAnnotations) {
                String translationPhrase = t.getTranslationPhrase(k);
                if (translationPhrase != null) {
                    translationPhrase = translationPhrase.toLowerCase();
                    this.translationMemory.count(a.getTitle(), translationPhrase);
                }
                ++k;
            }
        }
    }
}

