/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.mt.giza;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.mt.Alignment;
import it.uniroma1.lcl.jlt.mt.giza.GizaAlignment;
import it.uniroma1.lcl.jlt.mt.giza.GizaAlignmentRecord;
import it.uniroma1.lcl.jlt.mt.giza.GizaFormatException;
import it.uniroma1.lcl.jlt.util.Language;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class GizaAlignmentReader {
    private final String fileName;
    private final BufferedReader fileReader;

    public GizaAlignmentReader(String fileName) {
        this.fileName = fileName;
        try {
            this.fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
        }
        catch (IOException ioe) {
            throw new RuntimeException("Cannot init: " + ioe);
        }
    }

    public GizaAlignment getNextAlignment() throws IOException, GizaFormatException {
        GizaAlignmentRecord record = this.getNextAlignmentRedcord();
        return GizaAlignmentReader.parseRecord(record);
    }

    public GizaAlignmentRecord getNextAlignmentRedcord() throws IOException, GizaFormatException {
        String infoLine = this.fileReader.readLine();
        String targetLine = this.fileReader.readLine();
        String sourceLine = this.fileReader.readLine();
        return new GizaAlignmentRecord(infoLine, targetLine, sourceLine, this.fileName);
    }

    public boolean hasNext() {
        try {
            return this.fileReader.ready();
        }
        catch (IOException e) {
            return false;
        }
    }

    public void close() {
        try {
            this.fileReader.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public List<Alignment> getAllAlignments() throws IOException, GizaFormatException {
        ArrayList<Alignment> alignments = new ArrayList<Alignment>();
        while (this.hasNext()) {
            alignments.add(this.getNextAlignment());
        }
        return alignments;
    }

    public static List<GizaAlignment> readAlignments(String fileName) throws IOException, GizaFormatException {
        ArrayList<GizaAlignment> alignments = new ArrayList<GizaAlignment>();
        BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
        while (fileReader.ready()) {
            String infoLine = fileReader.readLine();
            String targetLine = fileReader.readLine();
            String sourceLine = fileReader.readLine();
            GizaAlignmentRecord record = new GizaAlignmentRecord(infoLine, targetLine, sourceLine, fileName);
            alignments.add(GizaAlignmentReader.parseRecord(record));
        }
        return alignments;
    }

    /*
     * Unable to fully structure code
     */
    public static GizaAlignment parseRecord(GizaAlignmentRecord record) throws GizaFormatException {
        fileName = record.getFilename();
        infoLine = record.getInfoLine();
        infoWords = infoLine.split("\\s+");
        if (infoWords.length != 14) {
            throw new GizaFormatException("Bad alignment file " + fileName + ": wrong number of words in input line. Bad line was " + infoWords);
        }
        if (!infoWords[0].equals("#")) {
            throw new GizaFormatException("Bad alignment file " + fileName + ": input line without initial #. Bad line was " + infoWords);
        }
        sentenceID = Integer.parseInt(infoWords[3].substring(1, infoWords[3].length() - 1));
        score = Double.parseDouble(infoWords[13]);
        targetLine = record.getTargetLine();
        targetInput = Arrays.asList(targetLine.split("\\s+"));
        sourceLine = record.getSourceLine();
        sourceInput = Arrays.asList(sourceLine.split("\\s+"));
        sourceWords = new ArrayList<String>();
        alignmentsFromTargetToSource = new int[targetInput.size() + 1];
        sourcePosition = 0;
        inputPosition = 0;
        while (inputPosition < sourceInput.size()) {
            block9: {
                if (sourcePosition == 0) ** GOTO lbl35
                sourceWords.add(sourceInput.get(inputPosition));
                if (!"({".equals(sourceInput.get(++inputPosition))) {
                    throw new GizaFormatException("Improperly formed source input string at sentence #" + sentenceID);
                }
                ++inputPosition;
                while (!"})".equals(sourceInput.get(inputPosition))) {
                    try {
                        target = Integer.parseInt(sourceInput.get(inputPosition));
                        alignmentsFromTargetToSource[target] = sourcePosition;
                        ++inputPosition;
                    }
                    catch (NumberFormatException nfe) {
                        throw new GizaFormatException("Improperly formed source input string at sentence #" + sentenceID);
                    }
                }
                break block9;
lbl-1000:
                // 1 sources

                {
                    ++inputPosition;
lbl35:
                    // 2 sources

                    ** while (!"})".equals((Object)sourceInput.get((int)inputPosition)))
                }
            }
            ++inputPosition;
            ++sourcePosition;
        }
        alignment = new GizaAlignment(sourceWords, targetInput, score, sentenceID, fileName);
        targetPosition = 1;
        while (targetPosition <= targetInput.size()) {
            alignment.addAlignment(alignmentsFromTargetToSource[targetPosition] - 1, targetPosition - 1);
            ++targetPosition;
        }
        return alignment;
    }

    public Iterator<Alignment> alignmentIterator() {
        return new GizaAlignmentIterator();
    }

    public Iterator<GizaAlignmentRecord> recordIterator() {
        return new GizaAlignmentRecordIterator();
    }

    public static void main(String[] args) {
        try {
            int max = 5;
            int counter = 0;
            String file = Configuration.getInstance().getEuroParlAlignmentFile(Language.EN, Language.DE);
            GizaAlignmentReader reader = new GizaAlignmentReader(file);
            while (reader.hasNext()) {
                GizaAlignment alignment = reader.getNextAlignment();
                alignment.writeGIZA();
                System.out.println();
                System.out.println(alignment);
                System.out.println("======");
                if (++counter > max) break;
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class GizaAlignmentIterator
    implements Iterator<Alignment> {
        @Override
        public boolean hasNext() {
            return GizaAlignmentReader.this.hasNext();
        }

        @Override
        public GizaAlignment next() {
            try {
                return GizaAlignmentReader.this.getNextAlignment();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (GizaFormatException e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove alignments from a reader!");
        }
    }

    public class GizaAlignmentRecordIterator
    implements Iterator<GizaAlignmentRecord> {
        @Override
        public boolean hasNext() {
            return GizaAlignmentReader.this.hasNext();
        }

        @Override
        public GizaAlignmentRecord next() {
            try {
                return GizaAlignmentReader.this.getNextAlignmentRedcord();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (GizaFormatException e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove alignments from a reader!");
        }
    }
}

