/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.mt;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.mt.Sentence;
import it.uniroma1.lcl.jlt.mt.Translation;
import it.uniroma1.lcl.jlt.mt.UnsupportedLanguageException;
import it.uniroma1.lcl.jlt.util.Language;
import it.uniroma1.lcl.jlt.util.MapCounter;
import it.uniroma1.lcl.jlt.util.ScoredItem;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public abstract class Translator {
    protected final MapCounter<String, String> translationMemory = new MapCounter();

    protected Translator() {
    }

    public abstract void store(Collection<Sentence> var1, List<Translation> var2);

    public abstract List<Translation> translate(Collection<Sentence> var1, Language var2) throws UnsupportedLanguageException;

    protected String writeSentenceFile(Collection<Sentence> sentences, Language targetLang) throws UnsupportedLanguageException, IOException {
        String tempFile = UUID.randomUUID().toString();
        String fullPath = String.valueOf(Configuration.getInstance().getMosesTempDir()) + "/" + tempFile;
        BufferedWriter bw = new BufferedWriter(new FileWriter(fullPath));
        for (Sentence sentence : sentences) {
            bw.write(String.valueOf(sentence.toString().toLowerCase()) + "\n");
        }
        bw.flush();
        bw.close();
        String iniFile = Configuration.getInstance().getMosesIniFile(targetLang);
        if (iniFile == null || !new File(iniFile).exists()) {
            new File(fullPath).delete();
            throw new UnsupportedLanguageException();
        }
        return fullPath;
    }

    public Set<String> getTitles() {
        return this.translationMemory.keySet();
    }

    public List<ScoredItem<String>> getScoredTranslations(String title) {
        return this.translationMemory.getValuesSortedByCount(title);
    }

    public String translate(String input, Language targetLang) {
        return this.translate(input, Language.EN, targetLang);
    }

    public abstract String translate(String var1, Language var2, Language var3);

    public void resetTranslationMemory() {
        this.translationMemory.resetCounts();
    }
}

