/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.mt;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import it.uniroma1.lcl.jlt.util.Language;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class TranslationCleaner {
    private final Multimap<Language, String> starts;
    private final Multimap<Language, String> ends;
    private final Set<Language> done = new HashSet<Language>();
    private static TranslationCleaner instance = null;

    private TranslationCleaner() {
        this.starts = new HashMultimap();
        this.ends = new HashMultimap();
    }

    public static synchronized TranslationCleaner getInstance() {
        if (instance == null) {
            instance = new TranslationCleaner();
        }
        return instance;
    }

    public String clean(String translation, Language lang) {
        if (!this.done.contains((Object)lang)) {
            String[] illegals = null;
            switch (lang) {
                case EN: {
                    illegals = new String[]{"the", "a", "of the"};
                    break;
                }
                case IT: {
                    illegals = new String[]{"o", "e", "in", "nel", "il", "la", "l'", "lo", "i", "gli", "le", "un", "un'", "una", "uno", "del", "d'", "di", "dal", "dalla", "dalle", "della", "delle", "dell'", "dai", "dagli", "dall'", "dei", "sull'", "sulla", "sulle", "sugli", "nell'", "all'"};
                    break;
                }
                case FR: {
                    illegals = new String[]{"ou", "et", "dans", "\u00e0", "en", "le", "la", "l'", "les", "un", "une", "de", "d'", "du", "de la", "des", "de l'", "sur"};
                    break;
                }
                case DE: {
                    illegals = new String[]{"oder", "und", "in", "die", "das", "der", "den", "dem", "des", "ein", "eine", "einem", "einen", "einer", "eines"};
                    break;
                }
                case ES: {
                    illegals = new String[]{"o", "y", "a", "en", "el", "l'", "la", "los", "las", "un", "un'", "una", "unos", "unas", "de", "del", "de la", "de los", "de les", "de las", "de l'"};
                    break;
                }
                case CA: {
                    illegals = new String[]{"o", "i", "a", "en", "el", "els", "la", "los", "las", "les", "un", "un'", "una", "unos", "unas", "de", "del", "de la", "de los", "de les", "de las", "d'", "d'una", "l'"};
                    break;
                }
                case NL: {
                    illegals = new String[]{"het", "de", "van"};
                    break;
                }
                case RO: {
                    illegals = new String[]{"de"};
                    break;
                }
                default: {
                    illegals = new String[]{};
                }
            }
            String[] stringArray = illegals;
            int n = illegals.length;
            int n2 = 0;
            while (n2 < n) {
                String illegal = stringArray[n2];
                if (illegal.charAt(illegal.length() - 1) == '\'') {
                    this.starts.put((Object)lang, (Object)illegal);
                } else {
                    this.starts.put((Object)lang, (Object)(String.valueOf(illegal) + " "));
                    this.starts.put((Object)lang, (Object)(String.valueOf(illegal) + ","));
                }
                this.ends.put((Object)lang, (Object)(" " + illegal));
                ++n2;
            }
            this.done.add(lang);
        }
        Collection languageStarts = this.starts.get((Object)lang);
        Collection languageEnds = this.ends.get((Object)lang);
        String translationToMatch = translation;
        int spaceIdx = translation.indexOf(" ");
        if (spaceIdx == -1) {
            translationToMatch = String.valueOf(translationToMatch) + " ";
        }
        boolean bDone = false;
        block11: while (!bDone) {
            for (String start : languageStarts) {
                if (!translationToMatch.startsWith(start)) continue;
                translationToMatch = translationToMatch.substring(start.length()).trim();
                continue block11;
            }
            bDone = true;
        }
        bDone = false;
        block13: while (!bDone) {
            for (String end : languageEnds) {
                if (!translationToMatch.endsWith(end)) continue;
                translationToMatch = translationToMatch.substring(0, translationToMatch.length() - end.length()).trim();
                continue block13;
            }
            bDone = true;
        }
        return translationToMatch.trim();
    }
}

