/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.mt;

import it.uniroma1.lcl.jlt.util.Collections;
import it.uniroma1.lcl.jlt.util.EnhancedTag;
import it.uniroma1.lcl.jlt.util.Strings;
import it.uniroma1.lcl.jlt.util.TagParser;
import java.util.ArrayList;
import java.util.List;

public class Sentence {
    private String taggedSentence = null;
    private String[] sentence = null;
    private List<SenseAnnotation> senseAnnotations = new ArrayList<SenseAnnotation>();

    public Sentence(String s) {
        this.taggedSentence = s;
        s = s.replaceAll("</?s>", "");
        s = s.replaceAll("_", " ");
        for (EnhancedTag t : TagParser.parseEnhanced(s)) {
            if (!t.getName().equals("t")) continue;
            this.senseAnnotations.add(new SenseAnnotation(t.getStartTokenPosition(), t.getStartCharPosition(), t.getEndTokenPosition(), t.getEndCharPosition(), Collections.getFirst(t.getAttributeValue("sense"))));
        }
        s = TagParser.removeAllTags(s);
        this.sentence = s.split(" ");
    }

    public String toString() {
        return Strings.join(this.sentence);
    }

    public String toTaggedString() {
        return this.taggedSentence;
    }

    public List<SenseAnnotation> getSenseAnnotations() {
        return this.senseAnnotations;
    }

    public class SenseAnnotation {
        private int startToken;
        private int startChar;
        private int endToken;
        private int endChar;
        private String title;

        public SenseAnnotation(int startToken, int startChar, int endToken, int endChar, String title) {
            this.startToken = startToken;
            this.startChar = startChar;
            this.endToken = endToken;
            this.endChar = endChar;
            this.title = title;
        }

        public int getStartToken() {
            return this.startToken;
        }

        public int getStartChar() {
            return this.startChar;
        }

        public int getEndToken() {
            return this.endToken;
        }

        public int getEndChar() {
            return this.endChar;
        }

        public String getTitle() {
            return this.title;
        }

        public String toString() {
            return "START:" + this.startToken + "/" + this.startChar + ";END:" + this.endToken + "/" + this.endChar + ";TITLE:" + this.title;
        }
    }
}

