/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.mt;

import it.uniroma1.lcl.jlt.util.Pair;
import it.uniroma1.lcl.jlt.util.Strings;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Alignment
implements Serializable {
    private static final long serialVersionUID = -7209153700666076228L;
    private final Set<Pair<Integer, Integer>> sureAlignments;
    private final Set<Pair<Integer, Integer>> possibleAlignments;
    List<List<Integer>> targetAlignments;
    List<List<Integer>> sourceAlignments;
    private final Map<Pair<Integer, Integer>, Double> strengths;
    private final List<String> sourceSentence;
    private final List<String> targetSentence;
    private final double score;

    public Alignment(List<String> sourceSentence, List<String> targetSentence) {
        this(sourceSentence, targetSentence, 0.0);
    }

    public Alignment(List<String> sourceSentence, List<String> targetSentence, double score) {
        this.sourceSentence = sourceSentence;
        this.targetSentence = targetSentence;
        this.score = score;
        this.sureAlignments = new HashSet<Pair<Integer, Integer>>();
        this.possibleAlignments = new HashSet<Pair<Integer, Integer>>();
        this.strengths = new HashMap<Pair<Integer, Integer>, Double>();
    }

    public Alignment(Alignment al) {
        this(al.sourceSentence, al.targetSentence, al.score);
    }

    public double getScore() {
        return this.score;
    }

    public int getSourceLength() {
        return this.sourceSentence.size();
    }

    public List<String> getSourceSentence() {
        return this.sourceSentence;
    }

    public int getTargetLength() {
        return this.targetSentence.size();
    }

    public List<String> getTargetSentence() {
        return this.targetSentence;
    }

    public Set<Pair<Integer, Integer>> getPossibleAlignments() {
        return this.possibleAlignments;
    }

    public Set<Pair<Integer, Integer>> getSureAlignments() {
        return this.sureAlignments;
    }

    public Map<Pair<Integer, Integer>, Double> getStrengths() {
        return this.strengths;
    }

    public boolean containsSureAlignment(int sourcePosition, int targetPosition) {
        return this.sureAlignments.contains(new Pair<Integer, Integer>(sourcePosition, targetPosition));
    }

    public boolean containsPossibleAlignment(int sourcePosition, int targetPosition) {
        return this.possibleAlignments.contains(new Pair<Integer, Integer>(sourcePosition, targetPosition));
    }

    public double getStrength(int i, int j) {
        Pair<Integer, Integer> key = new Pair<Integer, Integer>(i, j);
        return this.strengths == null || !this.strengths.containsKey(key) ? 0.0 : this.strengths.get(key);
    }

    public List<Integer> getAlignmentsOfSource(int sourcePos) {
        if (this.sourceAlignments == null) {
            this.gatherAlignmentArrays();
        }
        if (sourcePos >= 0 && sourcePos < this.sourceAlignments.size()) {
            return this.sourceAlignments.get(sourcePos);
        }
        return new ArrayList<Integer>();
    }

    public List<String> getWordAlignmentsOfSource(int sourcePos) {
        List<Integer> alignments = this.getAlignmentsOfSource(sourcePos);
        ArrayList<String> wordAlignments = new ArrayList<String>();
        for (Integer alignment : alignments) {
            wordAlignments.add(this.targetSentence.get(alignment));
        }
        return wordAlignments;
    }

    public List<Integer> getAlignmentsOfTarget(int targetPos) {
        if (this.targetAlignments == null) {
            this.gatherAlignmentArrays();
        }
        return this.targetAlignments.get(targetPos);
    }

    public List<String> getWordAlignmentsOfTarget(int targetPos) {
        List<Integer> alignments = this.getAlignmentsOfTarget(targetPos);
        ArrayList<String> wordAlignments = new ArrayList<String>();
        for (Integer alignment : alignments) {
            wordAlignments.add(this.sourceSentence.get(alignment));
        }
        return wordAlignments;
    }

    private void gatherAlignmentArrays() {
        this.targetAlignments = new ArrayList<List<Integer>>(this.targetSentence.size());
        int i = 0;
        while (i < this.targetSentence.size()) {
            this.targetAlignments.add(new ArrayList());
            ++i;
        }
        this.sourceAlignments = new ArrayList<List<Integer>>(this.sourceSentence.size());
        i = 0;
        while (i < this.sourceSentence.size()) {
            this.sourceAlignments.add(new ArrayList());
            ++i;
        }
        for (Pair<Integer, Integer> alignment : this.sureAlignments) {
            Integer sourcePos = alignment.getFirst();
            Integer targetPos = alignment.getSecond();
            if (sourcePos < 0 || targetPos < 0) continue;
            this.targetAlignments.get(targetPos).add(sourcePos);
            this.sourceAlignments.get(sourcePos).add(targetPos);
        }
    }

    public void addAlignment(int sourcePos, int targetPos, boolean sure) {
        Pair<Integer, Integer> alignment = new Pair<Integer, Integer>(sourcePos, targetPos);
        if (sure) {
            this.sureAlignments.add(alignment);
        }
        this.possibleAlignments.add(alignment);
        this.sourceAlignments = null;
        this.targetAlignments = null;
    }

    public void addAlignment(int sourceIndex, int targetIndex) {
        this.addAlignment(sourceIndex, targetIndex, true);
    }

    public void removeAlignment(int sourceIndex, int targetIndex) {
        Pair<Integer, Integer> remove = new Pair<Integer, Integer>(sourceIndex, targetIndex);
        if (this.sureAlignments.contains(remove)) {
            this.sureAlignments.remove(remove);
        }
        if (this.possibleAlignments.contains(remove)) {
            this.possibleAlignments.remove(remove);
        }
    }

    public void setStrength(int sourceIndex, int targetIndex, double strength) {
        this.strengths.put(new Pair<Integer, Integer>(sourceIndex, targetIndex), strength);
    }

    public Alignment thresholdAlignmentByStrength(double threshold) {
        Alignment newAlignment = new Alignment(this.sourceSentence, this.targetSentence);
        for (Pair<Integer, Integer> ij : this.strengths.keySet()) {
            int i = ij.getFirst();
            int j = ij.getSecond();
            double strength = this.strengths.get(ij);
            newAlignment.setStrength(i, j, strength);
            if (!(strength >= threshold)) continue;
            newAlignment.addAlignment(i, j, true);
        }
        return newAlignment;
    }

    public static Map<Integer, Alignment> thresholdAlignmentsByStrength(Map<Integer, Alignment> alignments, double threshold) {
        HashMap<Integer, Alignment> newAlignments = new HashMap<Integer, Alignment>();
        for (int id : alignments.keySet()) {
            Alignment alignment = alignments.get(id);
            alignment = alignment.thresholdAlignmentByStrength(threshold);
            newAlignments.put(id, alignment);
        }
        return newAlignments;
    }

    public Alignment intersect(Alignment a) {
        Alignment ia = new Alignment(this.sourceSentence, this.targetSentence);
        for (Pair<Integer, Integer> p : this.sureAlignments) {
            if (!a.sureAlignments.contains(p) && p.getFirst() < a.getSourceLength() && p.getSecond() < a.getTargetLength()) continue;
            ia.sureAlignments.add(p);
        }
        for (Pair<Integer, Integer> p : a.sureAlignments) {
            if (p.getFirst() < this.getSourceLength() && p.getSecond() < this.getTargetLength()) continue;
            ia.sureAlignments.add(p);
        }
        for (Pair<Integer, Integer> p : this.possibleAlignments) {
            if (!a.possibleAlignments.contains(p) && p.getFirst() < a.getSourceLength() && p.getSecond() < a.getTargetLength()) continue;
            ia.possibleAlignments.add(p);
        }
        for (Pair<Integer, Integer> p : a.possibleAlignments) {
            if (p.getFirst() < this.getSourceLength() && p.getSecond() < this.getTargetLength()) continue;
            ia.possibleAlignments.add(p);
        }
        return ia;
    }

    public Alignment subtract(Alignment a) {
        Alignment ia = new Alignment(this);
        for (Pair<Integer, Integer> p : this.sureAlignments) {
            if (a.sureAlignments.contains(p)) continue;
            ia.sureAlignments.add(p);
        }
        for (Pair<Integer, Integer> p : this.possibleAlignments) {
            if (a.possibleAlignments.contains(p)) continue;
            ia.possibleAlignments.add(p);
        }
        return ia;
    }

    public Alignment union(Alignment a) {
        Alignment ua = new Alignment(this.sourceSentence, this.targetSentence);
        for (Pair<Integer, Integer> p : this.sureAlignments) {
            ua.sureAlignments.add(p);
        }
        for (Pair<Integer, Integer> p : a.sureAlignments) {
            ua.sureAlignments.add(p);
        }
        for (Pair<Integer, Integer> p : this.possibleAlignments) {
            ua.possibleAlignments.add(p);
        }
        for (Pair<Integer, Integer> p : a.possibleAlignments) {
            ua.possibleAlignments.add(p);
        }
        return ua;
    }

    public Alignment reverse() {
        Alignment reverse = new Alignment(this.targetSentence, this.sourceSentence);
        for (Pair<Integer, Integer> p : this.sureAlignments) {
            reverse.sureAlignments.add(p.reverse());
        }
        for (Pair<Integer, Integer> p : this.possibleAlignments) {
            reverse.possibleAlignments.add(p.reverse());
        }
        if (this.strengths != null) {
            for (Pair<Integer, Integer> p : this.strengths.keySet()) {
                reverse.setStrength(p.getFirst(), p.getSecond(), this.strengths.get(p));
            }
        }
        return reverse;
    }

    public String toString() {
        return Alignment.toString(this, this);
    }

    public static String toString(Alignment reference, Alignment proposed) {
        StringBuilder sb = new StringBuilder();
        List<String> sourceWords = reference.getSourceSentence();
        List<String> targetWords = reference.getTargetSentence();
        int sourcePosition = 0;
        while (sourcePosition < targetWords.size()) {
            int targetPosition = 0;
            while (targetPosition < sourceWords.size()) {
                boolean sure = reference.containsSureAlignment(targetPosition, sourcePosition);
                boolean possible = reference.containsPossibleAlignment(targetPosition, sourcePosition);
                char proposedChar = ' ';
                if (proposed.containsSureAlignment(targetPosition, sourcePosition)) {
                    proposedChar = '#';
                }
                if (sure) {
                    sb.append('[');
                    sb.append(proposedChar);
                    sb.append(']');
                } else if (possible) {
                    sb.append('(');
                    sb.append(proposedChar);
                    sb.append(')');
                } else {
                    sb.append(' ');
                    sb.append(proposedChar);
                    sb.append(' ');
                }
                ++targetPosition;
            }
            sb.append("| ");
            String fword = targetWords.get(sourcePosition);
            sb.append(fword);
            sb.append('\n');
            ++sourcePosition;
        }
        int targetPosition = 0;
        while (targetPosition < sourceWords.size()) {
            sb.append("---");
            ++targetPosition;
        }
        sb.append("'\n");
        int index = 0;
        boolean printed = true;
        while (printed) {
            printed = false;
            StringBuilder line = new StringBuilder();
            int targetPosition2 = 0;
            while (targetPosition2 < sourceWords.size()) {
                String targetWord = sourceWords.get(targetPosition2);
                if (targetWord.length() > index) {
                    printed = true;
                    line.append(' ');
                    line.append(targetWord.charAt(index));
                    line.append(' ');
                } else {
                    line.append("   ");
                }
                ++targetPosition2;
            }
            ++index;
            if (!printed) continue;
            sb.append((CharSequence)line);
            sb.append('\n');
        }
        return sb.toString();
    }

    public String output() {
        return this.dumpModifiedPharaoh(this.strengths != null && !this.strengths.isEmpty());
    }

    public String outputHard() {
        return this.dumpModifiedPharaoh(false);
    }

    public String outputSoft() {
        return this.dumpModifiedPharaoh(true);
    }

    private String dumpModifiedPharaoh(boolean soft) {
        StringBuffer sbuf = new StringBuffer();
        if (soft) {
            for (Pair<Integer, Integer> pair : this.strengths.keySet()) {
                double strength = this.strengths.get(pair);
                sbuf.append(pair.getSecond() + "-" + pair.getFirst() + "-" + strength);
                sbuf.append(" ");
            }
        } else {
            for (Pair<Integer, Integer> pair : this.sureAlignments) {
                sbuf.append(pair.getSecond() + "-" + pair.getFirst() + " ");
            }
            for (Pair<Integer, Integer> pair : this.possibleAlignments) {
                if (this.sureAlignments.contains(pair)) continue;
                sbuf.append(pair.getSecond() + "-" + pair.getFirst() + "-P ");
            }
        }
        return sbuf.toString();
    }

    public void parseAlignments(String line) {
        this.parseAlignments(line, false);
    }

    public void parseAlignments(String line, boolean reverse) {
        String noComment = line;
        String[] aligns = noComment.split(" ");
        int i = 0;
        while (i < aligns.length) {
            String[] els = aligns[i].split("-");
            int en = Integer.parseInt(reverse ? els[0] : els[1]);
            int fr = Integer.parseInt(reverse ? els[1] : els[0]);
            if (els.length == 2) {
                this.addAlignment(en, fr, true);
            } else if (els[2].equals("P")) {
                this.addAlignment(en, fr, false);
            } else {
                double strength = Double.parseDouble(els[2]);
                this.setStrength(en, fr, strength);
            }
            ++i;
        }
    }

    public List<Integer> getNullAlignedSourceIndices() {
        ArrayList<Integer> nulls = new ArrayList<Integer>();
        boolean[] hasAlignment = new boolean[this.getSourceLength()];
        for (Pair<Integer, Integer> al : this.sureAlignments) {
            hasAlignment[al.getFirst().intValue()] = true;
        }
        int en = 0;
        while (en < this.getSourceLength()) {
            if (!hasAlignment[en]) {
                nulls.add(en);
            }
            ++en;
        }
        return nulls;
    }

    public List<Integer> getNullAlignedTargetIndices() {
        ArrayList<Integer> nulls = new ArrayList<Integer>();
        boolean[] hasAlignment = new boolean[this.getTargetLength()];
        for (Pair<Integer, Integer> al : this.sureAlignments) {
            hasAlignment[al.getSecond().intValue()] = true;
        }
        int fr = 0;
        while (fr < this.getTargetLength()) {
            if (!hasAlignment[fr]) {
                nulls.add(fr);
            }
            ++fr;
        }
        return nulls;
    }

    private List<Integer> addOne(List<Integer> list) {
        ArrayList<Integer> newList = new ArrayList<Integer>();
        for (int x : list) {
            newList.add(x + 1);
        }
        return newList;
    }

    public void writeGIZA() {
        this.writeGIZA(-1);
    }

    public void writeGIZA(int idx) {
        this.writeGIZA(new PrintWriter(System.out, true), idx);
    }

    public void writeGIZA(PrintWriter out, int idx) {
        out.printf("# sentence pair (%d) source length %d target length %d alignment score : %e\n", idx, this.sourceSentence.size(), this.targetSentence.size(), this.score);
        out.println(Strings.join(this.targetSentence));
        out.printf("NULL ({ %s })", Strings.join(this.addOne(this.getNullAlignedTargetIndices())));
        int i = 0;
        while (i < this.sourceSentence.size()) {
            List<Integer> alignments = this.addOne(this.getAlignmentsOfSource(i));
            Collections.sort(alignments);
            out.printf(" %s ({ %s })", this.sourceSentence.get(i), Strings.join(alignments));
            ++i;
        }
        out.println("");
    }
}

