/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.ml.weka;

import java.util.Enumeration;
import weka.classifiers.bayes.NaiveBayes;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Utils;

public class MyNaiveBayes
extends NaiveBayes {
    private static final long serialVersionUID = 3347419939202056258L;

    public String printDistributionForInstance(Instance instance) throws Exception {
        StringBuffer buffer = new StringBuffer();
        if (this.m_UseDiscretization) {
            this.m_Disc.input(instance);
            instance = this.m_Disc.output();
        }
        double[] probs = new double[this.m_NumClasses];
        buffer.append("PRIORS:\n\n");
        int j = 0;
        while (j < this.m_NumClasses) {
            probs[j] = this.m_ClassDistribution.getProbability((double)j);
            buffer.append("  P(").append(instance.classAttribute().value(j)).append(")=").append(probs[j]).append("\n");
            ++j;
        }
        buffer.append("\n=====\n\nCONDITIONAL PROBS:\n\n");
        Enumeration enumAtts = instance.enumerateAttributes();
        int attIndex = 0;
        while (enumAtts.hasMoreElements()) {
            Attribute attribute = (Attribute)enumAtts.nextElement();
            if (!instance.isMissing(attribute)) {
                double max = 0.0;
                int j2 = 0;
                while (j2 < this.m_NumClasses) {
                    double temp = Math.max(1.0E-75, Math.pow(this.m_Distributions[attIndex][j2].getProbability(instance.value(attribute)), this.m_Instances.attribute(attIndex).weight()));
                    buffer.append("  P(").append(attribute.name()).append("=").append(instance.stringValue(attribute)).append("|").append(instance.classAttribute().value(j2)).append(")=").append(this.m_Distributions[attIndex][j2].getProbability(instance.value(attribute))).append("\n");
                    int n = j2;
                    probs[n] = probs[n] * temp;
                    if (probs[j2] > max) {
                        max = probs[j2];
                    }
                    if (Double.isNaN(probs[j2])) {
                        throw new Exception("NaN returned from estimator for attribute " + attribute.name() + ":\n" + this.m_Distributions[attIndex][j2].toString());
                    }
                    ++j2;
                }
                if (max > 0.0 && max < 1.0E-75) {
                    j2 = 0;
                    while (j2 < this.m_NumClasses) {
                        int n = j2++;
                        probs[n] = probs[n] * 1.0E75;
                    }
                }
                buffer.append("\n");
            }
            ++attIndex;
        }
        Utils.normalize((double[])probs);
        return buffer.toString();
    }
}

