/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.minipar;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.minipar.MiniparSentence;
import it.uniroma1.lcl.jlt.minipar.SyntacticRelation;
import it.uniroma1.lcl.jlt.util.Files;
import it.uniroma1.lcl.jlt.util.IntegerCounter;
import it.uniroma1.lcl.jlt.util.Triple;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;

public class MiniparSentenceIterator
implements Iterator<MiniparSentence> {
    protected String file;
    protected BufferedReader reader;
    protected MiniparSentence next;

    public MiniparSentenceIterator(String file) throws IOException {
        this.file = file;
        this.reader = Files.getBufferedReader(file);
    }

    @Override
    public boolean hasNext() {
        if (this.reader == null) {
            return false;
        }
        String line = "";
        StringBuffer sentence = new StringBuffer();
        try {
            while ((line = this.reader.readLine()) != null && !line.equals(")")) {
                sentence.append(String.valueOf(line) + "\n");
            }
            if (line == null) {
                this.reader.close();
                this.reader = null;
            } else if (line.equals(")")) {
                sentence.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (sentence.length() == 0) {
            return false;
        }
        this.next = new MiniparSentence(sentence.toString());
        return true;
    }

    @Override
    public MiniparSentence next() {
        return this.next;
    }

    @Override
    public void remove() {
    }

    public static void main(String[] args) throws IOException {
        String file = Configuration.getInstance().getSemeval07ParsedFilePath();
        System.out.println("Semeval07 dataset: " + file);
        IntegerCounter<SyntacticRelation> counter = new IntegerCounter<SyntacticRelation>();
        int totalSentencesNumber = 0;
        int emptySentences = 0;
        MiniparSentenceIterator iterator = new MiniparSentenceIterator(file);
        while (iterator.hasNext()) {
            HashSet<Triple<SyntacticRelation, String, String>> relations = iterator.next().getRelations();
            System.out.println(relations);
            ++totalSentencesNumber;
            if (relations.isEmpty()) {
                ++emptySentences;
            }
            for (Triple<SyntacticRelation, String, String> relation : relations) {
                counter.count(relation.getFirst());
            }
        }
        System.out.println("Total sentence number = " + totalSentencesNumber);
        System.out.println("Empty sentence number = " + emptySentences);
        System.out.println("Total relation number = " + counter.getTotal());
        System.out.println("Relation detail: = " + counter);
    }
}

