/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.minipar;

import com.google.api.Files;
import edu.mit.jwi.item.POS;
import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.minipar.SyntacticRelation;
import it.uniroma1.lcl.jlt.util.Strings;
import it.uniroma1.lcl.jlt.util.Triple;
import it.uniroma1.lcl.jlt.wordnet.WordNet;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MiniparSentence {
    protected static final Log log = LogFactory.getLog(MiniparSentence.class);
    protected String original;
    protected static HashMap<String, Set<String>> lexicon;
    protected boolean restrictToWordNet;
    protected static final String ID = "\\w+";
    protected static final String WORD = "[^\\t]+";
    protected static final String LEMMA = "[^\\t]+";
    protected static final String PoS = "\\w+";
    protected static final String ROLE = "[^\\t]+";
    protected static final String NUM_FATHER = "\\w+";
    protected static final String FATHER = "[^)]+";
    protected static final String LEFT_P = "\\(";
    protected static final String RIGHT_P = "\\)";
    protected static final String REGEX = "(\\w+)\\t\\(([^\\t]+)\\t([^\\t]+) (\\w+)\\t(\\w+)\\t([^\\t]+)\\t\\(gov ([^)]+)\\)\\)";
    protected static final Pattern p;
    protected boolean bSaveLexicalDistrib;
    protected HashSet<Triple<SyntacticRelation, String, String>> relations = new HashSet();
    protected HashMap<String, HashMap<String, String>> idWords = new HashMap();
    protected ArrayList<String> contentWords = new ArrayList();
    protected String originalSentence = "";
    protected String lemmaSentence = "";

    static {
        p = Pattern.compile(REGEX);
    }

    public MiniparSentence(String sentence) {
        this(sentence, true);
    }

    public MiniparSentence(String sentence, boolean bSaveLexicalDistrib) {
        this(sentence, bSaveLexicalDistrib, false);
    }

    /*
     * WARNING - void declaration
     */
    public MiniparSentence(String sentence, boolean bSaveLexicalDistrib, boolean bRestrictToWordNet) {
        void var5_15;
        this.restrictToWordNet = bRestrictToWordNet;
        if (lexicon == null && this.restrictToWordNet) {
            WordNet wn = WordNet.getInstance();
            lexicon = new HashMap();
            POS[] pOSArray = new POS[]{POS.NOUN, POS.VERB, POS.ADJECTIVE};
            int n = pOSArray.length;
            int n2 = 0;
            while (n2 < n) {
                POS pOS = pOSArray[n2];
                lexicon.put(String.valueOf(pOS.getTag()), wn.getAllWords(pOS));
                ++n2;
            }
            for (String string : lexicon.keySet()) {
                log.debug((Object)(String.valueOf(string) + " => " + lexicon.get(string).size()));
            }
        }
        this.original = sentence;
        this.bSaveLexicalDistrib = bSaveLexicalDistrib;
        String[] stringArray = sentence.split("\n");
        int n = stringArray.length;
        boolean bl = false;
        while (var5_15 < n) {
            String line = stringArray[var5_15];
            Matcher m = p.matcher(line);
            if (!m.find()) {
                log.debug((Object)("Skipping '" + line + "' because it did not match"));
            } else {
                String id = m.group(1).toLowerCase();
                String word = m.group(2).toLowerCase();
                if (!word.equals("()") && !word.startsWith("..")) {
                    String lemma = m.group(3).toLowerCase();
                    String pos = String.valueOf(m.group(4).toLowerCase().charAt(0));
                    String num_father = m.group(5);
                    String role = m.group(6).toLowerCase();
                    String father = m.group(7).toLowerCase();
                    String base_word = lemma.equals("~") ? word : lemma;
                    base_word = base_word.replaceAll("\"", "").replaceAll(" ", "_");
                    father = father.replaceAll("\"", "").replaceAll(" ", "_");
                    this.originalSentence = String.valueOf(this.originalSentence) + word + " ";
                    this.lemmaSentence = String.valueOf(this.lemmaSentence) + base_word + " ";
                    log.debug((Object)("ID=" + id + "\t" + Strings.rightFillWith(String.valueOf(base_word) + "#" + pos, ' ', 30) + "\tNUM_FATHER=" + Strings.rightFillWith(num_father, ' ', 20) + "\tROLE=" + Strings.rightFillWith(role, ' ', 20) + "\tFATHER=" + Strings.rightFillWith(father, ' ', 20)));
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("LEMMA", base_word);
                    properties.put("POS", pos);
                    properties.put("ROLE", role);
                    properties.put("FATHER_ID", num_father);
                    properties.put("FATHER", father);
                    this.idWords.put(id, properties);
                    if (bSaveLexicalDistrib && (pos.equals("n") || pos.equals("a") || pos.equals("v")) && (!bRestrictToWordNet || lexicon.get(pos).contains(base_word))) {
                        this.contentWords.add(base_word);
                    }
                }
            }
            ++var5_15;
        }
        this.originalSentence.trim();
        this.lemmaSentence.trim();
        log.debug(this.idWords);
    }

    public static String parseSentence(String sentence) {
        sentence = sentence.replaceAll("''|``", "");
        sentence = sentence.replaceAll("-", " ");
        sentence = sentence.replaceAll(" n't", "n't");
        String parsed = "";
        try {
            String dir = Configuration.getInstance().getMiniparDir();
            ProcessBuilder builder = new ProcessBuilder(String.valueOf(dir) + "pdemo/launchMinipar", dir, sentence);
            Process p = builder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                parsed = String.valueOf(parsed) + line + "\n";
            }
            p.destroy();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return parsed;
    }

    public void collectRelations() {
        this.relations.clear();
        for (String key : this.idWords.keySet()) {
            HashMap<String, String> items = this.idWords.get(key);
            String employee = items.get("LEMMA");
            String employee_role = items.get("ROLE");
            String employer_id = items.get("FATHER_ID");
            String employer = items.get("FATHER");
            if (!this.idWords.containsKey(employer_id)) {
                log.debug((Object)(String.valueOf(employee) + " has no father (?)"));
                continue;
            }
            String employee_pos = items.get("POS");
            String employee_pos_tag = String.valueOf(employee_pos.charAt(0));
            String employer_pos = this.idWords.get(employer_id).get("POS");
            String employer_pos_tag = String.valueOf(this.idWords.get(employer_id).get("POS").charAt(0));
            if (this.restrictToWordNet && lexicon.get(employee_pos_tag) == null) {
                log.debug((Object)("Skipping " + employee + " because of its pos: " + employee_pos));
                continue;
            }
            if (this.restrictToWordNet && !lexicon.get(employee_pos_tag).contains(employee)) {
                log.debug((Object)("Skipping " + employee + " because it does not belong to WN lexicon"));
                continue;
            }
            SyntacticRelation relation = null;
            if (employer_pos.startsWith("prep")) {
                HashMap<String, String> verb_map;
                HashMap<String, String> prep_map = this.idWords.get(employer_id);
                if (!prep_map.get("ROLE").equals("mod") || (verb_map = this.idWords.get(prep_map.get("FATHER_ID"))) == null || !verb_map.get("POS").startsWith("v")) continue;
                String super_employer = verb_map.get("LEMMA");
                String super_employer_pos = verb_map.get("POS");
                String super_employer_pos_tag = String.valueOf(super_employer_pos.charAt(0));
                if (this.restrictToWordNet && lexicon.get(super_employer_pos_tag) == null) {
                    log.debug((Object)("Skipping " + employee + " because of its grandfather's pos: " + super_employer_pos));
                    continue;
                }
                if (this.restrictToWordNet && !lexicon.get(super_employer_pos_tag).contains(String.valueOf(super_employer) + "_" + prep_map.get("LEMMA"))) {
                    log.debug((Object)("Skipping " + employer + " because its grandfather (" + super_employer + "_" + prep_map.get("LEMMA") + ") does not belong to WN lexicon"));
                    continue;
                }
                if (employee_pos.startsWith("n") && employee_role.equals("pcomp-n")) {
                    employer = String.valueOf(super_employer) + "_" + prep_map.get("LEMMA");
                    employer_pos = super_employer_pos;
                    employer_pos_tag = super_employer_pos_tag;
                    relation = SyntacticRelation.VERB_OBJ;
                }
            } else {
                if (this.restrictToWordNet && lexicon.get(employer_pos_tag) == null) {
                    log.debug((Object)("Skipping " + employee + " because of its father's pos: " + employer_pos));
                    continue;
                }
                if (this.restrictToWordNet && !lexicon.get(employer_pos_tag).contains(employer)) {
                    log.debug((Object)("Skipping " + employer + " because it does not belong to WN lexicon"));
                    continue;
                }
                if (employee_role.equals("s") && employer_pos.startsWith("v")) {
                    relation = SyntacticRelation.SUBJ_VERB;
                } else if ((employee_role.equals("obj") || employee_role.equals("desc")) && employee_pos.startsWith("n") && employer_pos.startsWith("v")) {
                    relation = SyntacticRelation.VERB_OBJ;
                } else if (employee_pos.startsWith("a") && employee_role.equals("mod") && employer_pos.startsWith("n")) {
                    relation = SyntacticRelation.ADJ_NOUN;
                    String aux = employer;
                    employer = employee;
                    employee = aux;
                    aux = employer_pos;
                    employer_pos = employee_pos;
                    employee_pos = aux;
                    aux = employer_pos_tag;
                    employer_pos_tag = employee_pos_tag;
                    employee_pos_tag = aux;
                }
            }
            if (relation == null) {
                log.debug((Object)("No relation found for this word " + employee));
                continue;
            }
            int previous = new Integer(key) - 1;
            HashMap<String, String> compound_map = this.idWords.get("" + previous);
            if (previous > 0 && compound_map != null && compound_map.get("FATHER_ID").equals(key) && (compound_map.get("POS").startsWith("n") || compound_map.get("POS").startsWith("v") || compound_map.get("POS").startsWith("a"))) {
                String try_compound = String.valueOf(compound_map.get("LEMMA")) + "_" + employee;
                if (this.restrictToWordNet && lexicon.get(employee_pos_tag) != null && lexicon.get(employee_pos_tag).contains(try_compound)) {
                    log.debug((Object)("[C] " + try_compound));
                    employee = try_compound;
                }
            }
            String employerWithPos = String.valueOf(employer) + "#" + employer_pos_tag;
            String employeeWithPos = String.valueOf(employee) + "#" + employee_pos_tag;
            log.debug((Object)(String.valueOf(employerWithPos) + "\t" + employeeWithPos + "\t" + (Object)((Object)relation) + "\t*"));
            Triple<SyntacticRelation, String, String> relationTriple = new Triple<SyntacticRelation, String, String>(relation, employerWithPos, employeeWithPos);
            this.relations.add(relationTriple);
        }
    }

    public String toString() {
        return this.original;
    }

    public HashSet<Triple<SyntacticRelation, String, String>> getRelations() {
        if (this.relations.isEmpty()) {
            this.collectRelations();
        }
        return this.relations;
    }

    public List<String> getContentWords() {
        return this.contentWords;
    }

    public String getLemmaSentence() {
        return this.lemmaSentence;
    }

    public String getOriginalSentence() {
        return this.originalSentence;
    }

    public List<String> getContentWords(String word, int windowSize) {
        String lemma = Strings.getLemma(word);
        ArrayList<String> selection = new ArrayList<String>();
        String[] words = this.getContentWords().toArray(new String[0]);
        int i = 0;
        while (i < words.length) {
            if (words[i].equalsIgnoreCase(lemma)) {
                int window_LEFT = Math.max(0, i - windowSize);
                int window_RIGHT = Math.min(words.length - 1, i + windowSize);
                int j = window_LEFT;
                while (j <= window_RIGHT) {
                    if (j != i) {
                        selection.add(words[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return selection;
    }

    public static void main(String[] args) throws IOException {
        MiniparSentence[] sentences;
        MiniparSentence sentence1 = new MiniparSentence(MiniparSentence.parseSentence("The woman was pushing for him to go to the supermarket."));
        MiniparSentence sentence2 = new MiniparSentence(MiniparSentence.parseSentence("This puzzle is too hard for me to solve."));
        MiniparSentence sentence3 = new MiniparSentence(MiniparSentence.parseSentence("I baked bread myself but I forgot to put some yeast in it."));
        MiniparSentence sentence4 = new MiniparSentence(MiniparSentence.parseSentence("Implicit in the convention is the idea that governments take account of each others' positions and actually negotiate."));
        MiniparSentence sentence5 = new MiniparSentence(MiniparSentence.parseSentence("This was done because of its Constitution and Recognition Agreement did not take account of the conditions in the country which could lead to misuse of the Union"));
        MiniparSentence sentence6 = new MiniparSentence(MiniparSentence.parseSentence("She wanted to go back home"));
        MiniparSentence sentence7 = new MiniparSentence(MiniparSentence.parseSentence("He pretended to go back in time."));
        MiniparSentence sentence8 = new MiniparSentence(MiniparSentence.parseSentence("I had to put the meeting off."));
        MiniparSentence sentence9 = new MiniparSentence(MiniparSentence.parseSentence("From a humanitarian point of view the number one objective I would like to see achieved is a ceasefire"));
        MiniparSentence sentence10 = new MiniparSentence(MiniparSentence.parseSentence("Would you like dancing with me?"));
        MiniparSentence sentence11 = new MiniparSentence(MiniparSentence.parseSentence("I'd like to see the biggest building in the city."));
        MiniparSentence sentence12 = new MiniparSentence(MiniparSentence.parseSentence("I could like him if he went easier on me."));
        MiniparSentence sentence13 = new MiniparSentence(MiniparSentence.parseSentence("I could help you finish your homework."));
        MiniparSentence sentence14 = new MiniparSentence(Files.read((File)new File("/home/flati/test")));
        MiniparSentence[] miniparSentenceArray = sentences = new MiniparSentence[]{sentence1, sentence2, sentence3, sentence4, sentence5, sentence6, sentence7, sentence8, sentence10, sentence11, sentence12, sentence13, sentence14, sentence9};
        int n = sentences.length;
        int n2 = 0;
        while (n2 < n) {
            MiniparSentence sentence = miniparSentenceArray[n2];
            log.info((Object)("PARSE TREE:\n" + sentence));
            log.info((Object)("ORIGINAL SENTENCE: " + sentence.getOriginalSentence()));
            log.info((Object)("LEMMA SENTENCE: " + sentence.getLemmaSentence()));
            log.info((Object)("CONTENT WORDS: " + sentence.getContentWords()));
            log.info((Object)"RELATIONS: ");
            for (Triple<SyntacticRelation, String, String> relation : sentence.getRelations()) {
                log.info((Object)("REL:" + relation));
                log.info((Object)("CONTENT WORDS (|w|=2) = " + sentence.getContentWords(relation.getSecond(), 2)));
            }
            ++n2;
        }
    }
}

