/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.matrix;

import it.uniroma1.lcl.jlt.matrix.VectorComposition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jblas.DoubleMatrix;

public class SentenceToVector {
    protected DoubleMatrix matrix;
    protected List<String> lexicon;

    public SentenceToVector(DoubleMatrix matrix, List<String> lexicon) {
        this.matrix = matrix;
        this.lexicon = lexicon;
    }

    public DoubleMatrix convertSentence(Collection<String> sentence, VectorComposition method) {
        ArrayList<DoubleMatrix> vectors = new ArrayList<DoubleMatrix>();
        for (String word : sentence) {
            DoubleMatrix vector = this.convertWord(word);
            if (vector == null) continue;
            vectors.add(vector);
        }
        DoubleMatrix sentence_vector = null;
        switch (method) {
            case ADDITIVE: {
                sentence_vector = DoubleMatrix.zeros((int)this.lexicon.size()).transpose();
                for (DoubleMatrix v : vectors) {
                    sentence_vector = sentence_vector.add(v);
                }
                break;
            }
            case MULTIPLICATIVE: {
                sentence_vector = DoubleMatrix.ones((int)this.lexicon.size()).transpose();
                for (DoubleMatrix v : vectors) {
                    sentence_vector = sentence_vector.mul(v);
                }
                break;
            }
        }
        return sentence_vector;
    }

    public DoubleMatrix convertWord(String word) {
        int word_index = this.lexicon.indexOf(word);
        if (word_index == -1) {
            return null;
        }
        return this.matrix.getRow(word_index);
    }

    public List<String> convertVectorToWords(DoubleMatrix v) {
        int[] nonzeros = v.findIndices();
        ArrayList<String> words = new ArrayList<String>(nonzeros.length);
        int[] nArray = nonzeros;
        int n = nonzeros.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            words.add(this.lexicon.get(index));
            ++n2;
        }
        return words;
    }
}

