/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.matrix;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.jblas.DoubleMatrix;

public class JLTMatrix
extends DoubleMatrix {
    private static final long serialVersionUID = 356811410664726253L;

    public static void exportToTxt(DoubleMatrix m, String filename) throws IOException {
        BufferedWriter wr = new BufferedWriter(new FileWriter(filename));
        int M = m.getRows();
        int N = m.getColumns();
        int NZ = m.findIndices().length;
        wr.write(String.valueOf(M) + " ");
        wr.write(String.valueOf(N) + " ");
        wr.write(String.valueOf(NZ) + "\n");
        int j = 0;
        while (j < N) {
            DoubleMatrix j_col = m.getColumn(j);
            int[] j_indices = j_col.findIndices();
            wr.write(String.valueOf(j_indices.length) + "\n");
            int[] nArray = j_indices;
            int n = j_indices.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                double value = m.get(i, j);
                if (value == Double.NEGATIVE_INFINITY) {
                    value = Double.MIN_VALUE;
                }
                if (value == Double.POSITIVE_INFINITY) {
                    value = Double.MAX_VALUE;
                }
                wr.write(String.valueOf(i) + " " + value + "\n");
                ++n2;
            }
            ++j;
        }
        wr.close();
    }

    public static double cos_sim(DoubleMatrix v1, DoubleMatrix v2) {
        double norm_v1 = v1.norm2();
        double norm_v2 = v2.norm2();
        return JLTMatrix.cos_sim(v1, norm_v1, v2, norm_v2);
    }

    public static double cos_sim(DoubleMatrix v1, double norm1, DoubleMatrix v2, double norm2) {
        double dot_prod = v1.dot(v2);
        return dot_prod / (norm1 * norm2);
    }

    public static void main(String[] args) {
        DoubleMatrix matrix = new DoubleMatrix(5, 3);
        matrix.put(0, 0, 1.92);
        matrix.put(3, 0, 3.69787);
        matrix.put(2, 2, 7.494);
        matrix.put(4, 2, 0.489742);
        matrix.getRow(3).print();
        matrix.print();
        System.out.println("Matrix: " + matrix);
        System.out.println("Matrix: " + matrix.toString("%.1f"));
        System.out.println("Matrix 1: " + DoubleMatrix.ones((int)5).getRow(3));
        System.out.println("Matrix 0: " + DoubleMatrix.zeros((int)5));
    }
}

